/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.Config;
import bluej.editor.Editor;
import bluej.editor.EditorManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.target.NonCodeEditableTarget;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.util.Properties;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import threadchecker.OnThread;
import threadchecker.Tag;

public class CSSTarget
extends NonCodeEditableTarget {
    private static final String openStr = Config.getString("pkgmgr.cssmenu.open");
    private static final String removeStr = Config.getString("pkgmgr.cssmenu.remove");
    private final File file;

    public CSSTarget(Package aPackage, File file) {
        super(aPackage, file.getName());
        this.file = file;
        JavaFXUtil.addStyleClass((Styleable)this.pane, "css-target");
        JavaFXUtil.addStyleClass((Styleable)this.pane, "css-target-id-" + file.getName().replace(".", "-"));
        Label name = new Label(file.getName());
        BorderPane.setAlignment((Node)name, (Pos)Pos.CENTER);
        this.pane.setTop((Node)name);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void doubleClick(boolean openInNewWindow) {
        Editor editor = this.getEditor();
        if (editor == null) {
            this.getPackage().showError("error-open-source");
        } else {
            editor.setEditorVisible(true, openInNewWindow);
        }
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void popupMenu(int x, int y, PackageEditor graphEditor) {
        ContextMenu menu = this.createMenu();
        if (menu != null) {
            this.showingMenu(menu);
            menu.show((Node)this.pane, (double)x, (double)y);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private ContextMenu createMenu() {
        MenuItem open = new MenuItem(openStr);
        open.setOnAction(e -> this.open());
        JavaFXUtil.addStyleClass((Styleable)open, "class-action-inbuilt");
        ContextMenu contextMenu = new ContextMenu(new MenuItem[]{open});
        MenuItem remove = new MenuItem(removeStr);
        remove.setOnAction(e -> this.remove());
        JavaFXUtil.addStyleClass((Styleable)remove, "class-action-inbuilt");
        contextMenu.getItems().add((Object)remove);
        return contextMenu;
    }

    @Override
    public void remove() {
        this.getPackage().removeTarget(this);
        this.file.delete();
    }

    @Override
    protected File getSourceFile() {
        return this.file;
    }

    @Override
    public Editor getEditor() {
        if (this.editor == null) {
            this.editor = EditorManager.getEditorManager().openText(this.getSourceFile().getPath(), this.getPackage().getProject().getProjectCharset(), this.getSourceFile().getName(), this.getPackage().getProject()::getDefaultFXTabbedEditor);
        }
        return this.editor;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public boolean isMoveable() {
        return true;
    }

    @Override
    @OnThread(value=Tag.FX)
    public boolean isResizable() {
        return true;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(prefix + ".type", "CSSTarget");
    }
}

