/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.dependency;

import bluej.extensions.BDependency;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.target.DependentTarget;
import bluej.utility.Utility;
import java.util.Properties;
import javafx.geometry.Point2D;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class UsesDependency
extends Dependency {
    private double sourceX;
    private double sourceY;
    private double destX;
    private double destY;
    private boolean startTop;
    private boolean endLeft;

    @OnThread(value=Tag.Any)
    public UsesDependency(Package pkg, DependentTarget from, DependentTarget to) {
        super(pkg, from, to);
    }

    @OnThread(value=Tag.Any)
    public UsesDependency(Package pkg) {
        this(pkg, (DependentTarget)null, null);
    }

    @OnThread(value=Tag.Any)
    public UsesDependency(Package pkg, Properties props, String prefix) throws Dependency.DependencyNotFoundException {
        super(pkg, props, prefix);
    }

    public void setSourceCoords(double src_x, double src_y, boolean start_top) {
        this.sourceX = Utility.roundHalf(src_x);
        this.sourceY = Utility.roundHalf(src_y);
        this.setStartTop(start_top);
    }

    public void setDestCoords(double dst_x, double dst_y, boolean end_left) {
        this.destX = Utility.roundHalf(dst_x);
        this.destY = Utility.roundHalf(dst_y);
        this.setEndLeft(end_left);
    }

    static final boolean inRect(double x, double y, double x0, double y0, double x1, double y1) {
        double xmin = Math.min(x0, x1);
        double xmax = Math.max(x0, x1);
        double ymin = Math.min(y0, y1);
        double ymax = Math.max(y0, y1);
        return xmin <= x && ymin <= y && x < xmax && y < ymax;
    }

    @Override
    public boolean contains(int x, int y) {
        double src_x = this.sourceX;
        double src_y = this.sourceY;
        double dst_x = this.destX;
        double dst_y = this.destY;
        double corner_y = src_y + (double)(this.isStartTop() ? -15 : 15);
        if (UsesDependency.inRect(x, y, src_x - 4.0, corner_y, src_x + 4.0, src_y)) {
            return true;
        }
        src_y = corner_y;
        double corner_x = dst_x + (double)(this.isEndLeft() ? -15 : 15);
        if (UsesDependency.inRect(x, y, corner_x, dst_y - 4.0, dst_x, dst_y + 4.0)) {
            return true;
        }
        dst_x = corner_x;
        if (src_y != dst_y && this.isStartTop() == src_y < dst_y) {
            corner_x = (src_x + dst_x) / 2.0 + (double)(this.isEndLeft() ? 15 : -15);
            double d = corner_x = this.isEndLeft() ? Math.min(dst_x, corner_x) : Math.max(dst_x, corner_x);
            if (UsesDependency.inRect(x, y, src_x, src_y - 4.0, corner_x, src_y + 4.0)) {
                return true;
            }
            src_x = corner_x;
        }
        if (src_x != dst_x && this.isEndLeft() == src_x > dst_x) {
            corner_y = (src_y + dst_y) / 2.0 + (double)(this.isStartTop() ? 15 : -15);
            double d = corner_y = this.isStartTop() ? Math.min(src_y, corner_y) : Math.max(src_y, corner_y);
            if (UsesDependency.inRect(x, y, dst_x - 4.0, corner_y, dst_x + 4.0, dst_y)) {
                return true;
            }
            dst_y = corner_y;
        }
        return UsesDependency.inRect(x, y, src_x - 4.0, src_y, src_x + 4.0, dst_y) || UsesDependency.inRect(x, y, src_x, dst_y - 4.0, dst_x, dst_y + 4.0);
    }

    @Override
    public Dependency.Line computeLine() {
        return new Dependency.Line(new Point2D(this.sourceX, this.sourceY), new Point2D(this.destX, this.destY), 0.0);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void save(Properties props, String prefix) {
        super.save(props, prefix);
        props.put(prefix + ".type", "UsesDependency");
    }

    @Override
    public void remove() {
        this.pkg.removeArrow(this);
    }

    public double getSourceX() {
        return this.sourceX;
    }

    public double getSourceY() {
        return this.sourceY;
    }

    public double getDestX() {
        return this.destX;
    }

    public double getDestY() {
        return this.destY;
    }

    public void setStartTop(boolean startTop) {
        this.startTop = startTop;
    }

    public boolean isStartTop() {
        return this.startTop;
    }

    public void setEndLeft(boolean endLeft) {
        this.endLeft = endLeft;
    }

    public boolean isEndLeft() {
        return this.endLeft;
    }

    public boolean isResizable() {
        return false;
    }

    @Override
    @OnThread(value=Tag.Any)
    public BDependency.Type getType() {
        return BDependency.Type.USES;
    }

    @Override
    public boolean isRemovable() {
        return false;
    }
}

