/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.actions;

import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.actions.PkgMgrAction;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javafx.stage.Window;

public class InteractiveTutorialAction
extends PkgMgrAction {
    public InteractiveTutorialAction(PkgMgrFrame pmf) {
        super(pmf, "menu.help.tutorial");
    }

    @Override
    public void actionPerformed(PkgMgrFrame pmf) {
        pmf.menuCall();
        try {
            File dir = Files.createTempDirectory("tutorial", new FileAttribute[0]).toFile();
            dir.deleteOnExit();
            dir = new File(dir, "tutorial");
            int result = FileUtility.copyDirectory(new File(Config.getBlueJLibDir(), "tutorial"), dir);
            switch (result) {
                case 0: {
                    PkgMgrFrame.doOpen(dir, pmf);
                    break;
                }
                case 4: {
                    DialogManager.showErrorFX(null, "directory-exists-file");
                    break;
                }
                case 5: {
                    DialogManager.showErrorFX(null, "directory-exists-non-empty");
                    break;
                }
                case 2: 
                case 3: {
                    DialogManager.showErrorFX(null, "cannot-save-project");
                }
            }
        }
        catch (IOException e) {
            DialogManager.showErrorTextFX((Window)pmf.getFXWindow(), e.getLocalizedMessage());
        }
    }
}

