/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.extensions.BDependency;
import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionsManager;
import bluej.extmgr.FXMenuManager;
import bluej.extmgr.PackageExtensionMenu;
import bluej.graph.SelectionController;
import bluej.pkgmgr.MouseTrackingOverlayPane;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PackageListener;
import bluej.pkgmgr.PackageUI;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.Target;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.ResizableCanvas;
import bluej.views.CallableView;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.binding.DoubleExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.swing.SwingUtilities;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public final class PackageEditor
extends StackPane
implements MouseTrackingOverlayPane.MousePositionListener,
PkgMgrFrame.PkgMgrPane,
PackageListener,
PackageUI {
    private static final int RIGHT_PLACEMENT_MIN = 300;
    private static final int WHITESPACE_SIZE = 10;
    public static final int GRID_SIZE = 10;
    private final PkgMgrFrame pmf;
    private final Package pkg;
    private final SelectionController selectionController;
    private final BooleanProperty showExtends;
    private final BooleanProperty showUses;
    private final AnchorPane frontClassLayer = new AnchorPaneExtraSpacing();
    private final AnchorPane backClassLayer = new AnchorPane();
    private final Pane selectionLayer = new Pane();
    protected Label noClassesExistedMessage;
    private final Canvas arrowLayer = new ResizableCanvas();
    private boolean aboutToRepaint = false;
    private @OnThread(value=Tag.FXPlatform) ContextMenu showingContextMenu;
    private @OnThread(value=Tag.FXPlatform) MouseTrackingOverlayPane overlay;
    private @OnThread(value=Tag.FXPlatform) Label arrowCreationTip;
    private @OnThread(value=Tag.FXPlatform) boolean creatingExtends = false;
    private @OnThread(value=Tag.FXPlatform) ClassTarget extendsSubClass;
    private @OnThread(value=Tag.FXPlatform) ClassTarget extendsSuperClassHover;
    private @OnThread(value=Tag.FXPlatform) double newExtendsDestX;
    private @OnThread(value=Tag.FXPlatform) double newExtendsDestY;
    private static final int ARROW_SIZE = 18;
    private static final double ARROW_ANGLE = 0.5235987755982988;
    private static final double[] DASHES = new double[]{5.0, 2.0};

    @OnThread(value=Tag.FXPlatform)
    public PackageEditor(PkgMgrFrame pmf, Package pkg, BooleanProperty showUses, BooleanProperty showInherits, MouseTrackingOverlayPane overlay) {
        this.pmf = pmf;
        this.pkg = pkg;
        this.selectionController = new SelectionController(this);
        this.showUses = showUses;
        this.showExtends = showInherits;
        this.overlay = overlay;
        this.selectionController.addSelectionListener(sel -> pmf.notifySelectionChanged((Collection<Target>)sel));
        JavaFXUtil.addStyleClass((Styleable)this, "class-diagram");
        this.frontClassLayer.setBackground(null);
        this.backClassLayer.setBackground(null);
        this.frontClassLayer.setPickOnBounds(false);
        JavaFXUtil.addChangeListenerPlatform(this.arrowLayer.widthProperty(), s -> this.repaint());
        JavaFXUtil.addChangeListenerPlatform(this.arrowLayer.heightProperty(), s -> this.repaint());
        this.selectionLayer.setMouseTransparent(true);
        Rectangle rect = this.selectionController.getMarquee().getRectangle();
        JavaFXUtil.addStyleClass((Styleable)rect, "marquee");
        this.selectionLayer.getChildren().add((Object)rect);
        this.noClassesExistedMessage = new Label(Config.getString("pkgmgr.noClassesExisted.message"));
        this.noClassesExistedMessage.setVisible(false);
        JavaFXUtil.addStyleClass((Styleable)this.noClassesExistedMessage, "pmf-no-classes-msg");
        this.getChildren().addAll((Object[])new Node[]{this.arrowLayer, this.backClassLayer, this.frontClassLayer, this.selectionLayer, this.noClassesExistedMessage});
        JavaFXUtil.addChangeListener(showUses, e -> JavaFXUtil.runNowOrLater(this::repaint));
        JavaFXUtil.addChangeListener(this.showExtends, e -> JavaFXUtil.runNowOrLater(this::repaint));
        this.addEventFilter(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE && this.creatingExtends) {
                this.stopNewInherits();
            }
        });
        this.setPrefHeight(400.0);
    }

    @OnThread(value=Tag.FXPlatform)
    public void benchToFixture(ClassTarget t) {
        this.pmf.objectBenchToTestFixture(t);
    }

    @OnThread(value=Tag.FXPlatform)
    public void fixtureToBench(ClassTarget t) {
        this.pmf.testFixtureToObjectBench(t);
    }

    @OnThread(value=Tag.FXPlatform)
    public void makeTestCase(ClassTarget t) {
        this.pmf.makeTestCase(t);
    }

    @OnThread(value=Tag.FXPlatform)
    public void runTest(ClassTarget ct, String name) {
        ct.getRole().run(this.pmf, ct, name);
    }

    @OnThread(value=Tag.FXPlatform)
    public void openPackage(String packageName) {
        this.pmf.openPackageTarget(packageName);
    }

    @OnThread(value=Tag.FXPlatform)
    public void raisePutOnBenchEvent(Window src, DebuggerObject obj, GenTypeClass iType, InvokerRecord ir, boolean askForName, Optional<Point2D> animateFromScenePoint) {
        this.pmf.putObjectOnBench(src, obj, iType, ir, askForName, animateFromScenePoint);
    }

    @OnThread(value=Tag.FXPlatform)
    public void recordInteraction(InvokerRecord ir) {
        this.pmf.recordInteraction(ir);
    }

    private boolean popupMenu(double screenX, double screenY) {
        ContextMenu menu = new ContextMenu();
        Point2D graphLoc = this.screenToLocal(screenX, screenY);
        for (Dependency d : this.getVisibleEdges()) {
            if (!d.isRemovable() || !d.contains((int)graphLoc.getX(), (int)graphLoc.getY())) continue;
            MenuItem removeEdge = new MenuItem(Config.getString("menu.edit.remove"));
            removeEdge.setOnAction(e -> d.remove());
            JavaFXUtil.addStyleClass((Styleable)removeEdge, "class-action-inbuilt");
            menu.setOnShowing(e -> d.setSelected(true));
            menu.setOnHiding(e -> d.setSelected(false));
            menu.getItems().add((Object)removeEdge);
            this.showingMenu(menu);
            menu.show((Node)this, screenX, screenY);
            return true;
        }
        MenuItem newClass = new MenuItem(Config.getString("menu.edit.newClass"));
        newClass.setOnAction(e -> {
            this.pmf.menuCall();
            this.pmf.doCreateNewClass(graphLoc.getX(), graphLoc.getY());
        });
        JavaFXUtil.addStyleClass((Styleable)newClass, "class-action-inbuilt");
        MenuItem newPackage = new MenuItem(Config.getString("menu.edit.newPackage"));
        newPackage.setOnAction(e -> {
            this.pmf.menuCall();
            this.pmf.doCreateNewPackage(graphLoc.getX(), graphLoc.getY());
        });
        JavaFXUtil.addStyleClass((Styleable)newPackage, "class-action-inbuilt");
        MenuItem newCSS = new MenuItem(Config.getString("menu.edit.newCSS"));
        newCSS.setOnAction(e -> {
            this.pmf.menuCall();
            this.pmf.doCreateNewCSS(graphLoc.getX(), graphLoc.getY());
        });
        JavaFXUtil.addStyleClass((Styleable)newCSS, "class-action-inbuilt");
        MenuItem addClassFromFile = new MenuItem(Config.getString("menu.edit.addClass"));
        addClassFromFile.setOnAction(e -> {
            this.pmf.menuCall();
            this.pmf.doAddFromFile();
        });
        JavaFXUtil.addStyleClass((Styleable)addClassFromFile, "class-action-inbuilt");
        menu.getItems().addAll((Object[])new MenuItem[]{newClass, newPackage, newCSS, addClassFromFile});
        SwingUtilities.invokeLater(() -> {
            ExtensionsManager extMgr = ExtensionsManager.getInstance();
            PackageExtensionMenu menuGenerator = new PackageExtensionMenu(this.pkg);
            Platform.runLater(() -> {
                FXMenuManager menuManager = new FXMenuManager(menu, extMgr, (ExtensionMenu)menuGenerator);
                SwingUtilities.invokeLater(() -> {
                    menuManager.addExtensionMenu(this.pkg.getProject());
                    Platform.runLater(() -> {
                        this.showingMenu(menu);
                        menu.show((Node)this, screenX, screenY);
                    });
                });
            });
        });
        return true;
    }

    private void showingMenu(ContextMenu menu) {
        if (this.showingContextMenu != null) {
            this.showingContextMenu.hide();
        }
        this.showingContextMenu = menu;
    }

    @OnThread(value=Tag.FXPlatform)
    public Window getFXWindow() {
        return this.pmf.getFXWindow();
    }

    public void findSpaceForVertex(Target t) {
        Area a = new Area();
        for (Target vertex : this.pkg.getVertices()) {
            if (vertex == t) continue;
            java.awt.Rectangle vr = new java.awt.Rectangle(vertex.getX(), vertex.getY(), vertex.getWidth(), vertex.getHeight());
            a.add(new Area(vr));
        }
        double minWidth = 300.0;
        double minHeight = 200.0;
        if (300.0 > minWidth) {
            minWidth = 300.0;
        }
        java.awt.Rectangle targetRect = new java.awt.Rectangle(t.getWidth() + 20, t.getHeight() + 20);
        int y = 0;
        while ((double)y < 2.0 * minHeight) {
            int x = 0;
            while ((double)x < minWidth - (double)t.getWidth() - 20.0) {
                targetRect.setLocation(x, y);
                if (!a.intersects(targetRect)) {
                    t.setPos(x + 10, y + 10);
                    return;
                }
                x += 10;
            }
            y += 10;
        }
        t.setPos(10, (int)minHeight + 10);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void graphChanged() {
        HashMap<Node, Boolean> keep = new HashMap<Node, Boolean>();
        for (Node node : this.frontClassLayer.getChildren()) {
            keep.put(node, false);
        }
        for (Node node : this.backClassLayer.getChildren()) {
            keep.put(node, false);
        }
        for (Target target : this.pkg.getVertices()) {
            if (!keep.containsKey(target.getNode())) {
                (target.isFront() ? this.frontClassLayer : this.backClassLayer).getChildren().add((Object)target.getNode());
                if (target.isSelected()) {
                    this.selectionController.addToSelection(target);
                }
            }
            keep.put(target.getNode(), true);
        }
        for (Map.Entry entry : keep.entrySet()) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            this.frontClassLayer.getChildren().remove(entry.getKey());
            this.backClassLayer.getChildren().remove(entry.getKey());
        }
        this.pmf.graphChanged();
        this.repaint();
    }

    @Override
    public void graphClosed() {
    }

    public void repaint() {
        if (!this.aboutToRepaint) {
            this.aboutToRepaint = true;
            JavaFXUtil.runAfterCurrent(this::actualRepaint);
        }
    }

    public void setMouseIn(Target target) {
        if (this.creatingExtends && this.extendsSubClass != null && target instanceof ClassTarget) {
            this.extendsSuperClassHover = (ClassTarget)target;
        }
    }

    public void setMouseLeft(Target target) {
        if (this.extendsSuperClassHover == target) {
            this.extendsSuperClassHover = null;
        }
    }

    public void checkForLossOfFocus() {
        JavaFXUtil.runAfterCurrent(() -> {
            if (!this.targetHasFocus() && this.getFXWindow().isFocused()) {
                this.selectionController.clearSelection();
            }
        });
    }

    public boolean targetHasFocus() {
        return this.pkg.getVertices().stream().anyMatch(Target::isFocused);
    }

    public boolean focusSelectedOrArbitrary() {
        if (this.selectionController.getSelection().isEmpty()) {
            if (this.pkg.getVertices().isEmpty()) {
                return false;
            }
            this.pkg.getVertices().get(0).requestFocus();
            return true;
        }
        this.selectionController.getSelection().get(0).requestFocus();
        return true;
    }

    public boolean isCreatingExtends() {
        return this.creatingExtends;
    }

    private void actualRepaint() {
        this.aboutToRepaint = false;
        ArrayList<Dependency> extendsDeps = this.isShowExtends() ? new ArrayList<Dependency>(this.pkg.getExtendsArrows()) : Collections.emptyList();
        ArrayList<UsesDependency> usesDeps = this.isShowUses() ? new ArrayList<UsesDependency>(this.pkg.getUsesArrows()) : Collections.emptyList();
        ArrayList<ExtendsDepInfo> extendsLines = new ArrayList<ExtendsDepInfo>(Utility.mapList(extendsDeps, ExtendsDepInfo::new));
        if (this.extendsSubClass != null) {
            if (this.extendsSuperClassHover != null) {
                extendsLines.add(new ExtendsDepInfo(this.extendsSubClass, this.extendsSuperClassHover));
            } else {
                Point2D p = this.arrowLayer.sceneToLocal(this.newExtendsDestX, this.newExtendsDestY);
                extendsLines.add(new ExtendsDepInfo(this.extendsSubClass, p.getX(), p.getY()));
            }
        }
        GraphicsContext g = this.arrowLayer.getGraphicsContext2D();
        g.clearRect(0.0, 0.0, this.arrowLayer.getWidth(), this.arrowLayer.getHeight());
        for (ExtendsDepInfo extendsDepInfo : extendsLines) {
            g.setStroke((Paint)(extendsDepInfo.creating ? Color.BLUE : Color.BLACK));
            g.setLineWidth(extendsDepInfo.selected ? 3.0 : 1.0);
            Dependency.Line line = extendsDepInfo.line;
            double fromY = line.from.getY();
            double fromX = line.from.getX();
            double toY = line.to.getY();
            double toX = line.to.getX();
            double angle = Math.atan2(-(fromY - toY), fromX - toX);
            double arrowJoinX = toX + 16.0 * Math.cos(angle);
            double arrowJoinY = toY - 16.0 * Math.sin(angle);
            double[] xPoints = new double[]{toX, toX + 18.0 * Math.cos(angle + 0.5235987755982988), toX + 18.0 * Math.cos(angle - 0.5235987755982988)};
            double[] yPoints = new double[]{toY, toY - 18.0 * Math.sin(angle + 0.5235987755982988), toY - 18.0 * Math.sin(angle - 0.5235987755982988)};
            g.setLineDashes(new double[0]);
            g.strokePolygon(xPoints, yPoints, 3);
            if (extendsDepInfo.type == BDependency.Type.IMPLEMENTS) {
                g.setLineDashes(DASHES);
            } else {
                g.setLineDashes(new double[0]);
            }
            g.strokeLine(fromX, fromY, arrowJoinX, arrowJoinY);
        }
        for (UsesDependency usesDependency : usesDeps) {
            g.setLineWidth(1.0);
            g.setLineDashes(DASHES);
            double src_x = usesDependency.getSourceX();
            double src_y = usesDependency.getSourceY();
            double dst_x = usesDependency.getDestX();
            double dst_y = usesDependency.getDestY();
            g.setStroke((Paint)Color.BLACK);
            int delta_x = usesDependency.isEndLeft() ? -10 : 10;
            g.strokeLine(dst_x, dst_y, dst_x + (double)delta_x, dst_y + 4.0);
            g.strokeLine(dst_x, dst_y, dst_x + (double)delta_x, dst_y - 4.0);
            g.setLineDashes(DASHES);
            double corner_y = src_y + (double)(usesDependency.isStartTop() ? -15 : 15);
            g.strokeLine(src_x, corner_y, src_x, src_y);
            src_y = corner_y;
            double corner_x = dst_x + (double)(usesDependency.isEndLeft() ? -15 : 15);
            g.strokeLine(corner_x, dst_y, dst_x, dst_y);
            dst_x = corner_x;
            if (src_y != dst_y && usesDependency.isStartTop() == src_y < dst_y) {
                corner_x = Utility.roundHalf((src_x + dst_x) / 2.0 + (double)(usesDependency.isEndLeft() ? 15 : -15));
                corner_x = usesDependency.isEndLeft() ? Math.min(dst_x, corner_x) : Math.max(dst_x, corner_x);
                g.strokeLine(src_x, src_y, corner_x, src_y);
                src_x = corner_x;
            }
            if (src_x != dst_x && usesDependency.isEndLeft() == src_x > dst_x) {
                corner_y = Utility.roundHalf((src_y + dst_y) / 2.0 + (double)(usesDependency.isStartTop() ? 15 : -15));
                corner_y = usesDependency.isStartTop() ? Math.min(src_y, corner_y) : Math.max(src_y, corner_y);
                g.strokeLine(dst_x, corner_y, dst_x, dst_y);
                dst_y = corner_y;
            }
            g.strokeLine(src_x, src_y, src_x, dst_y);
            g.strokeLine(src_x, dst_y, dst_x, dst_y);
        }
    }

    public void clearSelection() {
        this.selectionController.clearSelection();
    }

    public void addToSelection(Target element) {
        this.selectionController.addToSelection(element);
    }

    public void toggleSelection(Target element) {
        if (!element.isSelected()) {
            this.selectionController.addToSelection(element);
        } else {
            this.selectionController.removeFromSelection(element);
        }
    }

    @OnThread(value=Tag.Any)
    public Package getPackage() {
        return this.pkg;
    }

    public void startMouseListening() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> this.showingMenu(null));
        this.addEventHandler(MouseEvent.MOUSE_DRAGGED, this.selectionController::mouseDragged);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, this.selectionController::mouseClicked);
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, this.selectionController::mousePressed);
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, this.selectionController::mouseReleased);
        JavaFXUtil.listenForContextMenu((Node)this, this::popupMenu, new KeyCode[0]);
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized Collection<Dependency> getVisibleEdges() {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        if (this.isShowUses()) {
            deps.addAll(this.pkg.getUsesArrows());
        }
        if (this.isShowExtends()) {
            deps.addAll(this.pkg.getExtendsArrows());
        }
        return deps;
    }

    @OnThread(value=Tag.SwingIsFX)
    public synchronized Dependency getDependency(DependentTarget origin, DependentTarget target, BDependency.Type type) {
        List<Dependency> dependencies;
        switch (type) {
            case USES: {
                dependencies = this.pkg.getUsesArrows();
                break;
            }
            case IMPLEMENTS: 
            case EXTENDS: {
                dependencies = this.pkg.getExtendsArrows();
                break;
            }
            default: {
                return null;
            }
        }
        for (Dependency dependency : dependencies) {
            DependentTarget from = dependency.getFrom();
            DependentTarget to = dependency.getTo();
            if (!from.equals(origin) || !to.equals(target)) continue;
            return dependency;
        }
        return null;
    }

    public void setShowUses(boolean state) {
        this.showUses.set(state);
    }

    public void setShowExtends(boolean state) {
        this.showExtends.set(state);
    }

    public boolean isShowUses() {
        return this.showUses.get();
    }

    public boolean isShowExtends() {
        return this.showExtends.get();
    }

    public void clearState() {
        if (this.creatingExtends) {
            this.stopNewInherits();
        }
    }

    public void doNewInherits() {
        if (!this.creatingExtends) {
            this.arrowCreationTip = new Label(Config.getString("pkgmgr.chooseInhFrom"));
            JavaFXUtil.addStyleClass((Styleable)this.arrowCreationTip, "pmf-create-extends-tip");
            this.overlay.addMouseTrackingOverlay((Node)this.arrowCreationTip, false, (DoubleExpression)new ReadOnlyDoubleWrapper(5.0), (DoubleExpression)this.arrowCreationTip.heightProperty().negate().add(-5.0));
            this.creatingExtends = true;
            this.extendsSubClass = null;
            JavaFXUtil.setPseudoclass("bj-drawing-extends", true, new Node[]{this});
            for (Target t : this.pkg.getVertices()) {
                t.setCreatingExtends(true);
            }
            this.repaint();
        }
    }

    private void stopNewInherits() {
        this.overlay.removeMouseListener(this);
        this.overlay.remove((Node)this.arrowCreationTip);
        this.arrowCreationTip = null;
        this.creatingExtends = false;
        this.extendsSubClass = null;
        this.extendsSuperClassHover = null;
        JavaFXUtil.setPseudoclass("bj-drawing-extends", false, new Node[]{this});
        for (Target t : this.pkg.getVertices()) {
            t.setCreatingExtends(false);
        }
        this.repaint();
    }

    public boolean doRemoveDependency() {
        return false;
    }

    public void selectOnly(Target target) {
        this.selectionController.selectOnly(target);
    }

    public int snapToGrid(int x) {
        int steps = (int)Math.round((double)x / 10.0);
        int new_x = steps * 10;
        return new_x;
    }

    public void startedMove() {
        for (Target element : this.selectionController.getSelection()) {
            if (!element.isMoveable()) continue;
            element.savePreMovePosition();
        }
    }

    public void moveBy(int deltaX, int deltaY) {
        for (Target element : this.selectionController.getSelection()) {
            if (!element.isMoveable()) continue;
            element.setPos(Math.max(0, element.getPreMoveX() + deltaX), Math.max(0, element.getPreMoveY() + deltaY));
        }
    }

    public void startedResize() {
        for (Target element : this.selectionController.getSelection()) {
            if (!element.isResizable()) continue;
            element.savePreResize();
            JavaFXUtil.setPseudoclass("bj-resizing", true, element.getNode());
        }
    }

    public void resizeBy(int deltaWidth, int deltaHeight) {
        for (Target element : this.selectionController.getSelection()) {
            if (!element.isResizable()) continue;
            element.setSize(Math.max(40, element.getPreResizeWidth() + deltaWidth), Math.max(20, element.getPreResizeHeight() + deltaHeight));
        }
    }

    public void endResize() {
        for (Target element : this.selectionController.getSelection()) {
            if (!element.isResizable()) continue;
            JavaFXUtil.setPseudoclass("bj-resizing", false, element.getNode());
        }
    }

    public void navigate(KeyEvent event) {
        this.selectionController.navigate(event);
    }

    public void selectAll() {
        this.selectionController.selectAll();
    }

    public boolean clickForExtends(Target target, double sceneX, double sceneY) {
        if (this.creatingExtends && target instanceof ClassTarget) {
            if (this.extendsSubClass == null) {
                this.extendsSubClass = (ClassTarget)target;
                this.arrowCreationTip.setText(Config.getString("pkgmgr.chooseInhTo"));
                this.overlay.addMouseListener(this);
                this.newExtendsDestX = sceneX;
                this.newExtendsDestY = sceneY;
                this.repaint();
            } else {
                ClassTarget subClassFinal = this.extendsSubClass;
                if (!subClassFinal.hasSourceCode()) {
                    DialogManager.showErrorFX((Window)this.pmf.getFXWindow(), "no-extends-arrow-from-no-source-class");
                    this.clearState();
                    return false;
                }
                ClassTarget superClass = (ClassTarget)target;
                if (subClassFinal.isInterface()) {
                    if (superClass.isInterface()) {
                        this.pkg.userAddExtendsInterfaceDependency(subClassFinal, superClass);
                    }
                } else if (superClass.isInterface()) {
                    this.pkg.userAddImplementsClassDependency(subClassFinal, superClass);
                } else {
                    this.pkg.userAddExtendsClassDependency(subClassFinal, superClass);
                }
                this.pkg.compile(subClassFinal, CompileReason.MODIFIED_EXTENDS, CompileType.INDIRECT_USER_COMPILE);
                this.stopNewInherits();
            }
        }
        return false;
    }

    @Override
    public void mouseMoved(double localX, double localY) {
        this.newExtendsDestX = localX;
        this.newExtendsDestY = localY;
        this.repaint();
    }

    @Override
    public Stage getStage() {
        return this.pmf.getFXWindow();
    }

    @Override
    public void callStaticMethodOrConstructor(CallableView view) {
        this.pmf.callStaticMethodOrConstructor(view);
    }

    @Override
    public void highlightObject(DebuggerObject currentObject) {
        this.pmf.getObjectBench().highlightObject(currentObject);
    }

    @OnThread(value=Tag.FX)
    private static class AnchorPaneExtraSpacing
    extends AnchorPane {
        public static final double EXTRA_SPACE = 20.0;

        private AnchorPaneExtraSpacing() {
        }

        protected double computePrefWidth(double height) {
            return super.computePrefWidth(height) + 20.0;
        }

        protected double computePrefHeight(double width) {
            return super.computePrefHeight(width) + 20.0;
        }

        protected double computeMinHeight(double width) {
            return super.computeMinHeight(width) + 20.0;
        }

        protected double computeMinWidth(double height) {
            return super.computeMinWidth(height) + 20.0;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private static class ExtendsDepInfo {
        private final Dependency.Line line;
        private final boolean selected;
        private final boolean creating;
        private BDependency.Type type;

        public ExtendsDepInfo(Dependency d) {
            this.line = d.computeLine();
            this.selected = d.isSelected();
            this.creating = false;
            this.type = d.getType();
        }

        public ExtendsDepInfo(DependentTarget from, double toX, double toY) {
            Point2D pFrom = new Point2D((double)(from.getX() + from.getWidth() / 2), (double)(from.getY() + from.getHeight() / 2));
            Point2D pTo = new Point2D(toX, toY);
            double angle = Math.atan2(-(pFrom.getY() - pTo.getY()), pFrom.getX() - pTo.getX());
            pFrom = from.getAttachment(angle + Math.PI);
            this.line = new Dependency.Line(pFrom, pTo, angle);
            this.selected = false;
            this.creating = true;
        }

        public ExtendsDepInfo(DependentTarget from, DependentTarget to) {
            Point2D pFrom = new Point2D((double)(from.getX() + from.getWidth() / 2), (double)(from.getY() + from.getHeight() / 2));
            Point2D pTo = new Point2D((double)(to.getX() + to.getWidth() / 2), (double)(to.getY() + to.getHeight() / 2));
            double angle = Math.atan2(-(pFrom.getY() - pTo.getY()), pFrom.getX() - pTo.getX());
            pFrom = from.getAttachment(angle + Math.PI);
            pTo = to.getAttachment(angle);
            this.line = new Dependency.Line(pFrom, pTo, angle);
            this.selected = false;
            this.creating = true;
        }
    }
}

