/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.collect.DataCollectionCompileObserverWrapper;
import bluej.collect.DataCollector;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.compiler.CompileType;
import bluej.compiler.Diagnostic;
import bluej.compiler.EventqueueCompileObserverAdapter;
import bluej.compiler.FXCompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.CallHistory;
import bluej.editor.Editor;
import bluej.editor.TextEditor;
import bluej.extensions.BPackage;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.SourceType;
import bluej.extensions.event.CompileEvent;
import bluej.extensions.event.DependencyEvent;
import bluej.extensions.event.ExtensionEvent;
import bluej.extmgr.ExtensionsManager;
import bluej.parser.AssistContent;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.ParseUtils;
import bluej.parser.nodes.ParsedCUNode;
import bluej.parser.symtab.ClassInfo;
import bluej.pkgmgr.BlueJPackageFile;
import bluej.pkgmgr.GreenfootProjectFile;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PackageFile;
import bluej.pkgmgr.PackageFileFactory;
import bluej.pkgmgr.PackageListener;
import bluej.pkgmgr.PackageUI;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.target.CSSTarget;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.DependentTarget;
import bluej.pkgmgr.target.EditableTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.ParentPackageTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.TargetCollection;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.JavaNames;
import bluej.utility.SortedProperties;
import bluej.utility.Utility;
import bluej.utility.filefilter.FrameSourceFilter;
import bluej.utility.filefilter.JavaClassFilter;
import bluej.utility.filefilter.JavaSourceFilter;
import bluej.utility.filefilter.SubPackageFilter;
import bluej.utility.javafx.JavaFXUtil;
import bluej.views.CallableView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Package {
    static final String compiling = Config.getString("pkgmgr.compiling");
    static final String compileDone = Config.getString("pkgmgr.compileDone");
    static final String chooseUsesTo = Config.getString("pkgmgr.chooseUsesTo");
    static final String chooseInhTo = Config.getString("pkgmgr.chooseInhTo");
    private @OnThread(value=Tag.Any, requireSynchronized=true) PackageFile packageFile;
    public static final String readmeName = "README.TXT";
    public static final int NO_ERROR = 0;
    public static final int FILE_NOT_FOUND = 1;
    public static final int ILLEGAL_FORMAT = 2;
    public static final int COPY_ERROR = 3;
    public static final int CLASS_EXISTS = 4;
    public static final int CREATE_ERROR = 5;
    private final @OnThread(value=Tag.Any, requireSynchronized=true) List<Target> targetsToPlace = new ArrayList<Target>();
    private boolean recorded = false;
    public static final int FIXED_TARGET_X = 10;
    public static final int FIXED_TARGET_Y = 10;
    private final Project project;
    private final Package parentPackage;
    private final String baseName;
    private volatile SortedProperties lastSavedProps = new SortedProperties();
    private final @OnThread(value=Tag.Any, requireSynchronized=true) TargetCollection targets;
    private @OnThread(value=Tag.FXPlatform) DependentTarget fromChoice;
    private CallHistory callHistory;
    private String lastSourceName = "";
    public static final int HISTORY_LENGTH = 6;
    private @OnThread(value=Tag.Any, requireSynchronized=true) PackageListener editor;
    private PackageUI ui;
    private @OnThread(value=Tag.FXPlatform) List<PackageListener> listeners = new ArrayList<PackageListener>();
    private final @OnThread(value=Tag.FXPlatform) List<UsesDependency> usesArrows = new ArrayList<UsesDependency>();
    private final @OnThread(value=Tag.FXPlatform) List<Dependency> extendsArrows = new ArrayList<Dependency>();
    private @OnThread(value=Tag.FXPlatform) boolean waitingForIdleToCompile = false;
    private boolean currentlyCompiling = false;
    private boolean queuedCompile = false;
    private CompileReason queuedReason;
    private final List<FXCompileObserver> compileObservers = new ArrayList<FXCompileObserver>();
    private @OnThread(value=Tag.Any) File dir;
    private @OnThread(value=Tag.Any, requireSynchronized=true) BPackage singleBPackage;

    List<UsesDependency> getUsesArrows() {
        return this.usesArrows;
    }

    List<Dependency> getExtendsArrows() {
        return this.extendsArrows;
    }

    public Package(Project project, String baseName, Package parent) throws IOException {
        if (parent == null) {
            throw new NullPointerException("Package must have a valid parent package");
        }
        if (baseName.length() == 0) {
            throw new IllegalArgumentException("unnamedPackage must be created using Package(project)");
        }
        if (!JavaNames.isIdentifier(baseName)) {
            throw new IllegalArgumentException(baseName + " is not a valid name for a Package");
        }
        this.project = project;
        this.baseName = baseName;
        this.parentPackage = parent;
        this.targets = new TargetCollection();
        this.init();
    }

    public Package(Project project) throws IOException {
        this.project = project;
        this.baseName = "";
        this.parentPackage = null;
        this.targets = new TargetCollection();
        this.init();
    }

    private void init() throws IOException {
        this.callHistory = new CallHistory(6);
        this.dir = new File(this.project.getProjectDir(), this.getRelativePath().getPath());
        this.load();
    }

    @OnThread(value=Tag.Any)
    public boolean isUnnamedPackage() {
        return this.parentPackage == null;
    }

    @OnThread(value=Tag.Any)
    public Project getProject() {
        return this.project;
    }

    @OnThread(value=Tag.Any)
    public final synchronized BPackage getBPackage() {
        if (this.singleBPackage == null) {
            this.singleBPackage = ExtensionBridge.newBPackage((Package)this);
        }
        return this.singleBPackage;
    }

    @OnThread(value=Tag.Any)
    public String getId() {
        return this.getPath().getPath();
    }

    @OnThread(value=Tag.Any)
    public String getBaseName() {
        return this.baseName;
    }

    @OnThread(value=Tag.Any)
    public String getQualifiedName(String identifier) {
        if (this.isUnnamedPackage()) {
            return identifier;
        }
        return this.getQualifiedName() + "." + identifier;
    }

    @OnThread(value=Tag.Any)
    public String getQualifiedName() {
        Package currentPkg = this;
        Object retName = "";
        while (!currentPkg.isUnnamedPackage()) {
            retName = ((String)retName).equals("") ? currentPkg.getBaseName() : currentPkg.getBaseName() + "." + (String)retName;
            currentPkg = currentPkg.getParent();
        }
        return retName;
    }

    public synchronized ReadmeTarget getReadmeTarget() {
        ReadmeTarget readme = (ReadmeTarget)this.targets.get("@README");
        return readme;
    }

    private File getRelativePath() {
        Package currentPkg = this;
        File retFile = new File(currentPkg.getBaseName());
        while (!currentPkg.isUnnamedPackage()) {
            currentPkg = currentPkg.getParent();
            retFile = new File(currentPkg.getBaseName(), retFile.getPath());
        }
        return retFile;
    }

    @OnThread(value=Tag.Any)
    public File getPath() {
        return this.dir;
    }

    @OnThread(value=Tag.Any)
    public Package getParent() {
        return this.parentPackage;
    }

    protected synchronized Package getBoringSubPackage() {
        PackageTarget pt = null;
        for (Target target : this.targets) {
            if (target instanceof ClassTarget) {
                return null;
            }
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            if (pt != null) {
                return null;
            }
            pt = (PackageTarget)target;
        }
        if (pt == null) {
            return null;
        }
        return this.getProject().getPackage(pt.getQualifiedName());
    }

    protected synchronized List<Package> getChildren(boolean getUncached) {
        ArrayList<Package> children = new ArrayList<Package>();
        for (Target target : this.targets) {
            if (!(target instanceof PackageTarget) || target instanceof ParentPackageTarget) continue;
            PackageTarget pt = (PackageTarget)target;
            Package child = getUncached ? this.getProject().getPackage(pt.getQualifiedName()) : this.getProject().getCachedPackage(pt.getQualifiedName());
            if (child == null) continue;
            children.add(child);
        }
        return children;
    }

    public void setStatus(String msg) {
        PkgMgrFrame.displayMessage(this, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.FXPlatform)
    void setEditor(PackageEditor ed) {
        this.setUI(ed);
        Package package_ = this;
        synchronized (package_) {
            if (this.editor != null) {
                this.removeListener(ed);
            }
            this.editor = ed;
            if (ed != null) {
                this.addListener(ed);
            }
        }
        if (ed == null) {
            this.fireClosedEvent();
        }
        if (ed != null) {
            package_ = this;
            synchronized (package_) {
                for (Target t : this.targets) {
                    if (!(t instanceof ParentPackageTarget)) continue;
                    ed.findSpaceForVertex(t);
                }
                for (Target t : this.targetsToPlace) {
                    ed.findSpaceForVertex(t);
                }
                this.targetsToPlace.clear();
            }
            ed.graphChanged();
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized PackageEditor getEditor() {
        return (PackageEditor)this.editor;
    }

    public void setUI(PackageUI ui) {
        this.ui = ui;
    }

    public PackageUI getUI() {
        return this.ui;
    }

    public synchronized void addListener(PackageListener pl) {
        this.listeners.add(pl);
    }

    public synchronized void removeListener(PackageListener pl) {
        this.listeners.remove(pl);
    }

    @OnThread(value=Tag.FXPlatform)
    private void fireClosedEvent() {
        ArrayList<PackageListener> listenersCopy = new ArrayList<PackageListener>(this.listeners);
        for (PackageListener l : listenersCopy) {
            l.graphClosed();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void fireChangedEvent() {
        for (PackageListener l : this.listeners) {
            l.graphChanged();
        }
    }

    @OnThread(value=Tag.Any)
    public Properties getLastSavedProperties() {
        return this.lastSavedProps;
    }

    @OnThread(value=Tag.Any)
    public synchronized List<Target> getSelectedTargets() {
        return Utility.filterList(this.getVertices(), Target::isSelected);
    }

    private Set<String> findTargets(File path) {
        int i;
        File[] javaSrcFiles = path.listFiles(new JavaSourceFilter());
        File[] frameSrcFiles = path.listFiles(new FrameSourceFilter());
        File[] classFiles = path.listFiles(new JavaClassFilter());
        HashSet<String> interestingSet = new HashSet<String>();
        for (i = 0; i < javaSrcFiles.length; ++i) {
            if (javaSrcFiles[i].getName().startsWith("__SHELL")) {
                javaSrcFiles[i].delete();
                continue;
            }
            String javaFileName = JavaNames.stripSuffix(javaSrcFiles[i].getName(), "." + SourceType.Java.toString().toLowerCase());
            if (!JavaNames.isIdentifier(javaFileName) || javaFileName.indexOf(36) != -1) continue;
            interestingSet.add(javaFileName);
        }
        for (i = 0; i < frameSrcFiles.length; ++i) {
            String frameFileName = JavaNames.stripSuffix(frameSrcFiles[i].getName(), "." + SourceType.Stride.toString().toLowerCase());
            if (!JavaNames.isIdentifier(frameFileName)) continue;
            interestingSet.add(frameFileName);
        }
        for (i = 0; i < classFiles.length; ++i) {
            if (classFiles[i].getName().startsWith("__SHELL")) {
                classFiles[i].delete();
                continue;
            }
            String classFileName = JavaNames.stripSuffix(classFiles[i].getName(), ".class");
            if (!JavaNames.isIdentifier(classFileName) || classFileName.indexOf(36) != -1 || interestingSet.contains(classFileName)) continue;
            try {
                Class<?> c = this.loadClass(this.getQualifiedName(classFileName));
                if (c == null || !Modifier.isPublic(c.getModifiers())) continue;
                interestingSet.add(classFileName);
                continue;
            }
            catch (LinkageError e) {
                Debug.message(e.toString());
            }
        }
        return interestingSet;
    }

    public synchronized void load() throws IOException {
        this.packageFile = this.getPkgFile();
        this.packageFile.load(this.lastSavedProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void refreshPackage() {
        void var9_43;
        ClassTarget ct;
        List<Target> targetsCopy;
        Object identifierName;
        HashMap<String, PackageTarget> propTargets = new HashMap<String, PackageTarget>();
        int numTargets = 0;
        int numDependencies = 0;
        try {
            numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            numDependencies = Integer.parseInt(this.lastSavedProps.getProperty("package.numDependencies", "0"));
        }
        catch (Exception e) {
            Package package_ = this;
            synchronized (package_) {
                Debug.reportError("Error loading from package file " + this.packageFile + ": " + e, e);
            }
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            String string = this.lastSavedProps.getProperty("target" + (i + 1) + ".type");
            identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
            Target target = "PackageTarget".equals(string) ? new PackageTarget(this, (String)identifierName) : ("CSSTarget".equals(string) ? new CSSTarget(this, new File(this.getPath(), (String)identifierName)) : new ClassTarget(this, (String)identifierName));
            ((Target)target).load(this.lastSavedProps, "target" + (i + 1));
            propTargets.put((String)identifierName, (PackageTarget)target);
        }
        this.addImmovableTargets();
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            void var6_17;
            if (!JavaNames.isIdentifier(subDirs[i].getName())) continue;
            Target target = (Target)propTargets.get(subDirs[i].getName());
            if (target == null || !(target instanceof PackageTarget)) {
                PackageTarget packageTarget = new PackageTarget(this, subDirs[i].getName());
                identifierName = this;
                synchronized (identifierName) {
                    this.targetsToPlace.add(packageTarget);
                }
            }
            this.addTarget((Target)var6_17);
        }
        if (!Config.isGreenfoot()) {
            File[] cssFiles;
            for (File file : cssFiles = this.getPath().listFiles(p -> p.getName().endsWith(".css"))) {
                void var10_44;
                Target target = (Target)propTargets.get(file.getName());
                if (target == null || !(target instanceof CSSTarget)) {
                    CSSTarget cSSTarget = new CSSTarget(this, file);
                    Package package_ = this;
                    synchronized (package_) {
                        this.targetsToPlace.add(cSSTarget);
                    }
                }
                this.addTarget((Target)var10_44);
            }
        }
        Set<String> interestingSet = this.findTargets(this.getPath());
        for (String targetName : interestingSet) {
            Target target = (Target)propTargets.get(targetName);
            if (target == null || !(target instanceof ClassTarget)) {
                target = new ClassTarget(this, targetName);
                Package package_ = this;
                synchronized (package_) {
                    this.targetsToPlace.add(target);
                }
            }
            this.addTarget(target);
        }
        if (!this.recorded) {
            DataCollector.packageOpened(this);
            this.recorded = true;
        }
        Package target = this;
        synchronized (target) {
            targetsCopy = this.targets.toList();
        }
        for (Target target2 : targetsCopy) {
            if (!(target2 instanceof ClassTarget)) continue;
            ClassTarget classTarget = (ClassTarget)target2;
            classTarget.setState(DependentTarget.State.COMPILED);
        }
        for (int i = 0; i < numDependencies; ++i) {
            String string = this.lastSavedProps.getProperty("dependency" + (i + 1) + ".type");
            if (!"UsesDependency".equals(string)) continue;
            try {
                UsesDependency usesDependency = new UsesDependency(this, this.lastSavedProps, "dependency" + (i + 1));
                this.addDependency(usesDependency, false);
                continue;
            }
            catch (Dependency.DependencyNotFoundException dependencyNotFoundException) {
                Debug.reportError(dependencyNotFoundException);
            }
        }
        this.recalcArrows();
        LinkedList<ClassTarget> invalidated = new LinkedList<ClassTarget>();
        for (Target target3 : targetsCopy) {
            if (!(target3 instanceof ClassTarget) || !(ct = (ClassTarget)target3).isCompiled() || ct.upToDate()) continue;
            ct.setState(DependentTarget.State.NEEDS_COMPILE);
            invalidated.add(ct);
        }
        while (!invalidated.isEmpty()) {
            ClassTarget classTarget = (ClassTarget)invalidated.removeFirst();
            for (Dependency dependent : classTarget.dependentsAsList()) {
                ClassTarget dep;
                DependentTarget dt = dependent.getFrom();
                if (!(dt instanceof ClassTarget) || !(dep = (ClassTarget)dt).isCompiled() || !dep.hasSourceCode()) continue;
                dep.setState(DependentTarget.State.NEEDS_COMPILE);
                invalidated.add(dep);
            }
        }
        for (Target target4 : targetsCopy) {
            if (!(target4 instanceof ClassTarget)) continue;
            ct = (ClassTarget)target4;
            if (ct.isCompiled()) {
                Class<?> cl = this.loadClass(ct.getQualifiedName());
                ct.determineRole(cl);
                ct.analyseDependencies(cl);
                ct.analyseTypeParams(cl);
                if (cl != null) continue;
                ct.setState(DependentTarget.State.NEEDS_COMPILE);
                continue;
            }
            ct.analyseSource();
            try {
                if (ct.getSourceType().equals((Object)SourceType.Stride)) continue;
                ct.enforcePackage(this.getQualifiedName());
            }
            catch (IOException ioe) {
                Debug.message("Error enforcing class package: " + ioe.getLocalizedMessage());
            }
        }
        boolean bl = false;
        while (var9_43 < numTargets) {
            String string = this.lastSavedProps.getProperty("target" + (int)(var9_43 + true) + ".association");
            String identifierName2 = this.lastSavedProps.getProperty("target" + (int)(var9_43 + true) + ".name");
            if (string != null) {
                Target t1 = this.getTarget(identifierName2);
                Target t2 = this.getTarget(string);
                if (t1 != null && t2 != null && t1 instanceof DependentTarget) {
                    DependentTarget dt = (DependentTarget)t1;
                    dt.setAssociation((DependentTarget)t2);
                }
            }
            ++var9_43;
        }
    }

    private PackageFile getPkgFile() {
        File dir = this.getPath();
        return PackageFileFactory.getPackageFile(dir);
    }

    public void positionNewTarget(Target t) {
        String targetName = t.getIdentifierName();
        try {
            int numTargets = Integer.parseInt(this.lastSavedProps.getProperty("package.numTargets", "0"));
            for (int i = 0; i < numTargets; ++i) {
                String identifierName = this.lastSavedProps.getProperty("target" + (i + 1) + ".name");
                if (!identifierName.equals(targetName)) continue;
                t.load(this.lastSavedProps, "target" + (i + 1));
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.getEditor().findSpaceForVertex(t);
    }

    private void addImmovableTargets() {
        ReadmeTarget t = new ReadmeTarget(this);
        ((Target)t).load(this.lastSavedProps, "readme");
        t.setPos(10, 10);
        this.addTarget(t);
        if (!this.isUnnamedPackage()) {
            ParentPackageTarget parent = new ParentPackageTarget(this);
            PackageEditor ed = this.getEditor();
            if (ed != null) {
                ed.findSpaceForVertex(parent);
            }
            this.addTarget(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        ClassTarget ct;
        List<Target> targetsCopy;
        File[] subDirs = this.getPath().listFiles(new SubPackageFilter());
        for (int i = 0; i < subDirs.length; ++i) {
            Target target;
            if (!JavaNames.isIdentifier(subDirs[i].getName())) continue;
            Package package_ = this;
            synchronized (package_) {
                target = this.targets.get(subDirs[i].getName());
            }
            if (target != null) continue;
            PackageTarget packageTarget = this.addPackage(subDirs[i].getName());
            this.getEditor().findSpaceForVertex(packageTarget);
        }
        Set<String> interestingSet = this.findTargets(this.getPath());
        for (String string : interestingSet) {
            Target target;
            Package package_ = this;
            synchronized (package_) {
                target = this.targets.get(string);
            }
            if (target != null) continue;
            ClassTarget newtarget = this.addClass(string);
            if (this.getEditor() == null) continue;
            this.getEditor().findSpaceForVertex(newtarget);
        }
        Package package_ = this;
        synchronized (package_) {
            targetsCopy = this.targets.toList();
        }
        for (Target target : targetsCopy) {
            if (!(target instanceof ClassTarget)) continue;
            ct = (ClassTarget)target;
            ct.analyseSource();
        }
        for (Target target : targetsCopy) {
            Class<?> cl;
            if (!(target instanceof ClassTarget) || (cl = this.loadClass((ct = (ClassTarget)target).getQualifiedName())) == null) continue;
            ct.determineRole(cl);
            if (ct.upToDate()) {
                ct.setState(DependentTarget.State.COMPILED);
                continue;
            }
            ct.setState(DependentTarget.State.NEEDS_COMPILE);
        }
        PackageEditor packageEditor = this.getEditor();
        if (packageEditor != null) {
            packageEditor.graphChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reReadGraphLayout() throws IOException {
        SortedProperties props = new SortedProperties();
        Package package_ = this;
        synchronized (package_) {
            this.packageFile.load(props);
        }
        int numTargets = 0;
        try {
            numTargets = Integer.parseInt(props.getProperty("package.numTargets", "0"));
        }
        catch (Exception e) {
            Package package_2 = this;
            synchronized (package_2) {
                Debug.printCallStack("Error loading from bluej package file " + this.packageFile + ": " + e);
            }
            return;
        }
        for (int i = 0; i < numTargets; ++i) {
            String identifierName = props.getProperty("target" + (i + 1) + ".name");
            int x = Integer.parseInt(props.getProperty("target" + (i + 1) + ".x"));
            int y = Integer.parseInt(props.getProperty("target" + (i + 1) + ".y"));
            int height = Integer.parseInt(props.getProperty("target" + (i + 1) + ".height"));
            int width = Integer.parseInt(props.getProperty("target" + (i + 1) + ".width"));
            Target target = this.getTarget(identifierName);
            if (target == null) continue;
            target.setPos(x, y);
            target.setSize(width, height);
        }
        this.repaint();
    }

    @OnThread(value=Tag.Any)
    public void repaint() {
        JavaFXUtil.runNowOrLater(() -> {
            PackageEditor ed = this.getEditor();
            if (ed != null) {
                ed.repaint();
            }
        });
    }

    @OnThread(value=Tag.FXPlatform)
    public synchronized void save(Properties frameProperties) {
        Target t2;
        File dir = this.getPath();
        if (!dir.exists() && !dir.mkdir()) {
            Debug.reportError("Error creating directory " + dir);
            return;
        }
        SortedProperties props = new SortedProperties();
        props.putAll((Map<?, ?>)frameProperties);
        props.put("package.numDependencies", String.valueOf(this.usesArrows.size()));
        int t_count = 0;
        for (Target t2 : this.targets) {
            if (!t2.isSaveable()) continue;
            t2.save(props, "target" + (t_count + 1));
            ++t_count;
        }
        props.put("package.numTargets", String.valueOf(t_count));
        t2 = this.getTarget("@README");
        t2.save(props, "readme");
        for (int i = 0; i < this.usesArrows.size(); ++i) {
            Dependency d = this.usesArrows.get(i);
            d.save(props, "dependency" + (i + 1));
        }
        try {
            this.packageFile.save(props);
        }
        catch (IOException e) {
            Debug.reportError("Exception when saving package file : " + e);
            return;
        }
        this.lastSavedProps = props;
    }

    public int importFile(File aFile) {
        PkgMgrFrame pmf;
        String className;
        if (!aFile.exists()) {
            return 1;
        }
        String fileName = aFile.getName();
        if (fileName.endsWith("." + SourceType.Java.getExtension())) {
            className = fileName.substring(0, fileName.length() - SourceType.Java.getExtension().length() - 1);
        } else if (fileName.endsWith("." + SourceType.Stride.getExtension())) {
            className = fileName.substring(0, fileName.length() - SourceType.Stride.getExtension().length() - 1);
        } else {
            return 2;
        }
        if (this.getTarget(className) != null) {
            return 4;
        }
        File destFile = new File(this.getPath(), fileName);
        try {
            FileUtility.copyFile(aFile, destFile);
        }
        catch (IOException ioe) {
            return 3;
        }
        ClassTarget t = this.addClass(className);
        if (null == this.getEditor() && (pmf = PkgMgrFrame.findFrame(this)) == null) {
            pmf = PkgMgrFrame.createFrame(this, null);
        }
        this.getEditor().findSpaceForVertex(t);
        t.analyseSource();
        DataCollector.addClass(this, t);
        return 0;
    }

    public ClassTarget addClass(String className) {
        ClassTarget target = new ClassTarget(this, className);
        this.addTarget(target);
        try {
            target.enforcePackage(this.getQualifiedName());
        }
        catch (IOException ioe) {
            Debug.message(ioe.getLocalizedMessage());
        }
        return target;
    }

    public PackageTarget addPackage(String packageName) {
        PackageTarget target = new PackageTarget(this, packageName);
        this.addTarget(target);
        return target;
    }

    @OnThread(value=Tag.Any)
    public Debugger getDebugger() {
        return this.getProject().getDebugger();
    }

    public Class<?> loadClass(String className) {
        return this.getProject().loadClass(className);
    }

    @OnThread(value=Tag.Any)
    public synchronized List<Target> getVertices() {
        ArrayList<Target> r = new ArrayList<Target>();
        for (Target t : this.targets) {
            r.add(t);
        }
        return r;
    }

    public synchronized List<ClassTarget> getTestTargets() {
        ArrayList<ClassTarget> l = new ArrayList<ClassTarget>();
        for (Target target : this.targets) {
            ClassTarget ct;
            if (!(target instanceof ClassTarget) || !(ct = (ClassTarget)target).isUnitTest()) continue;
            l.add(ct);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(FXCompileObserver compObserver, CompileReason reason, CompileType type) {
        block12: {
            HashSet<ClassTarget> toCompile = new HashSet<ClassTarget>();
            try {
                ArrayList<ClassTarget> classTargets;
                Package package_ = this;
                synchronized (package_) {
                    classTargets = this.getClassTargets();
                }
                for (ClassTarget ct : classTargets) {
                    if (ct.isCompiled() || ct.isQueued()) continue;
                    ct.ensureSaved();
                    toCompile.add(ct);
                    ct.setQueued(true);
                }
                if (!toCompile.isEmpty()) {
                    if (type.keepClasses()) {
                        this.project.removeClassLoader();
                        this.project.newRemoteClassLoaderLeavingBreakpoints();
                    }
                    ArrayList<FXCompileObserver> observers = new ArrayList<FXCompileObserver>(this.compileObservers);
                    if (compObserver != null) {
                        observers.add(compObserver);
                    }
                    this.doCompile(toCompile, new PackageCompileObserver(observers), reason, type);
                } else if (compObserver != null) {
                    compObserver.endCompile(new CompileInputFile[0], true, type, -1);
                }
            }
            catch (IOException ioe) {
                Debug.log("Error saving class before compile: " + ioe.getLocalizedMessage());
                for (ClassTarget ct : toCompile) {
                    ct.setQueued(false);
                }
                if (compObserver == null) break block12;
                compObserver.endCompile(new CompileInputFile[0], false, type, -1);
            }
        }
    }

    public void compile(CompileReason reason, final CompileType type) {
        if (!this.currentlyCompiling) {
            this.currentlyCompiling = true;
            this.compile(new FXCompileObserver(){

                @Override
                @OnThread(value=Tag.FXPlatform)
                public boolean compilerMessage(Diagnostic diagnostic, CompileType type2) {
                    return false;
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void startCompile(CompileInputFile[] sources, CompileReason reason, CompileType type2, int compilationSequence) {
                }

                @Override
                @OnThread(value=Tag.FXPlatform)
                public void endCompile(CompileInputFile[] sources, boolean succesful, CompileType type2, int compilationSequence) {
                    Package.this.currentlyCompiling = false;
                    if (Package.this.queuedCompile) {
                        Package.this.queuedCompile = false;
                        Package.this.compile(Package.this.queuedReason, type);
                        Package.this.queuedReason = null;
                    }
                }
            }, reason, type);
        } else {
            this.queuedCompile = true;
            this.queuedReason = reason;
        }
    }

    public void compile(ClassTarget ct, CompileReason reason, CompileType type) {
        this.compile(ct, false, null, reason, type);
    }

    public void compile(ClassTarget ct, boolean forceQuiet, FXCompileObserver compObserver, CompileReason reason, CompileType type) {
        if (!this.checkCompile()) {
            return;
        }
        ClassTarget assocTarget = (ClassTarget)ct.getAssociation();
        if (assocTarget != null && !assocTarget.hasSourceCode()) {
            assocTarget = null;
        }
        if (!ct.hasSourceCode()) {
            ct = null;
        }
        if (ct != null || assocTarget != null) {
            if (type.keepClasses()) {
                this.project.removeClassLoader();
                this.project.newRemoteClassLoaderLeavingBreakpoints();
            }
            if (ct != null) {
                ArrayList<FXCompileObserver> chainedObservers = new ArrayList<FXCompileObserver>(this.compileObservers);
                if (compObserver != null) {
                    chainedObservers.add(compObserver);
                }
                QuietPackageCompileObserver observer = forceQuiet ? new QuietPackageCompileObserver(chainedObservers) : new PackageCompileObserver(chainedObservers);
                this.searchCompile(ct, observer, reason, type);
            }
            if (assocTarget != null) {
                this.searchCompile(assocTarget, new QuietPackageCompileObserver(Collections.emptyList()), reason, type);
            }
        }
    }

    public void compileQuiet(ClassTarget ct, CompileReason reason, CompileType type) {
        if (!this.isDebuggerIdle()) {
            return;
        }
        this.searchCompile(ct, new QuietPackageCompileObserver(Collections.emptyList()), reason, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        if (!this.checkCompile()) {
            return;
        }
        ArrayList<ClassTarget> compileTargets = new ArrayList<ClassTarget>();
        Package package_ = this;
        synchronized (package_) {
            for (Target target : this.targets) {
                if (!(target instanceof ClassTarget)) continue;
                compileTargets.add((ClassTarget)target);
            }
        }
        try {
            Iterator i = compileTargets.iterator();
            while (i.hasNext()) {
                ClassTarget ct = (ClassTarget)i.next();
                if (ct.hasSourceCode()) {
                    ct.ensureSaved();
                    ct.markModified();
                    ct.setQueued(true);
                    continue;
                }
                i.remove();
            }
            if (!compileTargets.isEmpty()) {
                this.project.removeClassLoader();
                this.project.newRemoteClassLoader();
                this.doCompile(compileTargets, new PackageCompileObserver(this.compileObservers), CompileReason.REBUILD, CompileType.EXPLICIT_USER_COMPILE);
            }
        }
        catch (IOException ioe) {
            this.showMessageWithText("file-save-error-before-compile", ioe.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFilesInEditors() throws IOException {
        ArrayList<ClassTarget> classTargets;
        Package package_ = this;
        synchronized (package_) {
            classTargets = new ArrayList<ClassTarget>(this.getClassTargets());
        }
        for (ClassTarget ct : classTargets) {
            Editor ed = ct.getEditor();
            if (ed == null) continue;
            ed.save();
        }
    }

    private void searchCompile(ClassTarget t, FXCompileObserver observer, CompileReason reason, CompileType type) {
        if (t.isQueued()) {
            return;
        }
        HashSet<ClassTarget> toCompile = new HashSet<ClassTarget>();
        try {
            LinkedList<ClassTarget> queue = new LinkedList<ClassTarget>();
            toCompile.add(t);
            t.ensureSaved();
            queue.add(t);
            t.setQueued(true);
            while (!queue.isEmpty()) {
                ClassTarget head = (ClassTarget)queue.remove(0);
                for (Dependency d : head.dependencies()) {
                    ClassTarget to;
                    if (!(d.getTo() instanceof ClassTarget) || (to = (ClassTarget)d.getTo()).isCompiled() || to.isQueued() || !toCompile.add(to)) continue;
                    to.ensureSaved();
                    to.setQueued(true);
                    queue.add(to);
                }
            }
            this.doCompile(toCompile, observer, reason, type);
        }
        catch (IOException ioe) {
            Debug.log("Failed to save source before compile; " + ioe.getLocalizedMessage());
            for (ClassTarget ct : toCompile) {
                ct.setQueued(false);
            }
        }
    }

    private void doCompile(Collection<ClassTarget> targetList, FXCompileObserver edtObserver, CompileReason reason, CompileType type) {
        EventqueueCompileObserverAdapter observer = new EventqueueCompileObserverAdapter(new DataCollectionCompileObserverWrapper(this.project, edtObserver));
        if (targetList.isEmpty()) {
            return;
        }
        List<CompileInputFile> srcFiles = Utility.mapList(targetList, ClassTarget::getCompileInputFile);
        if (srcFiles.size() > 0 && srcFiles.stream().allMatch(CompileInputFile::isValid)) {
            JobQueue.getJobQueue().addJob(srcFiles.toArray(new CompileInputFile[0]), observer, this.project.getClassLoader(), this.project.getProjectDir(), !PrefMgr.getFlag("bluej.compiler.showunchecked"), this.project.getProjectCharset(), reason, type);
        }
    }

    public boolean isDebuggerIdle() {
        Debugger debugger = this.getDebugger();
        if (debugger == null) {
            return true;
        }
        int status = debugger.getStatus();
        return status == 2 || status == 1;
    }

    private boolean checkCompile() {
        if (this.isDebuggerIdle()) {
            return true;
        }
        this.showMessage("compile-while-executing");
        return false;
    }

    public void compileOnceIdle(final ClassTarget specificTarget, final CompileReason reason, final CompileType type) {
        if (!this.waitingForIdleToCompile) {
            if (this.isDebuggerIdle()) {
                if (specificTarget == null) {
                    this.compile(reason, type);
                } else {
                    this.compile(specificTarget, reason, type);
                }
            } else {
                this.waitingForIdleToCompile = true;
                DebuggerListener dlistener = new DebuggerListener(){

                    @Override
                    @OnThread(value=Tag.Any)
                    public void processDebuggerEvent(DebuggerEvent e, boolean skipUpdate) {
                        if (e.getNewState() == 2) {
                            Package.this.getDebugger().removeDebuggerListener(this);
                            Platform.runLater(() -> {
                                if (Package.this.waitingForIdleToCompile) {
                                    Package.this.waitingForIdleToCompile = false;
                                    Package.this.compileOnceIdle(specificTarget, reason, type);
                                }
                            });
                        }
                    }
                };
                this.getDebugger().addDebuggerListener(dlistener);
                if (this.isDebuggerIdle()) {
                    this.waitingForIdleToCompile = false;
                    this.compile(reason, type);
                    this.getDebugger().removeDebuggerListener(dlistener);
                }
            }
        }
    }

    public String generateDocumentation() {
        return this.project.generateDocumentation();
    }

    public void generateDocumentation(ClassTarget ct) {
        String filename = ct.getSourceFile().getPath();
        this.project.generateDocumentation(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reInitBreakpoints() {
        ArrayList<ClassTarget> classTargets;
        Package package_ = this;
        synchronized (package_) {
            classTargets = this.getClassTargets();
        }
        for (ClassTarget target : classTargets) {
            target.reInitBreakpoints();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStepMarks() {
        ArrayList<ClassTarget> classTargets;
        Package package_ = this;
        synchronized (package_) {
            classTargets = new ArrayList<ClassTarget>(this.getClassTargets());
        }
        for (ClassTarget target : classTargets) {
            target.removeStepMark();
        }
        if (this.getUI() != null) {
            this.getUI().highlightObject(null);
        }
    }

    public synchronized void addTarget(Target t) {
        if (t.getPackage() != this) {
            throw new IllegalArgumentException();
        }
        this.targets.add(t.getIdentifierName(), t);
        this.fireChangedEvent();
    }

    public synchronized void removeTarget(Target t) {
        this.targets.remove(t.getIdentifierName());
        t.setRemoved();
        this.fireChangedEvent();
    }

    public synchronized void updateTargetIdentifier(Target t, String oldIdentifier, String newIdentifier) {
        if (t == null || newIdentifier == null) {
            Debug.reportError("cannot properly update target name...");
            return;
        }
        this.targets.remove(oldIdentifier);
        this.targets.add(newIdentifier, t);
    }

    @OnThread(value=Tag.FXPlatform)
    public void removeArrow(Dependency d) {
        if (!(d instanceof UsesDependency)) {
            this.userRemoveDependency(d);
        }
        this.removeDependency(d, true);
        this.getEditor().graphChanged();
    }

    public void userAddImplementsClassDependency(ClassTarget from, ClassTarget to) {
        ClassInfo info = from.getSourceInfo().getInfo(from.getJavaSourceFile(), this);
        if (info != null) {
            from.getEditor().addImplements(to.getBaseName(), info);
            from.analyseSource();
        }
    }

    public void userAddExtendsInterfaceDependency(ClassTarget from, ClassTarget to) {
        ClassInfo info = from.getSourceInfo().getInfo(from.getJavaSourceFile(), this);
        from.getEditor().addExtendsInterface(to.getBaseName(), info);
        from.analyseSource();
    }

    public void userAddExtendsClassDependency(ClassTarget from, ClassTarget to) {
        from.getEditor().setExtendsClass(to.getBaseName(), from.getSourceInfo().getInfo(from.getJavaSourceFile(), this));
        from.analyseSource();
    }

    public void userRemoveDependency(Dependency d) {
        if (!(d.getFrom() instanceof ClassTarget) || !(d.getTo() instanceof ClassTarget)) {
            return;
        }
        ClassTarget from = (ClassTarget)d.getFrom();
        ClassTarget to = (ClassTarget)d.getTo();
        ClassInfo info = from.getSourceInfo().getInfo(from.getJavaSourceFile(), this);
        if (d instanceof ImplementsDependency) {
            from.getEditor().removeExtendsOrImplementsInterface(to.getBaseName(), info);
        } else if (d instanceof ExtendsDependency) {
            from.getEditor().removeExtendsClass(info);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    private void recalcArrows() {
        for (Target t : this.getVertices()) {
            if (!(t instanceof DependentTarget)) continue;
            DependentTarget dt = (DependentTarget)t;
            dt.recalcInUses();
            dt.recalcOutUses();
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized Target getTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        return t;
    }

    public synchronized DependentTarget getDependentTarget(String identifierName) {
        if (identifierName == null) {
            return null;
        }
        Target t = this.targets.get(identifierName);
        if (t instanceof DependentTarget) {
            return (DependentTarget)t;
        }
        return null;
    }

    @OnThread(value=Tag.Any)
    public final synchronized ArrayList<ClassTarget> getClassTargets() {
        ArrayList<ClassTarget> risul = new ArrayList<ClassTarget>();
        for (Target target : this.targets) {
            if (!(target instanceof ClassTarget)) continue;
            risul.add((ClassTarget)target);
        }
        return risul;
    }

    public synchronized List<String> getAllClassnames() {
        return Utility.mapList(this.getClassTargets(), ClassTarget::getBaseName);
    }

    public synchronized List<String> getAllClassnamesWithSource() {
        ArrayList<String> names = new ArrayList<String>();
        for (Target t : this.targets) {
            ClassTarget ct;
            if (!(t instanceof ClassTarget) || !(ct = (ClassTarget)t).hasSourceCode()) continue;
            names.add(ct.getBaseName());
        }
        return names;
    }

    @OnThread(value=Tag.Any)
    public static boolean isPackage(File f) {
        if (Config.isGreenfoot()) {
            return GreenfootProjectFile.exists(f);
        }
        return BlueJPackageFile.exists(f);
    }

    @OnThread(value=Tag.Any)
    public static boolean isPackageFileName(String name) {
        if (Config.isGreenfoot()) {
            return GreenfootProjectFile.isProjectFileName(name);
        }
        return BlueJPackageFile.isPackageFileName(name);
    }

    @OnThread(value=Tag.Any)
    public void targetSelected(Target t) {
    }

    public void showError(String msgId) {
        PkgMgrFrame.showError(this, msgId);
    }

    public void showMessage(String msgId) {
        PkgMgrFrame.showMessage(this, msgId);
    }

    public void showMessageWithText(String msgId, String text) {
        PkgMgrFrame.showMessageWithText(this, msgId, text);
    }

    public void forgetLastSource() {
        this.lastSourceName = "";
    }

    private boolean showSource(DebuggerThread thread, String sourcename, int lineNo, ShowSourceReason reason, String msg) {
        boolean bringToFront = !sourcename.equals(this.lastSourceName);
        this.lastSourceName = sourcename;
        Editor targetEditor = this.editorForTarget(new File(this.getPath(), sourcename).getAbsolutePath(), bringToFront);
        if (targetEditor != null) {
            DebuggerObject currentObject = thread.getCurrentObject(0);
            if (this.getUI() != null) {
                this.getUI().highlightObject(currentObject);
            }
            return targetEditor.setStepMark(lineNo, msg, reason.isSuspension(), thread);
        }
        if (reason == ShowSourceReason.BREAKPOINT_HIT) {
            this.showMessageWithText("break-no-source", sourcename);
        }
        return false;
    }

    public void showSource(String sourcename, int lineNo) {
        String msg = " ";
        boolean bringToFront = !sourcename.equals(this.lastSourceName);
        this.lastSourceName = sourcename;
        this.showEditorMessage(new File(this.getPath(), sourcename).getPath(), lineNo, msg, false, bringToFront);
    }

    private boolean showEditorMessage(String filename, int lineNo, String message, boolean beep, boolean bringToFront) {
        Editor targetEditor = this.editorForTarget(filename, bringToFront);
        if (targetEditor == null) {
            Debug.message("Error or exception for source not in project: " + filename + ", line " + lineNo + ": " + message);
            return false;
        }
        targetEditor.displayMessage(message, lineNo, 0);
        return true;
    }

    private Editor editorForTarget(String filename, boolean bringToFront) {
        Target t = this.getTargetForSource(filename);
        if (!(t instanceof ClassTarget)) {
            return null;
        }
        ClassTarget ct = (ClassTarget)t;
        Editor targetEditor = ct.getEditor();
        if (targetEditor != null && (!targetEditor.isOpen() || bringToFront)) {
            ct.open();
        }
        return targetEditor;
    }

    private Target getTargetForSource(String filename) {
        String fullName = this.getProject().convertPathToPackageName(filename);
        if (fullName == null) {
            return null;
        }
        String packageName = JavaNames.getPrefix(fullName);
        String className = JavaNames.getBase(fullName);
        Target t = null;
        if (!packageName.equals(this.getQualifiedName())) {
            Package pkg = this.getProject().getPackage(packageName);
            if (pkg != null) {
                PkgMgrFrame pmf = PkgMgrFrame.findFrame(pkg);
                if (pmf == null) {
                    pmf = PkgMgrFrame.createFrame(pkg, null);
                }
                pmf.setVisible(true);
                t = pkg.getTarget(className);
            }
        } else {
            t = this.getTarget(className);
        }
        return t;
    }

    private ErrorShown showEditorDiagnostic(Diagnostic diagnostic, MessageCalculator messageCalc, int errorIndex, CompileType compileType) {
        String fileName = diagnostic.getFileName();
        if (fileName == null) {
            return ErrorShown.EDITOR_NOT_FOUND;
        }
        Target target = this.getTargetForSource(fileName);
        if (!(target instanceof ClassTarget)) {
            return ErrorShown.EDITOR_NOT_FOUND;
        }
        ClassTarget t = (ClassTarget)target;
        Editor targetEditor = t.getEditor();
        if (targetEditor != null) {
            if (messageCalc != null) {
                diagnostic.setMessage(messageCalc.calculateMessage(targetEditor));
            }
            if (this.project.isClosing()) {
                return ErrorShown.ERROR_NOT_SHOWN;
            }
            boolean shown = t.showDiagnostic(diagnostic, errorIndex, compileType);
            return shown ? ErrorShown.ERROR_SHOWN : ErrorShown.ERROR_NOT_SHOWN;
        }
        Debug.message(t.getDisplayName() + ", line" + diagnostic.getStartLine() + ": " + diagnostic.getMessage());
        return ErrorShown.EDITOR_NOT_FOUND;
    }

    public void hitBreakpoint(DebuggerThread thread) {
        String msg = null;
        if (PrefMgr.getFlag("bluej.accessibility.support")) {
            msg = Config.getString("debugger.accessibility.breakpoint");
            msg = msg.replace("$", thread.getName());
        }
        if (!this.showSource(thread, thread.getClassSourceName(0), thread.getLineNumber(0), ShowSourceReason.BREAKPOINT_HIT, msg)) {
            this.getProject().getExecControls().show();
            this.getProject().getExecControls().selectThread(thread);
        }
    }

    public void hitHalt(DebuggerThread thread) {
        ShowSourceReason reason;
        boolean breakpoint = thread.isAtBreakpoint();
        String msg = null;
        if (PrefMgr.getFlag("bluej.accessibility.support")) {
            msg = breakpoint ? Config.getString("debugger.accessibility.breakpoint") : Config.getString("debugger.accessibility.paused");
            msg = msg.replace("$", thread.getName());
        }
        int frame = thread.getSelectedFrame();
        ShowSourceReason showSourceReason = reason = breakpoint ? ShowSourceReason.BREAKPOINT_HIT : ShowSourceReason.STEP_OR_HALT;
        if (!this.showSource(thread, thread.getClassSourceName(frame), thread.getLineNumber(frame), reason, msg)) {
            this.getProject().getExecControls().show();
            this.getProject().getExecControls().selectThread(thread);
        }
    }

    public void showSourcePosition(DebuggerThread thread, String sourceName, int lineNumber) {
        this.showSource(thread, sourceName, lineNumber, ShowSourceReason.FRAME_SELECTED, null);
    }

    public void exceptionMessage(ExceptionDescription exception) {
        SourceLocation loc;
        String text = exception.getClassName();
        if (text == null) {
            this.reportException(exception.getText());
            return;
        }
        String message = text + ":\n" + exception.getText();
        List<SourceLocation> stack = exception.getStack();
        if (stack == null || stack.size() == 0) {
            return;
        }
        boolean done = false;
        Iterator<SourceLocation> iter = stack.iterator();
        boolean firstTime = true;
        while (!done && iter.hasNext()) {
            loc = iter.next();
            String locFileName = loc.getFileName();
            if (locFileName == null) continue;
            String filename = new File(this.getPath(), locFileName).getPath();
            int lineNo = loc.getLineNumber();
            done = this.showEditorMessage(filename, lineNo, message, true, true);
            if (!firstTime || done) continue;
            message = message + " (in " + loc.getClassName() + ")";
            firstTime = false;
        }
        if (!done) {
            loc = stack.get(0);
            this.showMessageWithText("error-in-file", loc.getClassName() + ":" + loc.getLineNumber() + "\n" + message);
        }
    }

    public void exceptionMessage(String className, int lineNumber) {
        this.showEditorMessage(className, lineNumber, "", false, true);
    }

    public void reportException(String text) {
        this.showMessageWithText("exception-thrown", text);
    }

    protected static String getResourcePath(Class<?> c) {
        URL srcUrl;
        block7: {
            srcUrl = c.getResource(c.getSimpleName() + ".class");
            try {
                if (srcUrl != null) {
                    if (srcUrl.getProtocol().equals("file")) {
                        File srcFile = new File(srcUrl.toURI());
                        return srcFile.toString();
                    }
                    if (srcUrl.getProtocol().equals("jar")) {
                        int classIndex = srcUrl.toString().indexOf("!");
                        String subUrl = srcUrl.toString().substring(4, classIndex);
                        if (subUrl.startsWith("file:")) {
                            return new File(new URI(subUrl)).toString();
                        }
                        if (classIndex != -1) {
                            return srcUrl.toString().substring(4, classIndex);
                        }
                    }
                    break block7;
                }
                return null;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return srcUrl.toString();
    }

    public static boolean checkClassMatchesFile(Class<?> c, File f) {
        block5: {
            try {
                URL srcUrl = c.getResource(c.getSimpleName() + ".class");
                if (srcUrl == null) {
                    return true;
                }
                if (srcUrl != null && srcUrl.getProtocol().equals("file")) {
                    File srcFile = new File(srcUrl.toURI());
                    if (!f.equals(srcFile)) {
                        return false;
                    }
                    break block5;
                }
                return false;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllEditors() {
        ArrayList<Target> targetsCopy;
        Package package_ = this;
        synchronized (package_) {
            targetsCopy = new ArrayList<Target>();
            for (Target t : this.targets) {
                targetsCopy.add(t);
            }
        }
        for (Target target : targetsCopy) {
            EditableTarget et;
            if (!(target instanceof EditableTarget) || !(et = (EditableTarget)target).editorOpen()) continue;
            et.getEditor().close();
        }
    }

    public CallHistory getCallHistory() {
        return this.callHistory;
    }

    public String toString() {
        return "Package:" + this.getQualifiedName();
    }

    public SourceType getDefaultSourceType() {
        if (this.getClassTargets().stream().anyMatch(c -> c.getSourceType() == SourceType.Stride)) {
            return SourceType.Stride;
        }
        return SourceType.Java;
    }

    public void addDependency(Dependency dependency) {
        this.addDependency(dependency, dependency instanceof UsesDependency);
    }

    public void addDependency(Dependency d, boolean recalc) {
        DependentTarget from = d.getFrom();
        DependentTarget to = d.getTo();
        if (from == null || to == null) {
            return;
        }
        if (d instanceof UsesDependency) {
            if (this.usesArrows.contains(d)) {
                return;
            }
            this.usesArrows.add((UsesDependency)d);
        } else {
            if (this.extendsArrows.contains(d)) {
                return;
            }
            this.extendsArrows.add(d);
        }
        DependentTarget from1 = d.getFrom();
        DependentTarget to1 = d.getTo();
        from1.addDependencyOut(d, recalc);
        to1.addDependencyIn(d, recalc);
        DependencyEvent event = new DependencyEvent(d, this, DependencyEvent.Type.DEPENDENCY_ADDED);
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
    }

    public void removeDependency(Dependency dependency, boolean recalc) {
        if (dependency instanceof UsesDependency) {
            this.usesArrows.remove(dependency);
        } else {
            this.extendsArrows.remove(dependency);
        }
        DependentTarget from = dependency.getFrom();
        DependentTarget to = dependency.getTo();
        from.removeDependencyOut(dependency, recalc);
        to.removeDependencyIn(dependency, recalc);
        DependencyEvent event = new DependencyEvent(dependency, this, DependencyEvent.Type.DEPENDENCY_REMOVED);
        ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)event);
    }

    public void callStaticMethodOrConstructor(CallableView view) {
        this.ui.callStaticMethodOrConstructor(view);
    }

    public void addCompileObserver(FXCompileObserver fxCompileObserver) {
        this.compileObservers.add(fxCompileObserver);
    }

    public boolean checkDependecyCompilationError(ClassTarget classTarget) {
        boolean dependencyError = false;
        block0: for (Dependency d : classTarget.dependencies()) {
            ClassTarget dependent = (ClassTarget)d.getTo();
            if (dependent.getState() == DependentTarget.State.HAS_ERROR && dependent.hasSourceCode()) {
                dependencyError = true;
                break;
            }
            List<Dependency> dependencyParents = dependent.getParents();
            dependencyError = dependencyParents.stream().filter(pv -> pv.getTo().getState() == DependentTarget.State.HAS_ERROR).findFirst().isPresent();
            if (dependencyError) break;
            for (Dependency parentDependency : dependencyParents) {
                ClassTarget dependencyParent = (ClassTarget)parentDependency.getTo();
                dependencyError = this.checkDependecyCompilationError(dependencyParent);
                if (!dependencyError) continue;
                break block0;
            }
        }
        return dependencyError;
    }

    private class PackageCompileObserver
    extends QuietPackageCompileObserver {
        private int numErrors;

        public PackageCompileObserver(List<FXCompileObserver> chainedObservers) {
            super(chainedObservers);
            this.numErrors = 0;
        }

        @Override
        public void startCompile(CompileInputFile[] sources, CompileReason reason, CompileType type, int compilationSequence) {
            this.numErrors = 0;
            super.startCompile(sources, reason, type, compilationSequence);
        }

        @Override
        public boolean compilerMessage(Diagnostic diagnostic, CompileType type) {
            super.compilerMessage(diagnostic, type);
            if (diagnostic.getType() == Diagnostic.ERROR) {
                return this.errorMessage(diagnostic, type);
            }
            return this.warningMessage(diagnostic.getFileName(), (int)diagnostic.getStartLine(), diagnostic.getMessage());
        }

        private boolean errorMessage(Diagnostic diagnostic, CompileType type) {
            ++this.numErrors;
            if (diagnostic.getFileName() == null) {
                Package.this.showMessageWithText("compiler-error", diagnostic.getMessage());
                return true;
            }
            String message = diagnostic.getMessage();
            ErrorShown messageShown = message.contains("cannot find symbol") && message.contains("method") ? Package.this.showEditorDiagnostic(diagnostic, new MisspeltMethodChecker(message, (int)diagnostic.getStartColumn(), (int)diagnostic.getStartLine(), Package.this.project), this.numErrors - 1, type) : Package.this.showEditorDiagnostic(diagnostic, null, this.numErrors - 1, type);
            switch (messageShown) {
                case EDITOR_NOT_FOUND: {
                    Package.this.showMessageWithText("error-in-file", diagnostic.getFileName() + ":" + diagnostic.getStartLine() + "\n" + message);
                    return true;
                }
                case ERROR_SHOWN: {
                    return true;
                }
            }
            return false;
        }

        private boolean warningMessage(String filename, int lineNo, String message) {
            return true;
        }
    }

    private static class MisspeltMethodChecker
    implements MessageCalculator {
        private static final int MAX_EDIT_DISTANCE = 2;
        private final String message;
        private int lineNumber;
        private int column;
        private Project project;

        public MisspeltMethodChecker(String message, int column, int lineNumber, Project project) {
            this.message = message;
            this.column = column;
            this.lineNumber = lineNumber;
            this.project = project;
        }

        private static String chopAtOpeningBracket(String name) {
            int openingBracket = name.indexOf(40);
            if (openingBracket >= 0) {
                return name.substring(0, openingBracket);
            }
            return name;
        }

        private String getLine(TextEditor e) {
            return e.getText(new bluej.parser.SourceLocation(this.lineNumber, 1), new bluej.parser.SourceLocation(this.lineNumber, e.getLineLength(this.lineNumber - 1)));
        }

        private int getLineStart(TextEditor e) {
            return e.getOffsetFromLineColumn(new bluej.parser.SourceLocation(this.lineNumber, 1));
        }

        @Override
        public String calculateMessage(Editor e0) {
            if (e0 == null) {
                return this.message;
            }
            TextEditor e = e0.assumeText();
            String missing = MisspeltMethodChecker.chopAtOpeningBracket(this.message.substring(this.message.lastIndexOf(32) + 1));
            ParsedCUNode pcuNode = e.getParsedNode();
            if (pcuNode == null) {
                return this.message;
            }
            int pos = MisspeltMethodChecker.convertColumn(this.getLine(e), this.column) + this.getLineStart(e);
            TreeSet<String> maybeTheyMeant = new TreeSet<String>();
            ExpressionTypeInfo suggests = pcuNode.getExpressionType(pos, e.getSourceDocument());
            AssistContent[] values = ParseUtils.getPossibleCompletions(suggests, this.project.getJavadocResolver(), null);
            if (values != null) {
                for (AssistContent a : values) {
                    String name = a.getName();
                    if (a.getKind() != AssistContent.CompletionKind.METHOD || Utility.editDistance(name.toLowerCase(), missing.toLowerCase()) > 2) continue;
                    maybeTheyMeant.add(a.getName());
                }
            }
            if (maybeTheyMeant.isEmpty()) {
                return this.message;
            }
            String augmentedMessage = this.message + "; maybe you meant: " + (String)maybeTheyMeant.pollFirst();
            for (String sugg : maybeTheyMeant) {
                augmentedMessage = augmentedMessage + " or " + sugg;
            }
            return augmentedMessage;
        }

        private static int convertColumn(String string, int column) {
            int ccount = 0;
            int lpos = 0;
            int tabIndex = string.indexOf(9);
            while (tabIndex != -1 && lpos < column - 1) {
                lpos += tabIndex - ccount;
                ccount = tabIndex;
                if (lpos >= column - 1) break;
                lpos = (lpos + 8) / 8 * 8;
                tabIndex = string.indexOf(9, ++ccount);
            }
            return ccount += column - lpos;
        }
    }

    private class QuietPackageCompileObserver
    implements FXCompileObserver {
        protected List<FXCompileObserver> chainedObservers;

        public QuietPackageCompileObserver(List<FXCompileObserver> chainedObservers) {
            this.chainedObservers = new ArrayList<FXCompileObserver>(chainedObservers);
        }

        private void markAsCompiling(CompileInputFile[] sources, int compilationSequence) {
            for (int i = 0; i < sources.length; ++i) {
                Target t;
                String fileName = sources[i].getJavaCompileInputFile().getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(fileName);
                if (fullName == null || !((t = Package.this.getTarget(JavaNames.getBase(fullName))) instanceof ClassTarget)) continue;
                ClassTarget ct = (ClassTarget)t;
                ct.markCompiling(compilationSequence);
            }
        }

        private void sendEventToExtensions(String filename, int[] errorPosition, String message, int eventType, CompileType type) {
            File[] sources = filename != null ? new File[]{new File(filename)} : new File[]{};
            CompileEvent aCompileEvent = new CompileEvent(eventType, type.keepClasses(), sources);
            aCompileEvent.setErrorPosition(errorPosition);
            aCompileEvent.setErrorMessage(message);
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
        }

        @Override
        public void startCompile(CompileInputFile[] sources, CompileReason reason, CompileType type, int compilationSequence) {
            CompileEvent aCompileEvent = new CompileEvent(1, type.keepClasses(), Utility.mapList(Arrays.asList(sources), CompileInputFile::getJavaCompileInputFile).toArray(new File[0]));
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
            if (type.keepClasses()) {
                Package.this.setStatus(compiling);
            }
            this.markAsCompiling(sources, compilationSequence);
            for (FXCompileObserver chainedObserver : this.chainedObservers) {
                chainedObserver.startCompile(sources, reason, type, compilationSequence);
            }
        }

        @Override
        public boolean compilerMessage(Diagnostic diagnostic, CompileType type) {
            int[] errorPosition = new int[]{(int)diagnostic.getStartLine(), (int)diagnostic.getStartColumn(), (int)diagnostic.getEndLine(), (int)diagnostic.getEndColumn()};
            if (diagnostic.getType() == Diagnostic.ERROR) {
                this.errorMessage(diagnostic.getFileName(), errorPosition, diagnostic.getMessage(), type);
            } else {
                this.warningMessage(diagnostic.getFileName(), errorPosition, diagnostic.getMessage(), type);
            }
            boolean shown = false;
            for (FXCompileObserver chainedObserver : this.chainedObservers) {
                boolean s = chainedObserver.compilerMessage(diagnostic, type);
                shown = shown || s;
            }
            return shown;
        }

        private void errorMessage(String filename, int[] errorPosition, String message, CompileType type) {
            this.sendEventToExtensions(filename, errorPosition, message, 3, type);
        }

        private void warningMessage(String filename, int[] errorPosition, String message, CompileType type) {
            this.sendEventToExtensions(filename, errorPosition, message, 2, type);
        }

        @Override
        public void endCompile(CompileInputFile[] sources, boolean successful, CompileType type, int compilationSequence) {
            ArrayList<ClassTarget> targetsToAnalyse = new ArrayList<ClassTarget>();
            ArrayList<ClassTarget> readyToCompileList = new ArrayList<ClassTarget>();
            for (int i = 0; i < sources.length; ++i) {
                ClassTarget t;
                String filename = sources[i].getJavaCompileInputFile().getPath();
                String fullName = Package.this.getProject().convertPathToPackageName(filename);
                if (fullName == null || (t = (ClassTarget)Package.this.targets.get(JavaNames.getBase(fullName))) == null) continue;
                t.markCompiled(successful, type);
                if (t.getState() == DependentTarget.State.COMPILED) {
                    targetsToAnalyse.add(t);
                } else if (t.getState() == DependentTarget.State.NEEDS_COMPILE && type == CompileType.EXPLICIT_USER_COMPILE && !Package.this.checkDependecyCompilationError(t)) {
                    readyToCompileList.add(t);
                }
                t.setQueued(false);
                if (!t.isCompiled()) continue;
                Class<?> c = Package.this.loadClass(Package.this.getQualifiedName(t.getIdentifierName()));
                if (c != null && !Package.checkClassMatchesFile(c, t.getClassFile())) {
                    String conflict = Package.getResourcePath(c);
                    String ident = t.getIdentifierName() + ":";
                    DialogManager.showMessageWithPrefixTextFX(null, "compile-class-library-conflict", ident, conflict);
                }
                try {
                    ClassInfo info = t.getSourceInfo().getInfo(t.getJavaSourceFile(), t.getPackage());
                    if (info == null) continue;
                    FileOutputStream out = new FileOutputStream(t.getContextFile());
                    info.getComments().store(out, "BlueJ class context");
                    ((OutputStream)out).close();
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            Package.this.doCompile(readyToCompileList, this, CompileReason.USER, CompileType.EXPLICIT_USER_COMPILE);
            for (ClassTarget classTarget : targetsToAnalyse) {
                classTarget.analyseAfterCompile();
            }
            if (type.keepClasses()) {
                Package.this.setStatus(compileDone);
            }
            Package.this.fireChangedEvent();
            int eventId = successful ? 4 : 5;
            CompileEvent aCompileEvent = new CompileEvent(eventId, type.keepClasses(), Utility.mapList(Arrays.asList(sources), CompileInputFile::getJavaCompileInputFile).toArray(new File[0]));
            ExtensionsManager.getInstance().delegateEvent((ExtensionEvent)aCompileEvent);
            for (FXCompileObserver chainedObserver : this.chainedObservers) {
                chainedObserver.endCompile(sources, successful, type, compilationSequence);
            }
        }
    }

    private static enum ErrorShown {
        ERROR_SHOWN,
        ERROR_NOT_SHOWN,
        EDITOR_NOT_FOUND;

    }

    public static interface MessageCalculator {
        public String calculateMessage(Editor var1);
    }

    private static enum ShowSourceReason {
        STEP_OR_HALT,
        BREAKPOINT_HIT,
        FRAME_SELECTED;


        public boolean isSuspension() {
            return this == STEP_OR_HALT || this == BREAKPOINT_HIT;
        }
    }
}

