/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.actions.RestartVMAction;
import bluej.utility.javafx.JavaFXUtil;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class MachineIcon
extends HBox {
    private static final int NUM_BARS = 12;
    private static final double MIN_INTENSITY = 0.3;
    private final Pane barContainer;
    private final Rectangle bar;
    private final ButtonBase resetButton;
    private final DoubleProperty indicatorPosition = new SimpleDoubleProperty(0.0);
    private final BooleanProperty running = new SimpleBooleanProperty(false);
    private final RestartVMAction resetAction;
    private ContextMenu contextMenu;
    private Animation animation;

    public MachineIcon(PkgMgrFrame pmf, RestartVMAction resetAction) {
        JavaFXUtil.addStyleClass((Styleable)this, "machine-icon-container");
        this.barContainer = new Pane();
        HBox.setHgrow((Node)this.barContainer, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.barContainer, (Insets)new Insets(2.0, 0.0, 1.0, 0.0));
        JavaFXUtil.addStyleClass((Styleable)this.barContainer, "machine-icon-bar-holder");
        this.bar = new Rectangle();
        JavaFXUtil.addStyleClass((Styleable)this.bar, "machine-icon-bar");
        this.barContainer.getChildren().add((Object)this.bar);
        this.bar.setManaged(false);
        double width = 0.3;
        this.bar.layoutXProperty().bind((ObservableValue)this.indicatorPosition.multiply((ObservableNumberValue)this.barContainer.widthProperty().multiply(1.0 - width)).add(2.0));
        this.bar.layoutYProperty().set(2.0);
        this.bar.widthProperty().bind((ObservableValue)this.barContainer.widthProperty().multiply(width).subtract(4.0));
        this.bar.heightProperty().bind((ObservableValue)this.barContainer.heightProperty().subtract(4.0));
        JavaFXUtil.bindPseudoclass((Node)this.bar, "bj-active", (BooleanExpression)this.running);
        this.resetAction = resetAction;
        this.resetButton = this.resetAction.makeButton();
        this.resetButton.setText(null);
        this.resetButton.setGraphic(MachineIcon.drawResetArrow());
        this.resetButton.setFocusTraversable(false);
        JavaFXUtil.addStyleClass((Styleable)this.resetButton, "reset-vm-button");
        JavaFXUtil.setPseudoclass("bj-no-hover", true, new Node[]{this.resetButton});
        this.resetButton.setOnMouseEntered(e -> JavaFXUtil.setPseudoclass("bj-no-hover", false, new Node[]{this.resetButton}));
        this.resetButton.setOnMouseExited(e -> JavaFXUtil.setPseudoclass("bj-no-hover", true, new Node[]{this.resetButton}));
        this.getChildren().addAll((Object[])new Node[]{this.barContainer, this.resetButton});
        Tooltip.install((Node)this.barContainer, (Tooltip)new Tooltip(Config.getString("tooltip.progress")));
        this.resetButton.setTooltip(new Tooltip(Config.getString("workIndicator.resetMachine")));
        JavaFXUtil.listenForContextMenu((Node)this.barContainer, (x, y) -> {
            if (this.contextMenu != null) {
                this.contextMenu.hide();
            }
            MenuItem item = new MenuItem(Config.getString("workIndicator.resetMachine"));
            item.setOnAction(e -> this.resetAction.actionPerformed(pmf));
            this.contextMenu = new ContextMenu(new MenuItem[]{item});
            this.contextMenu.show((Node)this.barContainer, x.doubleValue(), y.doubleValue());
            return true;
        }, new KeyCode[0]);
    }

    private static Node drawResetArrow() {
        Path path = new Path();
        JavaFXUtil.addStyleClass((Styleable)path, "reset-vm-button-arrow");
        path.getElements().addAll((Object[])new PathElement[]{new MoveTo(1.0, 1.0), new LineTo(9.0, 1.0), new MoveTo(9.0, 1.0), new ArcTo(5.0, 5.0, 180.0, 9.0, 11.0, false, true), new MoveTo(9.0, 11.0), new LineTo(1.0, 11.0), new LineTo(4.0, 8.0), new MoveTo(1.0, 11.0), new LineTo(4.0, 14.0)});
        return path;
    }

    private void cancelAnimation() {
        if (this.animation != null) {
            this.animation.stop();
            this.animation = null;
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void setIdle() {
        this.cancelAnimation();
        this.running.set(false);
        this.indicatorPosition.set(0.0);
    }

    @OnThread(value=Tag.FXPlatform)
    public void setRunning() {
        this.cancelAnimation();
        this.running.set(true);
        this.animation = new Timeline(30.0, new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.indicatorPosition, (Object)0, Interpolator.LINEAR)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)this.indicatorPosition, (Object)1.0, Interpolator.LINEAR)})});
        this.animation.setAutoReverse(true);
        this.animation.setCycleCount(-1);
        this.animation.playFromStart();
    }

    @OnThread(value=Tag.FXPlatform)
    public void setStopped() {
        this.cancelAnimation();
    }
}

