/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.Reflective;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.ExpressionTypeInfo;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.ParsedReflective;
import bluej.parser.entity.TparEntity;
import bluej.parser.entity.TypeEntity;
import bluej.parser.entity.ValueEntity;
import bluej.parser.lexer.LocatableToken;
import bluej.parser.nodes.IncrementalParsingNode;
import bluej.parser.nodes.JavaParentNode;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParseParams;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.TypeInnerNode;
import java.util.Collections;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ParsedTypeNode
extends IncrementalParsingNode {
    private String name;
    private String prefix;
    private TypeInnerNode inner;
    private List<TparEntity> typeParams;
    private List<JavaEntity> extendedTypes;
    private List<JavaEntity> implementedTypes;
    private int modifiers;
    private ParsedTypeNode containingClass;
    private int type;

    public ParsedTypeNode(JavaParentNode parent, ParsedTypeNode containingClass, int type, String prefix, int modifiers) {
        super(parent);
        this.stateMarkers = new int[2];
        this.marksEnd = new boolean[2];
        this.stateMarkers[0] = -1;
        this.stateMarkers[1] = -1;
        this.type = type;
        this.prefix = prefix;
        this.modifiers = modifiers;
        this.containingClass = containingClass;
        this.typeParams = Collections.emptyList();
        this.extendedTypes = Collections.emptyList();
        this.implementedTypes = Collections.emptyList();
    }

    public int getTypeKind() {
        return this.type;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public ParsedTypeNode getContainingClass() {
        return this.containingClass;
    }

    public void setTypeParams(List<TparEntity> typeParams) {
        this.typeParams = typeParams;
    }

    public List<TparEntity> getTypeParams() {
        return this.typeParams;
    }

    public void setImplementedTypes(List<JavaEntity> implementedTypes) {
        this.implementedTypes = implementedTypes;
    }

    public List<JavaEntity> getImplementedTypes() {
        return this.implementedTypes;
    }

    public void setExtendedTypes(List<JavaEntity> extendedTypes) {
        this.extendedTypes = extendedTypes;
    }

    public List<JavaEntity> getExtendedTypes() {
        return this.extendedTypes;
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.getParentNode().childChangedName(this, oldName);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void insertInner(TypeInnerNode child, int position, int size) {
        super.insertNode(child, position, size);
        this.inner = child;
        this.stateMarkers[1] = position + size;
    }

    public TypeInnerNode getInner() {
        return this.inner;
    }

    @Override
    protected void childRemoved(NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        if (child.getNode() == this.inner) {
            this.inner = null;
            this.stateMarkers[1] = -1;
        }
        super.childRemoved(child, listener);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    protected int doPartialParse(ParseParams params, int state) {
        if (state == 0) {
            LocatableToken la = params.tokenStream.LA(1);
            this.setCommentAttached(la.getHiddenBefore() != null);
            int r = params.parser.parseTypeDefBegin();
            if (r == 5) {
                return 4;
            }
            this.type = r;
            params.parser.initializeTypeExtras();
            LocatableToken token = params.tokenStream.nextToken();
            if (token.getType() != 69) {
                this.last = token;
                return 1;
            }
            this.setName(token.getText());
            token = params.parser.parseTypeDefPart2();
            if (token == null) {
                this.last = params.tokenStream.LA(1);
                return 1;
            }
            this.last = token;
            params.tokenStream.pushBack(token);
            this.setExtendedTypes(params.parser.getExtendedTypes());
            this.setTypeParams(params.parser.getTparList(this));
            return 6;
        }
        if (state == 1) {
            this.last = params.tokenStream.nextToken();
            if (this.last.getType() != 99) {
                return 7;
            }
            if (this.inner == null) {
                int oldStateMarker = this.stateMarkers[1];
                this.last = params.parser.parseTypeBody(this.type, this.last);
                if (this.last.getType() == 100) {
                    this.inner.setComplete(true);
                }
                params.tokenStream.pushBack(this.last);
                this.stateMarkers[1] = oldStateMarker;
                return 6;
            }
            NodeTree.NodeAndPosition<ParsedNode> nextChild = params.childQueue.peek();
            while (nextChild != null && nextChild.getNode() != this.inner) {
                this.childRemoved(nextChild, params.listener);
                params.childQueue.poll();
                nextChild = params.childQueue.peek();
            }
            params.abortPos = ParsedTypeNode.lineColToPos(params.document, this.last.getEndLine(), this.last.getEndColumn());
            return 8;
        }
        if (state == 2) {
            this.last = params.tokenStream.nextToken();
            int innerOffset = this.inner.getOffsetFromParent();
            int innerPos = innerOffset + params.nodePos;
            int innerSize = this.inner.getSize();
            if (this.last.getType() != 100) {
                this.inner.setComplete(false);
                this.inner.setSize(this.getSize() - innerOffset);
                params.listener.nodeChangedLength(new NodeTree.NodeAndPosition<ParsedNode>(this.inner, innerPos, this.getSize() - innerOffset), innerPos, innerSize);
                this.stateMarkers[1] = this.getSize();
                params.document.scheduleReparse(innerPos + innerSize, this.getSize() - innerOffset - innerSize);
                params.abortPos = innerPos + innerSize;
                this.complete = false;
                return 9;
            }
            int lastPos = ParsedTypeNode.lineColToPos(params.document, this.last.getLine(), this.last.getColumn());
            if (innerPos + innerSize != lastPos || !this.inner.complete) {
                this.inner.complete = false;
                lastPos = ParsedTypeNode.lineColToPos(params.document, this.last.getEndLine(), this.last.getEndColumn());
                this.inner.setSize(lastPos - innerPos);
                params.listener.nodeChangedLength(new NodeTree.NodeAndPosition<ParsedNode>(this.inner, innerPos, lastPos - innerPos), innerPos, innerSize);
                this.stateMarkers[1] = lastPos - params.nodePos;
                params.document.scheduleReparse(innerPos + innerSize, lastPos - innerPos - innerSize);
                params.abortPos = innerPos + innerSize;
                return 9;
            }
            return 3;
        }
        return 4;
    }

    @Override
    protected boolean isDelimitingNode(NodeTree.NodeAndPosition<ParsedNode> nap) {
        return nap.getNode().isInner();
    }

    @Override
    protected boolean isNodeEndMarker(int tokenType) {
        return false;
    }

    @Override
    protected boolean marksOwnEnd() {
        return true;
    }

    @Override
    public void childResized(MoeSyntaxDocument document, int nodePos, NodeTree.NodeAndPosition<ParsedNode> child) {
        if (child.getNode() == this.inner) {
            this.stateMarkers[1] = child.getEnd() - nodePos;
        }
    }

    @Override
    public ExpressionTypeInfo getExpressionType(int pos, int nodePos, JavaEntity defaultType, MoeSyntaxDocument document) {
        this.valueEntityCache.clear();
        this.pocEntityCache.clear();
        ValueEntity myType = new ValueEntity(new GenTypeClass(new ParsedReflective(this)));
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNode(pos, nodePos);
        if (child != null) {
            return child.getNode().getExpressionType(pos, child.getPosition(), myType, document);
        }
        return null;
    }

    @Override
    public PackageOrClass resolvePackageOrClass(String name, Reflective querySource) {
        if (this.typeParams != null) {
            TypeEntity tent;
            JavaEntity ent = null;
            for (TparEntity tent2 : this.typeParams) {
                if (!tent2.getName().equals(name)) continue;
                ent = tent2;
                break;
            }
            if (ent != null && (tent = ent.resolveAsType()) != null) {
                return tent;
            }
        }
        return super.resolvePackageOrClass(name, querySource);
    }
}

