/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.entity;

import bluej.debugger.gentype.FieldReflective;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.parser.entity.JavaEntity;
import bluej.parser.entity.PackageOrClass;
import bluej.parser.entity.TypeArgumentEntity;
import bluej.parser.entity.ValueEntity;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TypeEntity
extends PackageOrClass {
    private JavaType thisType;

    public TypeEntity(JavaType type) {
        this.thisType = type;
    }

    public TypeEntity(Reflective ref) {
        this.thisType = new GenTypeClass(ref);
    }

    public TypeEntity(Class<?> c) {
        JavaReflective thisRef = new JavaReflective(c);
        this.thisType = new GenTypeClass(thisRef);
    }

    TypeEntity(Reflective r, GenTypeClass outer) {
        this.thisType = new GenTypeClass(r, Collections.emptyList(), outer);
    }

    @Override
    public JavaType getType() {
        return this.thisType;
    }

    public GenTypeClass getClassType() {
        return this.thisType.asClass();
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public JavaEntity getSubentity(String name, Reflective accessor) {
        GenTypeClass thisClass = this.thisType.asClass();
        if (thisClass == null) {
            return null;
        }
        if (thisClass.getArrayComponent() != null) {
            return null;
        }
        LinkedList<Reflective> stypes = new LinkedList<Reflective>();
        Reflective ctypeRef = thisClass.getReflective();
        stypes.add(ctypeRef);
        while (!stypes.isEmpty()) {
            boolean accessAllowed;
            ctypeRef = (Reflective)stypes.poll();
            Map<String, FieldReflective> m = ctypeRef.getDeclaredFields();
            FieldReflective field = m.get(name);
            if (field != null && (accessAllowed = JavaUtils.checkMemberAccess(ctypeRef, thisClass, accessor, field.getModifiers(), true))) {
                thisClass = thisClass.mapToSuper(ctypeRef.getName());
                JavaType fieldType = field.getType().mapTparsToTypes(thisClass.getMap()).getUpperBound();
                return new ValueEntity(name, fieldType);
            }
            stypes.addAll(ctypeRef.getSuperTypesR());
        }
        return this.getPackageOrClassMember(name);
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public TypeEntity getPackageOrClassMember(String name) {
        GenTypeClass thisClass = this.thisType.asClass();
        if (thisClass == null || thisClass.getArrayComponent() != null) {
            return null;
        }
        LinkedList<Reflective> stypes = new LinkedList<Reflective>();
        stypes.add(thisClass.getReflective());
        while (!stypes.isEmpty()) {
            Reflective thisRef = (Reflective)stypes.poll();
            Reflective member = thisRef.getInnerClass(name);
            if (member != null) {
                GenTypeClass inner = new GenTypeClass(member, Collections.emptyList(), thisClass);
                return new TypeEntity(inner);
            }
            stypes.addAll(thisRef.getSuperTypesR());
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getType().toString();
    }

    @Override
    public TypeEntity setTypeArgs(List<TypeArgumentEntity> tparams) {
        GenTypeClass classType = this.thisType.asClass();
        if (classType == null) {
            return null;
        }
        GenTypeClass outer = classType.getOuterType();
        LinkedList<GenTypeParameter> ttparams = new LinkedList<GenTypeParameter>();
        for (TypeArgumentEntity eparam : tparams) {
            GenTypeParameter tparamType = eparam.getType();
            if (tparamType == null) {
                return null;
            }
            ttparams.add(tparamType);
        }
        return new TypeEntity(new GenTypeClass(classType.getReflective(), ttparams, outer));
    }

    @Override
    public TypeEntity resolveAsType() {
        return this;
    }
}

