/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import bluej.stride.generic.InteractionManager;
import bluej.utility.Utility;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class AssistContent {
    @OnThread(value=Tag.Any)
    public abstract String getName();

    @OnThread(value=Tag.FXPlatform)
    public abstract List<ParamInfo> getParams();

    public abstract String getType();

    public abstract Access getAccessPermission();

    public abstract String getDeclaringClass();

    public abstract CompletionKind getKind();

    @OnThread(value=Tag.FXPlatform)
    public abstract String getJavadoc();

    public String getPackage() {
        return null;
    }

    public List<String> getSuperTypes() {
        return null;
    }

    public InteractionManager.Kind getTypeKind() {
        return null;
    }

    public static Access fromModifiers(int modifiers) {
        if (Modifier.isPrivate(modifiers)) {
            return Access.PRIVATE;
        }
        if (Modifier.isProtected(modifiers)) {
            return Access.PROTECTED;
        }
        if (Modifier.isPublic(modifiers)) {
            return Access.PUBLIC;
        }
        return Access.PACKAGE;
    }

    public static Comparator<AssistContent> getComparator() {
        return Comparator.comparing(AssistContent::getName).thenComparing(AssistContent::getKind).thenComparing(AssistContent::getParams, Utility.listComparator(Comparator.comparing(ParamInfo::getQualifiedType)));
    }

    public static interface JavadocCallback {
        public void gotJavadoc(AssistContent var1);
    }

    @OnThread(value=Tag.Any)
    public static class ParamInfo {
        private final String fullType;
        private final String formalName;
        private final String dummyName;
        private final Supplier<String> javadocDescription;

        public ParamInfo(String fullType, String formalName, String dummyName, Supplier<String> javadocDescription) {
            this.fullType = fullType;
            this.formalName = formalName;
            this.dummyName = dummyName;
            this.javadocDescription = javadocDescription;
        }

        public String getQualifiedType() {
            return this.fullType;
        }

        public String getUnqualifiedType() {
            int beginCurIdent = -1;
            StringBuilder r = new StringBuilder();
            for (int i = 0; i < this.fullType.length(); ++i) {
                char c = this.fullType.charAt(i);
                if (beginCurIdent == -1 && Character.isJavaIdentifierStart(c)) {
                    beginCurIdent = i;
                    continue;
                }
                if (beginCurIdent != -1) {
                    if (c == '.') {
                        beginCurIdent = -1;
                        continue;
                    }
                    if (Character.isJavaIdentifierPart(c)) continue;
                    r.append(this.fullType.substring(beginCurIdent, i + 1));
                    beginCurIdent = -1;
                    continue;
                }
                r.append(c);
            }
            if (beginCurIdent != -1) {
                r.append(this.fullType.substring(beginCurIdent, this.fullType.length()));
            }
            return r.toString();
        }

        public String getDummyName() {
            return this.dummyName;
        }

        public String getFormalName() {
            return this.formalName;
        }

        public String getJavadocDescription() {
            return this.javadocDescription.get();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParamInfo paramInfo = (ParamInfo)o;
            if (this.fullType != null ? !this.fullType.equals(paramInfo.fullType) : paramInfo.fullType != null) {
                return false;
            }
            if (this.formalName != null ? !this.formalName.equals(paramInfo.formalName) : paramInfo.formalName != null) {
                return false;
            }
            if (this.dummyName != null ? !this.dummyName.equals(paramInfo.dummyName) : paramInfo.dummyName != null) {
                return false;
            }
            return !(this.javadocDescription == null ? paramInfo.javadocDescription != null : !this.javadocDescription.equals(paramInfo.javadocDescription));
        }

        public int hashCode() {
            int result = this.fullType != null ? this.fullType.hashCode() : 0;
            result = 31 * result + (this.formalName != null ? this.formalName.hashCode() : 0);
            result = 31 * result + (this.dummyName != null ? this.dummyName.hashCode() : 0);
            result = 31 * result + (this.javadocDescription != null ? this.javadocDescription.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ParamInfo{dummyName='" + this.dummyName + "', fullType='" + this.fullType + "', formalName='" + this.formalName + "', javadocDescription='" + (this.javadocDescription == null ? null : Integer.valueOf(this.javadocDescription.hashCode())) + "'}";
        }
    }

    @OnThread(value=Tag.Any)
    public static enum CompletionKind {
        METHOD,
        CONSTRUCTOR,
        FIELD,
        LOCAL_VAR,
        FORMAL_PARAM,
        TYPE;


        public static Set<CompletionKind> allMembers() {
            return new HashSet<CompletionKind>(Arrays.asList(METHOD, FIELD));
        }
    }

    @OnThread(value=Tag.Any)
    public static enum Access {
        PRIVATE,
        PROTECTED,
        PACKAGE,
        PUBLIC;

    }
}

