/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.Repository;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamViewFilter;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.ResourceDescriptor;
import bluej.groupwork.ui.StatusTableCell;
import bluej.groupwork.ui.StatusTableModel;
import bluej.groupwork.ui.StatusTableModelDVCS;
import bluej.groupwork.ui.StatusTableModelNonDVCS;
import bluej.pkgmgr.Project;
import bluej.utility.FXWorker;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class StatusFrame
extends FXCustomizedDialog<Void> {
    private Project project;
    private Repository repository;
    private StatusTableModel statusModel;
    private Button refreshButton;
    private ActivityIndicator progressBar;
    private StatusWorker worker;
    private static final int MAX_ENTRIES = 20;
    private final boolean isDVCS;
    private TableView<TeamStatusInfo> statusTable;

    public StatusFrame(Project project) {
        super(null, "team.status", "team-status");
        this.project = project;
        this.isDVCS = project.getTeamSettingsController().isDVCS();
        this.getDialogPane().setContent(this.makeMainPane());
        this.prepareButtonPane();
    }

    @Override
    protected Node wrapButtonBar(Node original) {
        this.makeRefreshPaneComponents();
        BorderPane borderPane = new BorderPane((Node)this.progressBar, null, original, null, (Node)this.refreshButton);
        JavaFXUtil.addStyleClass((Styleable)borderPane, "replacement-button-bar");
        return borderPane;
    }

    private Node makeMainPane() {
        this.statusModel = this.isDVCS ? new StatusTableModelDVCS(this.project, this.estimateInitialEntries()) : new StatusTableModelNonDVCS(this.project, this.estimateInitialEntries());
        this.statusTable = new TableView(this.statusModel.getResources());
        TableColumn firstColumn = new TableColumn(this.statusModel.getColumnName(0));
        JavaFXUtil.addStyleClass((Styleable)firstColumn, "team-status-firstColumn");
        firstColumn.prefWidthProperty().bind((ObservableValue)this.statusTable.widthProperty().multiply(0.49));
        firstColumn.setCellValueFactory(v -> new ReadOnlyStringWrapper(ResourceDescriptor.getResource(this.project, (TeamStatusInfo)v.getValue(), false)));
        TableColumn secondColumn = new TableColumn(this.statusModel.getColumnName(1));
        JavaFXUtil.addStyleClass((Styleable)secondColumn, "team-status-secondColumn");
        secondColumn.prefWidthProperty().bind((ObservableValue)this.statusTable.widthProperty().multiply(0.249));
        secondColumn.setCellValueFactory(v -> new ReadOnlyObjectWrapper(this.getValueAt((TeamStatusInfo)v.getValue(), 1)));
        secondColumn.setCellFactory(col -> new StatusTableCell(this.isDVCS, 1));
        TableColumn thirdColumn = new TableColumn(this.statusModel.getColumnName(2));
        JavaFXUtil.addStyleClass((Styleable)thirdColumn, "team-status-thirdColumn");
        thirdColumn.prefWidthProperty().bind((ObservableValue)this.statusTable.widthProperty().multiply(0.249));
        thirdColumn.setCellValueFactory(v -> new ReadOnlyObjectWrapper(this.getValueAt((TeamStatusInfo)v.getValue(), 2)));
        thirdColumn.setCellFactory(col -> new StatusTableCell(this.isDVCS, 2));
        this.statusTable.getColumns().setAll((Object[])new TableColumn[]{firstColumn, secondColumn, thirdColumn});
        this.statusTable.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        this.statusTable.setBackground(null);
        JavaFXUtil.addStyleClass(this.statusTable, new String[]{"status-table"});
        return new BorderPane(this.statusTable);
    }

    private void makeRefreshPaneComponents() {
        this.progressBar = new ActivityIndicator();
        this.progressBar.setRunning(false);
        BorderPane.setAlignment((Node)this.progressBar, (Pos)Pos.CENTER);
        this.refreshButton = new Button(Config.getString("team.status.refresh"));
        this.refreshButton.setDisable(true);
        this.refreshButton.setOnAction(event -> this.update());
        this.refreshButton.requestFocus();
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setOnCloseRequest(event -> {
            if (this.worker != null) {
                this.worker.abort();
            }
        });
    }

    private int estimateInitialEntries() {
        int initialEntries = this.project.getFilesInProject(true, false).size() + 1;
        if (initialEntries > 20) {
            initialEntries = 20;
        }
        return initialEntries;
    }

    public void update() {
        this.repository = this.project.getRepository();
        if (this.repository != null) {
            this.progressBar.setRunning(true);
            this.refreshButton.setDisable(true);
            this.worker = new StatusWorker();
            this.worker.start();
        } else {
            this.hide();
        }
    }

    public Object getValueAt(TeamStatusInfo info, int col) {
        switch (col) {
            case 1: {
                return this.isDVCS ? info.getStatus() : info.getLocalVersion();
            }
            case 2: {
                return info.getStatus(!this.isDVCS);
            }
        }
        return null;
    }

    class StatusWorker
    extends FXWorker
    implements StatusListener {
        ObservableList<TeamStatusInfo> resources;
        TeamworkCommand command;
        TeamworkCommandResult result;
        boolean aborted;
        FileFilter filter;

        public StatusWorker() {
            this.filter = StatusFrame.this.project.getTeamSettingsController().getFileFilter(true, true);
            this.resources = FXCollections.observableArrayList();
            this.command = StatusFrame.this.repository.getStatus(this, this.filter, true);
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.result = this.command.getResult();
            return this.resources;
        }

        @Override
        @OnThread(value=Tag.Any)
        public void gotStatus(TeamStatusInfo info) {
            this.resources.add((Object)info);
        }

        @Override
        @OnThread(value=Tag.Any)
        public void statusComplete(StatusHandle commitHandle) {
        }

        @Override
        public void finished() {
            StatusFrame.this.progressBar.setRunning(false);
            if (!this.aborted) {
                if (this.result.isError()) {
                    StatusFrame.this.dialogThenHide(() -> TeamUtils.handleServerResponseFX(this.result, StatusFrame.this.asWindow()));
                } else {
                    this.resources.sort((info0, info1) -> info1.getStatus().ordinal() - info0.getStatus().ordinal());
                    TeamViewFilter filter = new TeamViewFilter();
                    this.resources.removeIf(info -> !filter.accept((TeamStatusInfo)info));
                    StatusFrame.this.statusModel.setStatusData(this.resources);
                    HashMap<File, String> statusMap = new HashMap<File, String>();
                    for (TeamStatusInfo s : this.resources) {
                        statusMap.put(s.getFile(), s.getStatus().getStatusString());
                    }
                    DataCollector.teamStatusProject(StatusFrame.this.project, StatusFrame.this.repository, statusMap);
                }
                StatusFrame.this.refreshButton.setDisable(false);
                if (StatusFrame.this.statusTable.getItems() != null) {
                    StatusFrame.this.statusTable.getItems().clear();
                }
                StatusFrame.this.statusTable.refresh();
                StatusFrame.this.statusTable.setItems(this.resources);
                TableColumn secondColumn = (TableColumn)StatusFrame.this.statusTable.getColumns().get(1);
                StatusFrame.this.statusTable.getSortOrder().add((Object)secondColumn);
                secondColumn.setSortType(TableColumn.SortType.DESCENDING);
            }
        }
    }
}

