/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.HistoryInfo;
import bluej.groupwork.LogHistoryListener;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.ui.ActivityIndicator;
import bluej.groupwork.ui.DateCompare;
import bluej.groupwork.ui.HistoryCell;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.DialogManager;
import bluej.utility.FXWorker;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class HistoryFrame
extends FXCustomizedDialog<Void> {
    private Project project;
    private HistoryWorker worker;
    private List<HistoryInfo> historyInfoList;
    private ObservableList<HistoryInfo> listModel = FXCollections.observableArrayList();
    private ListView<HistoryInfo> historyList = new ListView(this.listModel);
    private ComboBox<String> fileFilterCombo = new ComboBox();
    private ComboBox<String> userFilterCombo = new ComboBox();
    private ActivityIndicator activityBar = new ActivityIndicator();

    public HistoryFrame(PkgMgrFrame pmf) {
        super((Window)pmf.getFXWindow(), "team.history.title", "team-history");
        this.project = pmf.getProject();
        this.prepareData();
        this.prepareButtonPane();
        this.getDialogPane().setContent((Node)this.makeMainPane());
        DialogManager.centreDialog(this);
    }

    private Pane makeMainPane() {
        this.historyList.setCellFactory(param -> new HistoryCell());
        ScrollPane historyPane = new ScrollPane(this.historyList);
        historyPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        historyPane.setFitToWidth(true);
        historyPane.setFitToHeight(true);
        HBox filterBox = new HBox();
        filterBox.setAlignment(Pos.BASELINE_LEFT);
        filterBox.getChildren().addAll((Object[])new Node[]{new Label(Config.getString("team.history.filefilter") + " "), this.fileFilterCombo, new Label(Config.getString("team.history.userfilter") + " "), this.userFilterCombo, this.activityBar});
        HBox.setMargin(this.fileFilterCombo, (Insets)new Insets(0.0, 40.0, 0.0, 0.0));
        HBox.setMargin(this.userFilterCombo, (Insets)new Insets(0.0, 40.0, 0.0, 0.0));
        VBox mainPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)mainPane, "main-pane");
        mainPane.getChildren().addAll((Object[])new Node[]{historyPane, filterBox});
        VBox.setVgrow((Node)historyPane, (Priority)Priority.ALWAYS);
        return mainPane;
    }

    private void prepareButtonPane() {
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.setOnCloseRequest(event -> {
            if (this.worker != null) {
                this.worker.abort();
            }
        });
    }

    private void prepareData() {
        Repository repository = this.project.getTeamSettingsController().isDVCS() ? this.project.getTeamSettingsController().trytoEstablishRepository(false) : this.project.getRepository();
        if (repository != null) {
            this.worker = new HistoryWorker(repository);
            this.worker.start();
            this.activityBar.setRunning(true);
        }
    }

    private void refilter() {
        List<Object> displayList;
        String user = null;
        if (this.userFilterCombo.getSelectionModel().getSelectedIndex() > 0) {
            user = (String)this.userFilterCombo.getSelectionModel().getSelectedItem();
        }
        String file = null;
        if (this.fileFilterCombo.getSelectionModel().getSelectedIndex() > 0) {
            file = (String)this.fileFilterCombo.getSelectionModel().getSelectedItem();
        }
        if (user == null && file == null) {
            displayList = this.historyInfoList;
        } else {
            displayList = new ArrayList();
            for (HistoryInfo info : this.historyInfoList) {
                if (user != null && !info.getUser().equals(user) || file != null && !this.historyInfoHasFile(info, file)) continue;
                displayList.add(info);
            }
        }
        this.listModel.setAll(displayList);
    }

    private boolean historyInfoHasFile(HistoryInfo info, String file) {
        return Arrays.stream(info.getFiles()).anyMatch(f -> f.equals(file));
    }

    private void resetFilterBoxes() {
        TreeSet files = new TreeSet();
        TreeSet<String> users = new TreeSet<String>();
        for (HistoryInfo info : this.historyInfoList) {
            users.add(info.getUser());
            Collections.addAll(files, info.getFiles());
        }
        this.fileFilterCombo.getItems().clear();
        this.fileFilterCombo.getItems().add((Object)Config.getString("team.history.allFiles"));
        this.fileFilterCombo.getItems().addAll(files);
        this.fileFilterCombo.getSelectionModel().selectFirst();
        this.fileFilterCombo.setOnAction(e -> this.refilter());
        this.userFilterCombo.getItems().clear();
        this.userFilterCombo.getItems().add((Object)Config.getString("team.history.allUsers"));
        this.userFilterCombo.getItems().addAll(users);
        this.userFilterCombo.getSelectionModel().selectFirst();
        this.userFilterCombo.setOnAction(e -> this.refilter());
    }

    private class HistoryWorker
    extends FXWorker
    implements LogHistoryListener {
        private List<HistoryInfo> responseList = new ArrayList<HistoryInfo>();
        private Repository repository;
        private TeamworkCommand command;
        private TeamworkCommandResult response;

        public HistoryWorker(Repository repository) {
            this.command = repository.getLogHistory(this);
            this.repository = repository;
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            this.response = this.command.getResult();
            return this.response;
        }

        @Override
        @OnThread(value=Tag.Any)
        public void logInfoAvailable(HistoryInfo hInfo) {
            this.responseList.add(hInfo);
        }

        @Override
        public void finished() {
            if (this.command != null) {
                HistoryFrame.this.activityBar.setRunning(false);
                this.command = null;
                if (this.response.isError()) {
                    HistoryFrame.this.dialogThenHide(() -> TeamUtils.handleServerResponseFX(this.response, HistoryFrame.this.asWindow()));
                } else {
                    this.responseList.sort(new DateCompare());
                    HistoryFrame.this.historyList.setPrefSize(-1.0, -1.0);
                    HistoryFrame.this.listModel.setAll(this.responseList);
                    HistoryFrame.this.historyInfoList = this.responseList;
                    HistoryFrame.this.resetFilterBoxes();
                    DataCollector.teamHistoryProject(HistoryFrame.this.project, this.repository);
                }
            }
        }

        @Override
        public void abort() {
            HistoryFrame.this.activityBar.setRunning(false);
            if (this.command != null) {
                this.command.cancel();
                this.command = null;
            }
        }
    }
}

