/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.ui;

import bluej.Config;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkProvider;
import bluej.utility.javafx.FXCustomizedDialog;
import bluej.utility.javafx.JavaFXUtil;
import javafx.application.Platform;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class CheckConnectionDialog
extends FXCustomizedDialog<Void> {
    private ProgressBar activityIndicator;
    private Text connLabel;
    private TeamSettings settings;
    private TeamworkProvider provider;

    public CheckConnectionDialog(Window owner, TeamworkProvider provider, TeamSettings settings) {
        super(owner, "team.settings.checkConnection", "team-test-connection");
        this.provider = provider;
        this.settings = settings;
        this.buildUI();
    }

    private void buildUI() {
        VBox contentPane = new VBox();
        contentPane.setMinHeight(120.0);
        JavaFXUtil.addStyleClass((Styleable)contentPane, "pane");
        this.getDialogPane().setContent((Node)contentPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.connLabel = new Text(Config.getString("team.checkconn.checking"));
        contentPane.getChildren().add((Object)new TextFlow(new Node[]{this.connLabel}));
        this.activityIndicator = new ProgressBar();
        contentPane.getChildren().add((Object)this.activityIndicator);
        this.activityIndicator.setMaxWidth(9999.0);
        contentPane.setFillWidth(true);
    }

    public void showAndCheck() {
        new Thread(new Runnable(){

            @Override
            @OnThread(value=Tag.Worker)
            public void run() {
                TeamworkCommandResult res = CheckConnectionDialog.this.provider.checkConnection(CheckConnectionDialog.this.settings);
                Platform.runLater(() -> {
                    if (!res.isError()) {
                        CheckConnectionDialog.this.connLabel.setText(Config.getString("team.checkconn.ok"));
                    } else {
                        CheckConnectionDialog.this.connLabel.setText(Config.getString("team.checkconn.bad") + System.getProperty("line.separator") + System.getProperty("line.separator") + res.getErrorMessage());
                    }
                    CheckConnectionDialog.this.activityIndicator.setProgress(1.0);
                });
            }
        }).start();
        this.showAndWait();
    }
}

