/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClientInterface;
import threadchecker.OnThread;
import threadchecker.Tag;

public abstract class SvnCommand
implements TeamworkCommand {
    private SvnRepository repository;
    private SVNClientInterface client;
    private boolean cancelled = false;

    protected SvnCommand(SvnRepository repository) {
        this.repository = repository;
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.client != null) {
            try {
                this.client.cancelOperation();
            }
            catch (ClientException ce) {
                Debug.message("Exception during subversion cancel:");
                ce.printStackTrace(System.out);
            }
        }
    }

    protected synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected SVNClientInterface getClient() {
        return this.client;
    }

    protected SvnRepository getRepository() {
        return this.repository;
    }

    @Override
    @OnThread(value=Tag.Worker)
    public TeamworkCommandResult getResult() {
        return this.repository.execCommand(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Worker)
    public TeamworkCommandResult doCommand(SVNClientInterface client) {
        SvnCommand svnCommand = this;
        synchronized (svnCommand) {
            if (this.cancelled) {
                return new TeamworkCommandAborted();
            }
            this.client = client;
        }
        TeamworkCommandResult result = this.doCommand();
        this.client = null;
        return result;
    }

    @OnThread(value=Tag.Worker)
    protected abstract TeamworkCommandResult doCommand();
}

