/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.svn;

import bluej.Config;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.TeamworkCommandUnsupportedSetting;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.UnsupportedSettingException;
import bluej.groupwork.svn.SvnRepository;
import bluej.utility.Debug;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SVNClientInterface;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SubversionProvider
implements TeamworkProvider {
    SVNClientInterface client = this.getClient();

    public SubversionProvider() {
        if (this.client == null) {
            throw new RuntimeException("Can't initialize Subversion provider.");
        }
    }

    private SVNClientInterface getClient() {
        SVNClientInterface client = null;
        try {
            Class<?> clientImplClass = Class.forName("org.tmatesoft.svn.core.javahl.SVNClientImpl");
            Method newInstanceMethod = clientImplClass.getMethod("newInstance", new Class[0]);
            Object svnClient = newInstanceMethod.invoke(null, new Object[0]);
            if (svnClient instanceof SVNClientInterface) {
                client = (SVNClientInterface)svnClient;
            } else {
                Debug.message("Subversion client class does not implement SVNClientInterface");
            }
        }
        catch (ClassNotFoundException clientImplClass) {
        }
        catch (NoSuchMethodException nsme) {
            Debug.message("No \"newInstance()\" method in SVNClientImpl class.");
            nsme.printStackTrace();
        }
        catch (LinkageError nsme) {
        }
        catch (InvocationTargetException ite) {
            Debug.message("Error while instantiating subversion client implementation.");
            ite.printStackTrace();
            if (ite.getCause() != null) {
                ite.getCause().printStackTrace();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return client;
    }

    @Override
    public String getProviderName() {
        return "Subversion";
    }

    @Override
    public TeamworkCommandResult checkConnection(TeamSettings settings) {
        this.client.username(settings.getUserName());
        this.client.password(settings.getPassword());
        String svnUrl = null;
        try {
            svnUrl = this.makeSvnUrl(settings);
            this.client.info2(svnUrl, Revision.HEAD, Revision.HEAD, false);
            return new TeamworkCommandResult();
        }
        catch (ClientException ce) {
            Debug.log("Subversion connection error:");
            Debug.reportError(svnUrl, ce);
            return new TeamworkCommandError(ce.getMessage(), ce.getLocalizedMessage());
        }
        catch (UnsupportedSettingException e) {
            return new TeamworkCommandUnsupportedSetting(e.getLocalizedMessage());
        }
    }

    @Override
    public String[] getProtocols() {
        return new String[]{"svn", "svn+ssh", "http", "https"};
    }

    @Override
    public String getProtocolKey(int protocol) {
        return this.getProtocols()[protocol];
    }

    @Override
    public String getProtocolLabel(String protocolKey) {
        return protocolKey;
    }

    @Override
    public Repository getRepository(File projectDir, TeamSettings settings) throws UnsupportedSettingException {
        try {
            SVNClientInterface client = this.getClient();
            client.username(settings.getUserName());
            client.password(settings.getPassword());
            return new SvnRepository(projectDir, settings.getProtocol(), this.makeSvnUrl(settings), client);
        }
        catch (UnsupportedSettingException e) {
            Debug.reportError("Unsupported Subversion Repository Settings " + e.getMessage());
            throw new UnsupportedSettingException(e.getLocalizedMessage());
        }
    }

    protected String makeSvnUrl(TeamSettings settings) throws UnsupportedSettingException {
        String protocol = settings.getProtocol();
        String userName = settings.getUserName();
        String server = settings.getServer();
        String prefix = settings.getPrefix();
        String group = settings.getGroup();
        if (userName.contains("@")) {
            throw new UnsupportedSettingException(Config.getString("team.error.username.at"));
        }
        Object svnUrl = protocol + "://" + userName + "@" + server;
        if (prefix.length() != 0 && !prefix.startsWith("/")) {
            svnUrl = (String)svnUrl + "/";
        }
        svnUrl = (String)svnUrl + prefix;
        if (group != null && group.length() != 0) {
            if (!((String)svnUrl).endsWith("/")) {
                svnUrl = (String)svnUrl + "/";
            }
            svnUrl = (String)svnUrl + group;
        } else if (((String)svnUrl).endsWith("/")) {
            svnUrl = ((String)svnUrl).substring(0, ((String)svnUrl).length() - 1);
        }
        return svnUrl;
    }

    @Override
    public boolean needsEmail() {
        return false;
    }

    @Override
    public boolean needsName() {
        return false;
    }

    @Override
    public String getYourEmailFromRepo(File projectPath) {
        return null;
    }

    @Override
    public String getYourNameFromRepo(File projectPath) {
        return null;
    }

    @Override
    public double getWorkingCopyVersion(File projectDir) {
        SvnWcGeneration wcGen = null;
        try {
            wcGen = SvnOperationFactory.detectWcGeneration((File)projectDir, (boolean)false);
        }
        catch (SVNException ex) {
            Debug.message(ex.getMessage());
        }
        double result = wcGen != null && wcGen.compareTo((Enum)SvnWcGeneration.V16) == 0 ? 1.6 : (wcGen != null && wcGen.compareTo((Enum)SvnWcGeneration.V17) == 0 ? 1.7 : -1.0);
        return result;
    }

    @Override
    public boolean isDVCS() {
        return false;
    }
}

