/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.UpdateListener;
import bluej.groupwork.UpdateResults;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitUtilities;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.application.Platform;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.merge.MergeStrategy;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Worker)
public class GitUpdateToCommand
extends GitCommand
implements UpdateResults {
    private final Set<File> forceFiles;
    private final UpdateListener listener;
    private final @OnThread(value=Tag.Any) List<File> conflicts = new ArrayList<File>();
    private final @OnThread(value=Tag.Any) Set<File> binaryConflicts = new HashSet<File>();

    @OnThread(value=Tag.Any)
    public GitUpdateToCommand(GitRepository repository, UpdateListener listener, Set<File> forceFiles) {
        super(repository);
        this.forceFiles = forceFiles;
        this.listener = listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @OnThread(value=Tag.Worker)
    public TeamworkCommandResult getResult() {
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            File gitPath = this.getRepository().getProjectPath();
            MergeCommand merge = repo.merge();
            merge.setCommit(true);
            merge.setFastForward(MergeCommand.FastForwardMode.FF);
            merge.setStrategy((MergeStrategy)MergeStrategy.RECURSIVE);
            if (!this.forceFiles.isEmpty()) {
                Path basePath = Paths.get(this.getRepository().getProjectPath().toString(), new String[0]);
                CheckoutCommand ccommand = repo.checkout();
                for (File f2 : this.forceFiles) {
                    ccommand.addPath(GitUtilities.getRelativeFileName(basePath, f2));
                }
                ccommand.call();
            }
            repo.getRepository().getListenerList().addWorkingTreeModifiedListener(e -> {
                for (String modified : e.getModified()) {
                    Platform.runLater(() -> {
                        File f = new File(this.getRepository().getProjectPath(), modified);
                        if (f.exists()) {
                            this.listener.fileModified(f);
                        } else {
                            this.listener.fileRemoved(f);
                        }
                    });
                }
                for (String deleted : e.getDeleted()) {
                    Platform.runLater(() -> this.listener.fileRemoved(new File(this.getRepository().getProjectPath(), deleted)));
                }
            });
            merge.include((AnyObjectId)repo.getRepository().resolve("origin/master"));
            MergeResult mergeResult = merge.call();
            switch (mergeResult.getMergeStatus()) {
                case FAST_FORWARD: {
                    break;
                }
                case CONFLICTING: {
                    Map allConflicts = mergeResult.getConflicts();
                    allConflicts.keySet().stream().map(path -> new File(gitPath, (String)path)).forEach(f -> this.conflicts.add((File)f));
                    break;
                }
                case FAILED: {
                    Map allConflicts = mergeResult.getConflicts();
                    if (allConflicts == null) {
                        String conflictMessage = DialogManager.getMessage("team-commit-needed", new String[0]);
                        TeamworkCommandError teamworkCommandError = new TeamworkCommandError(conflictMessage, conflictMessage);
                        return teamworkCommandError;
                    }
                    Debug.log("Git merge FAILED with conflicts list? conflicts = " + allConflicts);
                    allConflicts.keySet().stream().forEach(path -> this.conflicts.add(new File(gitPath, (String)path)));
                    break;
                }
                case MERGED: 
                case ALREADY_UP_TO_DATE: {
                    break;
                }
                default: {
                    Debug.reportError("Unknown/unhandled Git merge status: " + mergeResult.getMergeStatus());
                }
            }
            if (this.conflicts.isEmpty()) {
                if (this.binaryConflicts.isEmpty()) return new TeamworkCommandResult();
            }
            Platform.runLater(() -> this.listener.handleConflicts(this));
            return new TeamworkCommandResult();
        }
        catch (IOException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (CheckoutConflictException ex) {
            String conflictMessage = DialogManager.getMessage("team-commit-needed", new String[0]);
            return new TeamworkCommandError(conflictMessage, conflictMessage);
        }
        catch (GitAPIException ex) {
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean mergeCommitNeeded() {
        return true;
    }

    @Override
    @OnThread(value=Tag.Any)
    public List<File> getConflicts() {
        return this.conflicts;
    }

    @Override
    @OnThread(value=Tag.Any)
    public Set<File> getBinaryConflicts() {
        return this.binaryConflicts;
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void overrideFiles(Set<File> files) {
        if (!files.isEmpty()) {
            try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
                Path basePath = Paths.get(this.getRepository().getProjectPath().toString(), new String[0]);
                CheckoutCommand ccommand = repo.checkout();
                for (File f : files) {
                    ccommand.addPath(GitUtilities.getRelativeFileName(basePath, f));
                }
                ccommand.setStage(CheckoutCommand.Stage.THEIRS);
                ccommand.setForce(true);
                ccommand.call();
            }
            catch (IOException | GitAPIException exc) {
                Debug.reportError("Git override files failed", exc);
            }
        }
    }
}

