/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.StatusListener;
import bluej.groupwork.TeamStatusInfo;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitFetchCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitStatusHandle;
import bluej.groupwork.git.GitTreeException;
import bluej.groupwork.git.GitUtilities;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.revwalk.RevCommit;
import threadchecker.OnThread;
import threadchecker.Tag;

public class GitStatusCommand
extends GitCommand {
    StatusListener listener;
    FileFilter filter;
    boolean includeRemote;

    public GitStatusCommand(GitRepository repository, StatusListener listener, FileFilter filter, boolean includeRemote) {
        super(repository);
        this.listener = listener;
        this.filter = filter;
        this.includeRemote = includeRemote;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @OnThread(value=Tag.Worker)
    public TeamworkCommandResult getResult() {
        boolean didFilesChange = true;
        LinkedList<TeamStatusInfo> returnInfo = new LinkedList<TeamStatusInfo>();
        File gitPath = this.getRepository().getProjectPath();
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            GitFetchCommand fetchCommand;
            TeamworkCommandResult fetchResult;
            Status s = repo.status().call();
            s.getMissing().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).forEach(item -> {
                TeamStatusInfo teamInfo = new TeamStatusInfo(new File(gitPath, (String)item), "", null, TeamStatusInfo.Status.DELETED);
                returnInfo.add(teamInfo);
            });
            s.getRemoved().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).forEach(item -> returnInfo.add(new TeamStatusInfo(new File(gitPath, (String)item), "", null, TeamStatusInfo.Status.DELETED)));
            s.getUncommittedChanges().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).forEach(item -> {
                TeamStatusInfo teamInfo = new TeamStatusInfo(new File(gitPath, (String)item), "", null, TeamStatusInfo.Status.NEEDS_COMMIT);
                TeamStatusInfo existingStatusInfo = this.getTeamStatusInfo(returnInfo, teamInfo.getFile());
                if (existingStatusInfo == null) {
                    returnInfo.add(teamInfo);
                }
            });
            s.getUntracked().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).forEach(item -> returnInfo.add(new TeamStatusInfo(new File(gitPath, (String)item), "", null, TeamStatusInfo.Status.NEEDS_ADD)));
            s.getUntrackedFolders().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).forEach(item -> returnInfo.add(new TeamStatusInfo(new File(gitPath, (String)item), "", null, TeamStatusInfo.Status.NEEDS_ADD)));
            Map conflictsMap = s.getConflictingStageState();
            s.getConflicting().stream().filter(p -> this.filter.accept(new File(gitPath, (String)p))).forEach(item -> {
                TeamStatusInfo teamInfo = this.getTeamStatusInfo(returnInfo, new File(gitPath, (String)item));
                if (teamInfo == null) {
                    Debug.message("Git unexpected status: file is conflicting but not otherwise noted? (" + item + ")");
                    teamInfo = new TeamStatusInfo(new File(gitPath, (String)item), "", null, TeamStatusInfo.Status.NEEDS_MERGE);
                    returnInfo.add(teamInfo);
                } else {
                    IndexDiff.StageState sstate = (IndexDiff.StageState)conflictsMap.get(item);
                    switch (sstate) {
                        case DELETED_BY_THEM: {
                            teamInfo.setStatus(TeamStatusInfo.Status.CONFLICT_LMRD);
                            break;
                        }
                        case DELETED_BY_US: {
                            teamInfo.setStatus(TeamStatusInfo.Status.CONFLICT_LDRM);
                            break;
                        }
                        case BOTH_ADDED: {
                            teamInfo.setStatus(TeamStatusInfo.Status.CONFLICT_ADD);
                            break;
                        }
                        case BOTH_MODIFIED: {
                            teamInfo.setStatus(TeamStatusInfo.Status.NEEDS_MERGE);
                            break;
                        }
                        default: {
                            Debug.message("Git status, unknown/unhandled conflict state: " + sstate + " (" + item + ")");
                            teamInfo.setStatus(TeamStatusInfo.Status.NEEDS_MERGE);
                        }
                    }
                }
            });
            if (this.includeRemote && (fetchResult = (fetchCommand = new GitFetchCommand(this.getRepository())).getResult()).isError()) {
                TeamworkCommandResult teamworkCommandResult = fetchResult;
                return teamworkCommandResult;
            }
            RevCommit forkPoint = GitUtilities.findForkPoint(repo.getRepository(), "origin/master", "HEAD");
            List<DiffEntry> listOfDiffsLocal = GitUtilities.getDiffs(repo, "HEAD", forkPoint);
            List<DiffEntry> listOfDiffsRemote = GitUtilities.getDiffs(repo, "origin/master", forkPoint);
            this.updateRemoteStatus(gitPath, listOfDiffsLocal, listOfDiffsRemote, returnInfo);
            if (returnInfo.isEmpty()) {
                didFilesChange = false;
            }
            if (this.listener == null) return new TeamworkCommandResult();
            this.addUpToDateFiles(returnInfo, gitPath);
            while (!returnInfo.isEmpty()) {
                TeamStatusInfo teamInfo = returnInfo.removeFirst();
                this.listener.gotStatus(teamInfo);
            }
            this.listener.statusComplete(new GitStatusHandle(this.getRepository(), didFilesChange && GitUtilities.isAheadOnly(repo), didFilesChange && GitUtilities.getBehindCount(repo) > 0));
            return new TeamworkCommandResult();
        }
        catch (GitTreeException | IOException | GitAPIException | NoWorkTreeException ex) {
            Debug.reportError("Git status command exception", ex);
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }

    private void addUpToDateFiles(LinkedList<TeamStatusInfo> returnInfo, File path) {
        for (File item : path.listFiles()) {
            if (!this.filter.accept(item)) continue;
            if (item.isDirectory()) {
                this.addUpToDateFiles(returnInfo, item);
                continue;
            }
            TeamStatusInfo itemStatus = this.getTeamStatusInfo(returnInfo, item);
            if (itemStatus != null) continue;
            returnInfo.add(new TeamStatusInfo(item, "", null, TeamStatusInfo.Status.UP_TO_DATE, TeamStatusInfo.Status.UP_TO_DATE));
        }
    }

    private TeamStatusInfo getTeamStatusInfo(LinkedList<TeamStatusInfo> returnInfo, File file) {
        try {
            return returnInfo.stream().filter(entry -> entry.getFile().getPath().contains(file.getPath())).findFirst().get();
        }
        catch (Exception e) {
            return null;
        }
    }

    private Optional<DiffEntry> getDiffFromList(List<DiffEntry> list, DiffEntry entry) {
        String entryFileName = GitUtilities.getFileNameFromDiff(entry);
        Optional<DiffEntry> result = list.stream().filter(p -> GitUtilities.getFileNameFromDiff(p).equals(entryFileName)).findFirst();
        return result;
    }

    private void updateRemoteStatus(LinkedList<TeamStatusInfo> returnInfo, File file, TeamStatusInfo.Status remoteStatus) {
        TeamStatusInfo entry = this.getTeamStatusInfo(returnInfo, file);
        if (entry != null) {
            entry.setRemoteStatus(remoteStatus);
        } else {
            entry = new TeamStatusInfo(file, "", null, TeamStatusInfo.Status.UP_TO_DATE, remoteStatus);
            returnInfo.add(entry);
        }
    }

    private void updateRemoteStatus(File gitPath, List<DiffEntry> listOfDiffsLocal, List<DiffEntry> listOfDiffsRemote, LinkedList<TeamStatusInfo> returnInfo) {
        for (DiffEntry localDiffItem : listOfDiffsLocal) {
            File file = new File(gitPath, GitUtilities.getFileNameFromDiff(localDiffItem));
            switch (localDiffItem.getChangeType()) {
                case MODIFY: {
                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_COMMIT);
                    break;
                }
                case DELETE: {
                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.DELETED);
                    break;
                }
                case ADD: {
                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_ADD);
                }
            }
        }
        for (DiffEntry remoteDiffItem : listOfDiffsRemote) {
            Optional<DiffEntry> localDiffItem = this.getDiffFromList(listOfDiffsLocal, remoteDiffItem);
            File file = new File(gitPath, GitUtilities.getFileNameFromDiff(remoteDiffItem));
            block5 : switch (remoteDiffItem.getChangeType()) {
                case MODIFY: {
                    if (localDiffItem.isPresent()) {
                        TeamStatusInfo entry = this.getTeamStatusInfo(returnInfo, file);
                        switch (localDiffItem.get().getChangeType()) {
                            case MODIFY: {
                                if (entry == null) {
                                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_PUSH);
                                    break block5;
                                }
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_MERGE);
                                break block5;
                            }
                            case DELETE: {
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.CONFLICT_LDRM);
                                break block5;
                            }
                            case ADD: {
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.CONFLICT_ADD);
                            }
                        }
                        break;
                    }
                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_UPDATE);
                    break;
                }
                case DELETE: {
                    if (localDiffItem.isPresent()) {
                        switch (localDiffItem.get().getChangeType()) {
                            case MODIFY: {
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.CONFLICT_LMRD);
                                break block5;
                            }
                            case DELETE: {
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.DELETED);
                                break block5;
                            }
                            case ADD: {
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_COMMIT);
                            }
                        }
                        break;
                    }
                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.REMOVED);
                    break;
                }
                case ADD: {
                    if (localDiffItem.isPresent()) {
                        switch (localDiffItem.get().getChangeType()) {
                            case ADD: {
                                this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.CONFLICT_ADD);
                            }
                        }
                        break;
                    }
                    this.updateRemoteStatus(returnInfo, file, TeamStatusInfo.Status.NEEDS_CHECKOUT);
                    if (file.exists()) break;
                    TeamStatusInfo tsi = this.getTeamStatusInfo(returnInfo, file);
                    tsi.setStatus(TeamStatusInfo.Status.NEEDS_CHECKOUT);
                }
            }
        }
    }
}

