/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitRepository;
import bluej.groupwork.git.GitUtilities;
import bluej.utility.Debug;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.UnmergedPathException;

public class GitCommitAllCommand
extends GitCommand {
    protected Set<File> newFiles;
    protected Set<File> deletedFiles;
    protected Set<File> files;
    protected String commitComment;

    public GitCommitAllCommand(GitRepository repository, Set<File> newFiles, Set<File> deletedFiles, Set<File> files, String commitComment) {
        super(repository);
        this.newFiles = newFiles;
        this.deletedFiles = deletedFiles;
        this.files = files;
        this.commitComment = commitComment;
    }

    @Override
    public TeamworkCommandResult getResult() {
        try (Git repo = Git.open((File)this.getRepository().getProjectPath());){
            String fileName;
            CommitCommand commit = repo.commit();
            Path basePath = Paths.get(this.getRepository().getProjectPath().toString(), new String[0]);
            for (File f : this.newFiles) {
                fileName = GitUtilities.getRelativeFileName(basePath, f);
                if (fileName.isEmpty() || f.isDirectory()) continue;
                repo.add().addFilepattern(fileName).call();
            }
            for (File f : this.deletedFiles) {
                fileName = GitUtilities.getRelativeFileName(basePath, f);
                if (fileName.isEmpty()) continue;
                repo.rm().addFilepattern(fileName).call();
            }
            commit.setAll(false);
            for (File f : this.files) {
                fileName = GitUtilities.getRelativeFileName(basePath, f);
                if (fileName.isEmpty() || f.isDirectory() || this.deletedFiles.contains(f)) continue;
                repo.add().addFilepattern(fileName).call();
            }
            commit.setMessage(this.commitComment);
            commit.setAuthor(this.getRepository().getYourName(), this.getRepository().getYourEmail());
            commit.call();
        }
        catch (GitAPIException | UnmergedPathException ex) {
            Debug.reportError(ex.getMessage());
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            Debug.reportError(ex.getMessage());
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
        return new TeamworkCommandResult();
    }
}

