/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.git;

import bluej.groupwork.TeamworkCommandAborted;
import bluej.groupwork.TeamworkCommandError;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.git.GitCommand;
import bluej.groupwork.git.GitProvider;
import bluej.groupwork.git.GitRepository;
import bluej.utility.DialogManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.lib.StoredConfig;

public class GitCloneCommand
extends GitCommand {
    private File clonePath;

    public GitCloneCommand(GitRepository repository, File projectPath) {
        super(repository);
        this.clonePath = projectPath;
    }

    @Override
    public TeamworkCommandResult getResult() {
        String reposUrl = "";
        try {
            reposUrl = this.getRepository().getReposUrl();
            CloneCommand cloneCommand = Git.cloneRepository();
            this.disableFingerprintCheck((TransportCommand)cloneCommand);
            cloneCommand.setDirectory(this.clonePath);
            cloneCommand.setURI(reposUrl);
            StoredConfig repoConfig = cloneCommand.call().getRepository().getConfig();
            repoConfig.setString("user", null, "name", this.getRepository().getYourName());
            repoConfig.setString("user", null, "email", this.getRepository().getYourEmail());
            repoConfig.save();
            if (!this.isCancelled()) {
                return new TeamworkCommandResult();
            }
            return new TeamworkCommandAborted();
        }
        catch (IOException | GitAPIException ex) {
            if (ex.getCause() instanceof NoRemoteRepositoryException) {
                String message = DialogManager.getMessage("team-noRepository-uri", ex.getLocalizedMessage());
                return new TeamworkCommandError(message, message);
            }
            if (ex instanceof InvalidRemoteException) {
                return new TeamworkCommandError(DialogManager.getMessage("team-cant-connect", new String[0]), DialogManager.getMessage("team-cant-connect", new String[0]));
            }
            if (ex.getCause() instanceof TransportException) {
                if (ex.getLocalizedMessage().contains("Auth fail")) {
                    return new TeamworkCommandError(DialogManager.getMessage("team-denied-invalidUser", new String[0]), DialogManager.getMessage("team-denied-invalidUser", new String[0]));
                }
                TeamworkCommandResult diagnosis = GitProvider.connectionDiagnosis(reposUrl);
                if (diagnosis.isError()) {
                    return diagnosis;
                }
            }
            return new TeamworkCommandError(ex.getMessage(), ex.getLocalizedMessage());
        }
    }
}

