/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.actions;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.groupwork.StatusHandle;
import bluej.groupwork.TeamUtils;
import bluej.groupwork.TeamworkCommand;
import bluej.groupwork.TeamworkCommandResult;
import bluej.groupwork.actions.TeamAction;
import bluej.groupwork.ui.CommitAndPushFrame;
import bluej.pkgmgr.Project;
import bluej.utility.FXWorker;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class PushAction
extends TeamAction {
    private CommitAndPushFrame commitCommentsFrame;
    private Set<File> filesToPush;
    private PushWorker worker;
    private @OnThread(value=Tag.Any, requireSynchronized=true) StatusHandle statusHandle;

    public PushAction(CommitAndPushFrame frame) {
        super(Config.getString("team.push"), false);
        this.commitCommentsFrame = frame;
        this.filesToPush = new HashSet<File>();
    }

    public void cancel() {
        this.setEnabled(true);
        if (this.worker != null) {
            this.worker.abort();
            this.worker = null;
        }
    }

    @OnThread(value=Tag.Worker)
    public synchronized void setStatusHandle(StatusHandle statusHandle) {
        this.statusHandle = statusHandle;
    }

    @Override
    protected void actionPerformed(Project project) {
        this.commitCommentsFrame.startProgress();
        this.commitCommentsFrame.displayMessage(Config.getString("team.push.statusMessage"));
        this.setEnabled(false);
        this.filesToPush.clear();
        this.filesToPush.addAll(this.commitCommentsFrame.getFilesToPush());
        this.worker = new PushWorker(project);
        this.worker.start();
    }

    private class PushWorker
    extends FXWorker {
        private TeamworkCommand command;
        private TeamworkCommandResult result = null;
        private final boolean hasPassword;
        private boolean aborted;

        @OnThread(value=Tag.FXPlatform)
        public PushWorker(Project project) {
            this.command = PushAction.this.statusHandle.pushAll(PushAction.this.filesToPush);
            if (!project.getTeamSettingsController().hasPasswordString()) {
                if (!project.getTeamSettingsDialog().showAndWait().isPresent()) {
                    PushAction.this.commitCommentsFrame.setVisible(true);
                    this.hasPassword = false;
                    return;
                }
                PushAction.this.statusHandle.getRepository().setPassword(PushAction.this.commitCommentsFrame.getProject().getTeamSettingsController().getTeamSettingsDialog().getSettings());
            }
            this.hasPassword = true;
        }

        @Override
        @OnThread(value=Tag.Worker)
        public Object construct() {
            if (!this.hasPassword) {
                Platform.runLater(this::abort);
                return null;
            }
            this.result = this.command.getResult();
            return this.result;
        }

        @Override
        public void abort() {
            this.command.cancel();
            this.aborted = true;
        }

        @Override
        public void finished() {
            Project project = PushAction.this.commitCommentsFrame.getProject();
            if (!this.aborted) {
                PushAction.this.commitCommentsFrame.stopProgress();
                if (!this.result.isError()) {
                    if (!this.result.wasAborted()) {
                        DataCollector.teamPushProject(project, PushAction.this.statusHandle.getRepository(), PushAction.this.filesToPush);
                        PushAction.this.commitCommentsFrame.displayMessage(Config.getString("team.push.statusDone"));
                    }
                } else {
                    PushAction.this.commitCommentsFrame.displayMessage(Config.getString("team.push.error"));
                }
            }
            TeamUtils.handleServerResponseFX(this.result, PushAction.this.commitCommentsFrame.asWindow());
            if (!this.aborted) {
                PushAction.this.setEnabled(true);
                if (project.getTeamSettingsController().isDVCS()) {
                    PushAction.this.commitCommentsFrame.setVisible(true);
                } else {
                    PushAction.this.commitCommentsFrame.setVisible(false);
                }
            }
        }
    }
}

