/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.groupwork.TeamStatusInfo;

public class UpdateFilter {
    public boolean accept(TeamStatusInfo statusInfo) {
        boolean isDir = statusInfo.getFile().isDirectory();
        TeamStatusInfo.Status stat = statusInfo.getStatus();
        TeamStatusInfo.Status remoteStat = statusInfo.getRemoteStatus();
        if (stat == TeamStatusInfo.Status.NEEDS_CHECKOUT || remoteStat == TeamStatusInfo.Status.NEEDS_CHECKOUT) {
            return true;
        }
        if (stat == TeamStatusInfo.Status.NEEDS_MERGE || remoteStat == TeamStatusInfo.Status.NEEDS_MERGE) {
            return !isDir;
        }
        if (stat == TeamStatusInfo.Status.NEEDS_UPDATE || remoteStat == TeamStatusInfo.Status.NEEDS_UPDATE) {
            return !isDir;
        }
        if (stat == TeamStatusInfo.Status.REMOVED || remoteStat == TeamStatusInfo.Status.REMOVED) {
            return true;
        }
        if (stat == TeamStatusInfo.Status.CONFLICT_LDRM || remoteStat == TeamStatusInfo.Status.CONFLICT_LDRM) {
            return true;
        }
        if (stat == TeamStatusInfo.Status.CONFLICT_LMRD || remoteStat == TeamStatusInfo.Status.CONFLICT_LMRD) {
            return true;
        }
        return remoteStat == TeamStatusInfo.Status.NEEDS_UPDATE;
    }

    public boolean acceptDist(TeamStatusInfo.Status remoteStatus) {
        switch (remoteStatus) {
            case CONFLICT_ADD: 
            case CONFLICT_LDRM: 
            case CONFLICT_LMRD: 
            case NEEDS_CHECKOUT: 
            case NEEDS_UPDATE: 
            case NEEDS_MERGE: 
            case REMOVED: {
                return true;
            }
        }
        return false;
    }

    public boolean updateAlways(TeamStatusInfo statusInfo) {
        TeamStatusInfo.Status remoteStatus = statusInfo.getRemoteStatus();
        if (statusInfo.getStatus() == TeamStatusInfo.Status.NEEDS_CHECKOUT || remoteStatus == TeamStatusInfo.Status.NEEDS_CHECKOUT) {
            return true;
        }
        if (statusInfo.getStatus() == TeamStatusInfo.Status.REMOVED || remoteStatus == TeamStatusInfo.Status.REMOVED) {
            return true;
        }
        return statusInfo.getStatus() == TeamStatusInfo.Status.CONFLICT_LMRD || remoteStatus == TeamStatusInfo.Status.CONFLICT_LMRD;
    }
}

