/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.groupwork.TeamworkCommandResult;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class TeamUtils {
    @OnThread(value=Tag.FXPlatform)
    public static void handleServerResponseFX(TeamworkCommandResult result, Window window) {
        if (result != null) {
            if (result.wasAuthFailure()) {
                DialogManager.showErrorFX(window, "team-authentication-problem");
            } else if (result.isError() && !result.wasAborted()) {
                DialogManager.showErrorTextFX(window, result.getErrorMessage());
            }
        }
    }

    public static Set<File> extractBinaryFilesFromSet(Set<File> files) {
        HashSet<File> binFiles = new HashSet<File>();
        Iterator<File> i = files.iterator();
        while (i.hasNext()) {
            String fname;
            File f = i.next();
            if (f.isDirectory() || (fname = f.getName()).endsWith(".txt") || fname.endsWith(".java")) continue;
            binFiles.add(f);
            i.remove();
        }
        return binFiles;
    }

    public static Map<File, File> backupFiles(Set<File> files) throws IOException {
        HashMap<File, File> rmap = new HashMap<File, File>();
        Iterator<File> i = files.iterator();
        while (i.hasNext()) {
            File tempFile = File.createTempFile("bluejvcs", null);
            File srcFile = i.next();
            FileUtility.copyFile(srcFile, tempFile);
            rmap.put(srcFile, tempFile);
        }
        return rmap;
    }

    public static void restoreBackups(Map<File, File> rmap) throws IOException {
        for (Map.Entry<File, File> entry : rmap.entrySet()) {
            File orig = entry.getKey();
            File backup = entry.getValue();
            FileUtility.copyFile(backup, orig);
            backup.delete();
        }
    }
}

