/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork;

import bluej.Config;
import bluej.groupwork.CodeFileFilter;
import bluej.groupwork.Repository;
import bluej.groupwork.TeamSettings;
import bluej.groupwork.TeamworkProvider;
import bluej.groupwork.UnsupportedSettingException;
import bluej.groupwork.ui.TeamSettingsDialog;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class TeamSettingsController {
    private static final @OnThread(value=Tag.Any) ArrayList<TeamworkProvider> teamProviders = new ArrayList(2);
    private Project project;
    private File projectDir;
    private Properties teamProperties;
    private TeamSettingsDialog teamSettingsDialog;
    private TeamSettings settings;
    private String password;
    private File teamdefs;
    private Repository repository;

    private static TeamworkProvider loadProvider(String name) throws Throwable {
        Class<?> c = Class.forName(name);
        Object instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        return (TeamworkProvider)instance;
    }

    public TeamSettingsController(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.teamProperties = new Properties();
        this.readSetupFile();
    }

    public TeamSettingsController(File projectDir) {
        this.projectDir = projectDir;
        this.teamProperties = new Properties();
    }

    public void setProject(Project proj) {
        this.project = proj;
        this.projectDir = proj.getProjectDir();
        this.repository = null;
        this.disableRepositorySettings();
    }

    public List<TeamworkProvider> getTeamworkProviders() {
        return teamProviders;
    }

    public TeamworkProvider getTeamworkProvider(ServerType type) {
        return teamProviders.stream().filter(teamworkProvider -> teamworkProvider.getProviderName().equals(type.name())).findAny().get();
    }

    public Repository trytoEstablishRepository(boolean authRequired) {
        block13: {
            if (authRequired && this.password == null) {
                if (!this.getTeamSettingsDialog().showAndWait().isPresent()) {
                    return null;
                }
                TeamSettings settings = this.teamSettingsDialog.getSettings();
                if (this.repository == null) {
                    try {
                        this.repository = settings.getProvider().getRepository(this.projectDir, settings);
                    }
                    catch (UnsupportedSettingException e) {
                        DialogManager.showErrorTextFX(this.teamSettingsDialog.asWindow(), e.getLocalizedMessage());
                    }
                } else {
                    this.repository.setPassword(settings);
                }
            } else {
                if (!authRequired && this.password == null) {
                    try {
                        return this.settings.getProvider().getRepository(this.projectDir, this.settings);
                    }
                    catch (UnsupportedSettingException e) {
                        DialogManager.showErrorTextFX(this.teamSettingsDialog.asWindow(), e.getLocalizedMessage());
                        break block13;
                    }
                }
                if (this.repository == null) {
                    try {
                        this.repository = this.settings.getProvider().getRepository(this.projectDir, this.settings);
                    }
                    catch (UnsupportedSettingException e) {
                        DialogManager.showErrorTextFX(this.teamSettingsDialog.asWindow(), e.getLocalizedMessage());
                    }
                }
            }
        }
        return this.repository;
    }

    public boolean initRepository() {
        return this.initRepository(true);
    }

    private boolean initRepository(boolean auth) {
        return this.trytoEstablishRepository(auth) != null;
    }

    public Set<File> getProjectFiles(boolean includeLayout) {
        this.initRepository();
        boolean versionsDirs = false;
        if (this.repository != null) {
            versionsDirs = this.repository.versionsDirectories();
        }
        Set<File> files = this.project.getFilesInProject(includeLayout, versionsDirs);
        if (this.repository != null) {
            this.repository.getAllLocallyDeletedFiles(files);
        }
        return files;
    }

    public FileFilter getFileFilter(boolean includeLayout, boolean includeDirectories) {
        this.initRepository(false);
        FileFilter repositoryFilter = null;
        if (this.repository != null) {
            repositoryFilter = this.repository.getMetadataFilter();
        }
        return new CodeFileFilter(this.getIgnoreFiles(), includeLayout, includeDirectories, this.projectDir, repositoryFilter);
    }

    private void readSetupFile() {
        this.teamdefs = new File(this.projectDir, "team.defs");
        try {
            this.teamProperties.load(new FileInputStream(this.teamdefs));
            this.initSettings();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnThread(value=Tag.Any)
    public static boolean isValidVCSfound(File projDir) {
        File teamDefs = new File(projDir, "team.defs");
        Properties p = new Properties();
        String providerName = null;
        try {
            p.load(new FileInputStream(teamDefs));
            providerName = p.getProperty("bluej.teamsettings.vcs");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (providerName != null) {
            for (int index = 0; index < teamProviders.size(); ++index) {
                TeamworkProvider prov = teamProviders.get(index);
                if (!prov.getProviderName().equalsIgnoreCase(providerName)) continue;
                return true;
            }
        }
        return false;
    }

    private void initSettings() {
        String group;
        String yourEmail;
        String yourName;
        String user = this.getPropString("bluej.teamsettings.user");
        if (user == null) {
            user = "";
        }
        if ((yourName = this.getPropString("bluej.teamsettings.yourName")) == null) {
            yourName = "";
        }
        if ((yourEmail = this.getPropString("bluej.teamsettings.yourEmail")) == null) {
            yourEmail = "";
        }
        if ((group = this.getPropString("bluej.teamsettings.groupname")) == null) {
            group = "";
        }
        TeamworkProvider provider = null;
        String providerName = this.getPropString("bluej.teamsettings.vcs");
        if (providerName != null) {
            for (int index = 0; index < teamProviders.size(); ++index) {
                TeamworkProvider prov = teamProviders.get(index);
                if (!prov.getProviderName().equalsIgnoreCase(providerName)) continue;
                provider = prov;
            }
        }
        if (provider != null) {
            this.settings = this.initProviderSettings(user, group, this.password, provider);
            this.settings.setYourName(yourName);
            this.settings.setYourEmail(yourEmail);
        }
    }

    public TeamSettings initProviderSettings(String user, String group, String password, TeamworkProvider provider) {
        String keyBase = "bluej.teamsettings." + provider.getProviderName().toLowerCase() + ".";
        String prefix = this.getPropString(keyBase + "repositoryPrefix");
        String server = this.getPropString(keyBase + "server");
        String protocol = this.getPropString(keyBase + "protocol");
        return new TeamSettings(provider, protocol, server, prefix, group, user, password);
    }

    public boolean prepareDeleteDir(File dir) {
        Repository repository = this.trytoEstablishRepository(false);
        if (repository == null) {
            return false;
        }
        return repository.prepareDeleteDir(dir);
    }

    public void prepareCreateDir(File dir) {
        Repository repository = this.trytoEstablishRepository(false);
        if (repository != null) {
            repository.prepareCreateDir(dir);
        }
    }

    public TeamSettingsDialog getTeamSettingsDialog() {
        if (this.teamSettingsDialog == null) {
            this.teamSettingsDialog = new TeamSettingsDialog((Window)PkgMgrFrame.getMostRecent().getFXWindow(), this);
            this.disableRepositorySettings();
        }
        return this.teamSettingsDialog;
    }

    private void disableRepositorySettings() {
        if (this.teamSettingsDialog != null && this.project != null) {
            this.teamSettingsDialog.disableRepositorySettings();
        }
    }

    public void writeToProject() {
        if (this.projectDir == null) {
            return;
        }
        File cfgFile = new File(this.projectDir + "/team.defs");
        if (!cfgFile.exists()) {
            this.addIgnoreFilePatterns(this.teamProperties);
        }
        try {
            this.teamProperties.store(new FileOutputStream(cfgFile), null);
            this.repository = null;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addIgnoreFilePatterns(Properties teamProperties) {
        teamProperties.put("bluej.teamsettings.ignore1", ".*\\.class");
        teamProperties.put("bluej.teamsettings.ignore2", "bluej\\.pkh");
        teamProperties.put("bluej.teamsettings.ignore3", "team\\.defs");
        teamProperties.put("bluej.teamsettings.ignore4", ".*\\.ctxt");
        teamProperties.put("bluej.teamsettings.ignore5", ".*\\~");
        teamProperties.put("bluej.teamsettings.ignore6", ".*\\#");
        teamProperties.put("bluej.teamsettings.ignore7", ".*\\#backup");
        teamProperties.put("bluej.teamsettings.ignore8", "\\.DS_Store");
    }

    public String getPropString(String strname) {
        String result = this.teamProperties.getProperty(strname);
        if (result != null) {
            return result;
        }
        result = Config.getPropString(strname, null);
        return result;
    }

    public void setPropString(String key, String value) {
        if (key != null && value != null) {
            this.teamProperties.setProperty(key, value);
        }
    }

    public void updateSettings(TeamSettings newSettings, boolean useAsDefault) {
        this.settings = newSettings;
        String userKey = "bluej.teamsettings.user";
        String userValue = this.settings.getUserName();
        this.setPropString(userKey, userValue);
        String yourNameKey = "bluej.teamsettings.yourName";
        String yourNameValue = "";
        if (this.teamSettingsDialog.getSettings().getProvider().needsName()) {
            yourNameValue = this.settings.getYourName();
            this.setPropString(yourNameKey, yourNameValue);
        }
        String yourEmailKey = "bluej.teamsettings.yourEmail";
        String yourEmailValue = "";
        if (this.teamSettingsDialog.getSettings().getProvider().needsEmail()) {
            yourEmailValue = this.settings.getYourEmail();
            this.setPropString(yourEmailKey, yourEmailValue);
        }
        String providerKey = "bluej.teamsettings.vcs";
        String providerName = newSettings.getProvider().getProviderName().toLowerCase();
        this.setPropString(providerKey, providerName);
        String keyBase = "bluej.teamsettings." + providerName + ".";
        String serverKey = keyBase + "server";
        String serverValue = this.settings.getServer();
        if (serverValue != null) {
            this.setPropString(serverKey, serverValue);
        }
        String prefixKey = keyBase + "repositoryPrefix";
        String prefixValue = this.settings.getPrefix();
        this.setPropString(prefixKey, prefixValue);
        String protocolKey = keyBase + "protocol";
        String protocolValue = this.settings.getProtocol();
        this.setPropString(protocolKey, protocolValue);
        String groupKey = "bluej.teamsettings.groupname";
        String groupValue = this.settings.getGroup();
        this.setPropString(groupKey, groupValue);
        String useAsDefaultKey = "bluej.teamsettings.useAsDefault";
        Config.putPropString(useAsDefaultKey, Boolean.toString(useAsDefault));
        String passValue = this.settings.getPassword();
        this.setPasswordString(passValue);
        if (this.repository != null) {
            TeamSettings settings = this.getTeamSettingsDialog().getSettings();
            this.repository.setPassword(settings);
        }
        if (useAsDefault) {
            Config.putPropString(providerKey, providerName);
            Config.putPropString(userKey, userValue);
            if (this.teamSettingsDialog.getSettings().getProvider().needsName()) {
                Config.putPropString(yourNameKey, yourNameValue);
            }
            if (this.teamSettingsDialog.getSettings().getProvider().needsEmail()) {
                Config.putPropString(yourEmailKey, yourEmailValue);
            } else {
                Config.putPropString(serverKey, serverValue);
                Config.putPropString(prefixKey, prefixValue);
                Config.putPropString(groupKey, groupValue);
                Config.putPropString(protocolKey, protocolValue);
            }
        }
    }

    public String getPasswordString() {
        return this.password;
    }

    private void setPasswordString(String password) {
        this.password = password;
    }

    public boolean hasPasswordString() {
        return this.password != null;
    }

    public List<String> getIgnoreFiles() {
        Iterator<Object> keys = this.teamProperties.keySet().iterator();
        LinkedList<String> patterns = new LinkedList<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.startsWith("bluej.teamsettings.cvs.ignore")) {
                patterns.add(this.teamProperties.getProperty(key));
            }
            if (!key.startsWith("bluej.teamsettings.ignore")) continue;
            patterns.add(this.teamProperties.getProperty(key));
        }
        return patterns;
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public Project getProject() {
        return this.project;
    }

    public double getWorkingCopyVersion() {
        return this.settings.getProvider().getWorkingCopyVersion(this.projectDir);
    }

    public boolean isDVCS() {
        TeamworkProvider provider;
        if (this.settings != null && (provider = this.settings.getProvider()) != null) {
            return provider.isDVCS();
        }
        return false;
    }

    static {
        try {
            teamProviders.add(TeamSettingsController.loadProvider("bluej.groupwork.svn.SubversionProvider"));
        }
        catch (Throwable e) {
            Debug.message("Failed to initialize Subversion: " + e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
        try {
            teamProviders.add(TeamSettingsController.loadProvider("bluej.groupwork.git.GitProvider"));
        }
        catch (Throwable e) {
            Debug.message("Failed to initialize Git: " + e.getClass().getName() + ": " + e.getLocalizedMessage());
        }
    }

    public static enum ServerType {
        Subversion,
        Git;

    }
}

