/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.BlueJEvent;
import bluej.debugger.DebuggerObject;
import bluej.debugger.ExceptionDescription;
import bluej.debugmgr.ExecutionEvent;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.ResultWatcher;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.views.CallableView;
import bluej.views.MethodView;
import javafx.stage.Stage;
import javafx.stage.Window;

public abstract class ResultWatcherBase
implements ResultWatcher {
    private final CallableView method;
    private DebuggerObject obj;
    private String objInstanceName;
    private Package pkg;
    private Stage parentWindow;
    private String className;

    public ResultWatcherBase(Package pkg, Stage parentWindow, CallableView method) {
        this.method = method;
        this.className = method.getClassName();
        this.pkg = pkg;
        this.parentWindow = parentWindow;
    }

    public ResultWatcherBase(DebuggerObject obj, String objInstanceName, Package pkg, Stage parentWindow, CallableView method) {
        this.method = method;
        this.obj = obj;
        this.objInstanceName = objInstanceName;
        this.pkg = pkg;
        this.parentWindow = parentWindow;
        this.className = obj.getClassName();
    }

    @Override
    public void beginCompile() {
    }

    @Override
    public void beginExecution(InvokerRecord ir) {
    }

    @Override
    public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
        ExecutionEvent executionEvent = new ExecutionEvent(this.pkg, this.className, this.objInstanceName);
        if (this.method instanceof MethodView) {
            MethodView mv = (MethodView)this.method;
            executionEvent.setMethodName(mv.getName());
        }
        executionEvent.setParameters(this.method.getParamTypes(false), ir.getArgumentValues());
        executionEvent.setResult("Normal exit");
        executionEvent.setResultObject(result);
        BlueJEvent.raiseEvent(5, executionEvent);
        this.pkg.getProject().updateInspectors();
        this.addInteraction(ir);
        if (result != null && !result.isNullObject()) {
            this.nonNullResult(result, name, ir);
        }
    }

    protected void nonNullResult(DebuggerObject result, String name, InvokerRecord ir) {
        if (this.method instanceof MethodView) {
            MethodView mv = (MethodView)this.method;
            ExpressionInformation expressionInformation = this.obj != null ? new ExpressionInformation(mv, this.objInstanceName, this.obj.getGenType()) : new ExpressionInformation(mv, this.objInstanceName);
            expressionInformation.setArgumentValues(ir.getArgumentValues());
            this.pkg.getProject().getResultInspectorInstance(result, name, this.pkg, ir, expressionInformation, (Window)this.parentWindow);
        }
    }

    protected abstract void addInteraction(InvokerRecord var1);

    @Override
    public void putError(String msg, InvokerRecord ir) {
    }

    @Override
    public void putException(ExceptionDescription exception, InvokerRecord ir) {
        ExecutionEvent executionEvent = new ExecutionEvent(this.pkg, this.className, this.objInstanceName);
        executionEvent.setParameters(this.method.getParamTypes(false), ir.getArgumentValues());
        executionEvent.setResult("An exception occurred");
        executionEvent.setException(exception);
        BlueJEvent.raiseEvent(5, executionEvent);
        this.pkg.getProject().updateInspectors();
        this.pkg.exceptionMessage(exception);
    }

    @Override
    public void putVMTerminated(InvokerRecord ir) {
        ExecutionEvent executionEvent = new ExecutionEvent(this.pkg, this.className, this.objInstanceName);
        executionEvent.setParameters(this.method.getParamTypes(false), ir.getArgumentValues());
        executionEvent.setResult("User terminated");
        BlueJEvent.raiseEvent(5, executionEvent);
    }
}

