/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.collect.DataCollector;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.debugger.VarDisplayInfo;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.runtime.BJInputStream;
import bluej.utility.JavaNames;
import bluej.utility.javafx.FXAbstractAction;
import bluej.utility.javafx.JavaFXUtil;
import com.sun.jdi.VMDisconnectedException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.css.Styleable;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

public class ExecControls {
    private static final String stackTitle = Config.getString("debugger.execControls.stackTitle");
    private static final String staticTitle = Config.getString("debugger.execControls.staticTitle");
    private static final String instanceTitle = Config.getString("debugger.execControls.instanceTitle");
    private static final String localTitle = Config.getString("debugger.execControls.localTitle");
    private static final String threadTitle = Config.getString("debugger.execControls.threadTitle");
    private static final String haltButtonText = Config.getString("debugger.execControls.haltButtonText");
    private static final String stepButtonText = Config.getString("debugger.execControls.stepButtonText");
    private static final String stepIntoButtonText = Config.getString("debugger.execControls.stepIntoButtonText");
    private static final String continueButtonText = Config.getString("debugger.execControls.continueButtonText");
    private static final String terminateButtonText = Config.getString("debugger.execControls.terminateButtonText");
    private @OnThread(value=Tag.FX) Stage window;
    private @OnThread(value=Tag.FXPlatform) BorderPane fxContent;
    private ComboBox<Project.DebuggerThreadDetails> threadList;
    private ListView<SourceLocation> stackList;
    private ListView<VarDisplayInfo> staticList;
    private ListView<VarDisplayInfo> localList;
    private ListView<VarDisplayInfo> instanceList;
    private Button stopButton;
    private Button stepButton;
    private Button stepIntoButton;
    private Button continueButton;
    private Button terminateButton;
    private final Project project;
    private boolean autoSelectionEvent = false;
    private Map<String, Set<String>> restrictedClasses = Collections.emptyMap();
    private final SimpleBooleanProperty showingProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty hideSystemThreads = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty cannotStepOrContinue = new SimpleBooleanProperty(true);
    private final SimpleBooleanProperty cannotHalt = new SimpleBooleanProperty(true);
    private Project.DebuggerThreadDetails selectedThread;

    public ExecControls(Project project, Debugger debugger, ObservableList<Project.DebuggerThreadDetails> debuggerThreads) {
        BorderPane lhsPane;
        if (project == null || debugger == null) {
            throw new NullPointerException("project or debugger null in ExecControls");
        }
        this.project = project;
        this.window = new Stage();
        this.window.setTitle(Config.getApplicationName() + ":  " + Config.getString("debugger.execControls.windowTitle"));
        BlueJTheme.setWindowIconFX(this.window);
        this.createWindowContent(debuggerThreads);
        TilePane buttons = new TilePane(Orientation.HORIZONTAL, new Node[]{this.stopButton, this.stepButton, this.stepIntoButton, this.continueButton, this.terminateButton});
        buttons.setPrefColumns(buttons.getChildren().size());
        JavaFXUtil.addStyleClass((Styleable)buttons, "debugger-buttons");
        this.fxContent = new BorderPane();
        BorderPane vars = new BorderPane();
        vars.setTop(ExecControls.labelled(this.staticList, staticTitle));
        SplitPane varSplit = new SplitPane(new Node[]{ExecControls.labelled(this.instanceList, instanceTitle), ExecControls.labelled(this.localList, localTitle)});
        varSplit.setOrientation(Orientation.VERTICAL);
        vars.setCenter((Node)varSplit);
        if (debuggerThreads != null) {
            lhsPane = new BorderPane(ExecControls.labelled(this.stackList, stackTitle), ExecControls.labelled(this.threadList, threadTitle), null, null, null);
            JavaFXUtil.addStyleClass(this.threadList, new String[]{"debugger-thread-combo"});
        } else {
            lhsPane = new BorderPane(ExecControls.labelled(this.stackList, stackTitle), null, null, null, null);
        }
        JavaFXUtil.addStyleClass((Styleable)lhsPane, "debugger-thread-and-stack");
        this.fxContent.setTop((Node)this.makeMenuBar());
        this.fxContent.setCenter((Node)new SplitPane(new Node[]{lhsPane, vars}));
        this.fxContent.setBottom((Node)buttons);
        JavaFXUtil.addStyleClass((Styleable)this.fxContent, "debugger");
        Scene scene = new Scene((Parent)this.fxContent);
        Config.addDebuggerStylesheets(scene);
        this.window.setScene(scene);
        Config.loadAndTrackPositionAndSize((Window)this.window, "bluej.debugger");
        this.window.setOnShown(e -> {
            DataCollector.debuggerChangeVisible(project, true);
            this.showingProperty.set(true);
        });
        this.window.setOnHidden(e -> {
            DataCollector.debuggerChangeVisible(project, false);
            this.showingProperty.set(false);
        });
        JavaFXUtil.addChangeListenerPlatform(this.showingProperty, show -> {
            if (show.booleanValue() && !this.window.isShowing()) {
                this.window.show();
            } else if (!show.booleanValue() && this.window.isShowing()) {
                this.window.hide();
            }
        });
    }

    private static Node labelled(Node content, String title) {
        Label titleLabel = new Label(title);
        JavaFXUtil.addStyleClass((Styleable)titleLabel, "debugger-section-title");
        BorderPane borderPane = new BorderPane(content, (Node)titleLabel, null, null, null);
        JavaFXUtil.addStyleClass((Styleable)borderPane, "debugger-section");
        return borderPane;
    }

    public void setRestrictedClasses(Map<String, Set<String>> restrictedClasses) {
        this.restrictedClasses = restrictedClasses;
    }

    public Map<String, Set<String>> getRestrictedClasses() {
        HashMap<String, Set<String>> copy = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> e : this.restrictedClasses.entrySet()) {
            copy.put(e.getKey(), new HashSet(e.getValue()));
        }
        return copy;
    }

    public void selectThread(DebuggerThread dt) {
        if (this.threadList != null) {
            Project.DebuggerThreadDetails details;
            if (dt.isKnownSystemThread()) {
                this.hideSystemThreads.set(false);
            }
            if ((details = (Project.DebuggerThreadDetails)this.threadList.getItems().stream().filter(d -> d.isThread(dt)).findFirst().orElse(null)) != null) {
                this.threadList.getSelectionModel().select((Object)details);
            }
        } else if (this.selectedThread == null || !dt.sameThread(this.selectedThread.getThread())) {
            this.selectedThreadChanged(new Project.DebuggerThreadDetails(dt));
        }
    }

    public void updateThreadDetails(DebuggerThread dt) {
        if (this.selectedThread != null && this.selectedThread.isThread(dt)) {
            if (this.threadList == null) {
                this.selectedThread.update();
            }
            this.setThreadDetails(this.selectedThread);
        }
    }

    private void selectedThreadChanged(Project.DebuggerThreadDetails dt) {
        if (dt == null) {
            this.selectedThread = null;
            this.cannotHalt.set(true);
            this.cannotStepOrContinue.set(true);
            this.stackList.getItems().clear();
        } else {
            this.selectedThread = dt;
            this.setThreadDetails(dt);
        }
    }

    private void setThreadDetails(Project.DebuggerThreadDetails dt) {
        ArrayList<SourceLocation> stack = new ArrayList<SourceLocation>(dt.getThread().getStack());
        List<SourceLocation> filtered = Arrays.asList(ExecControls.getFilteredStack(stack));
        boolean isSuspended = dt.isSuspended();
        this.cannotHalt.set(isSuspended);
        this.cannotStepOrContinue.set(!isSuspended);
        this.stackList.getItems().setAll(filtered);
        if (filtered.size() > 0) {
            this.autoSelectionEvent = true;
            this.stackList.getSelectionModel().select(0);
            this.autoSelectionEvent = false;
        }
    }

    public static SourceLocation[] getFilteredStack(List<SourceLocation> stack) {
        SourceLocation loc;
        String className;
        int i;
        int first = -1;
        for (i = 0; !(i >= stack.size() || (className = (loc = stack.get(i)).getClassName()).startsWith("bluej.runtime.") && !className.equals(BJInputStream.class.getCanonicalName()) || JavaNames.getBase(className).startsWith("__SHELL") || Config.isGreenfoot() && className.startsWith("greenfoot.core.Simulation")); ++i) {
            if (first != -1 || loc.getFileName() == null) continue;
            first = i;
        }
        if (first == -1 || i == 0) {
            return new SourceLocation[0];
        }
        SourceLocation[] filtered = new SourceLocation[i - first];
        for (int j = first; j < i; ++j) {
            filtered[j - first] = stack.get(j);
        }
        return filtered;
    }

    private void clearThreadDetails() {
        this.stackList.getItems().clear();
        this.staticList.getItems().clear();
        this.instanceList.getItems().clear();
        this.localList.getItems().clear();
    }

    private void stackFrameSelectionChanged(DebuggerThread selectedThread, int index) {
        if (index >= 0) {
            this.setStackFrameDetails(selectedThread, index);
            selectedThread.setSelectedFrame(index);
            if (!this.autoSelectionEvent) {
                this.project.showSource(selectedThread, selectedThread.getClass(index), selectedThread.getClassSourceName(index), selectedThread.getLineNumber(index));
            }
        }
    }

    private void setStackFrameDetails(DebuggerThread selectedThread, int frameNo) {
        try {
            Set<String> whiteList;
            String declaringClass;
            ArrayList<VarDisplayInfo> listData;
            List<DebuggerField> fields;
            DebuggerClass currentClass = selectedThread.getCurrentClass(frameNo);
            DebuggerObject currentObject = selectedThread.getCurrentObject(frameNo);
            if (currentClass != null) {
                fields = currentClass.getStaticFields();
                listData = new ArrayList<VarDisplayInfo>(fields.size());
                for (DebuggerField field : fields) {
                    declaringClass = field.getDeclaringClassName();
                    whiteList = this.restrictedClasses.get(declaringClass);
                    if (whiteList != null && !whiteList.contains(field.getName())) continue;
                    listData.add(new VarDisplayInfo(field));
                }
                this.staticList.getItems().setAll(listData);
            }
            if (currentObject != null && !currentObject.isNullObject()) {
                fields = currentObject.getFields();
                listData = new ArrayList(fields.size());
                for (DebuggerField field : fields) {
                    if (Modifier.isStatic(field.getModifiers()) || (whiteList = this.restrictedClasses.get(declaringClass = field.getDeclaringClassName())) != null && !whiteList.contains(field.getName())) continue;
                    listData.add(new VarDisplayInfo(field));
                }
                this.instanceList.getItems().setAll(listData);
            } else {
                this.instanceList.getItems().clear();
            }
            this.localList.getItems().setAll(selectedThread.getLocalVariables(frameNo));
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    private void createWindowContent(ObservableList<Project.DebuggerThreadDetails> debuggerThreads) {
        this.stopButton = new StopAction().makeButton();
        this.stepButton = new StepAction().makeButton();
        this.stepIntoButton = new StepIntoAction().makeButton();
        this.continueButton = new ContinueAction().makeButton();
        this.terminateButton = new TerminateAction().makeButton();
        this.stepButton.disableProperty().bind((ObservableValue)this.cannotStepOrContinue);
        this.stepIntoButton.disableProperty().bind((ObservableValue)this.cannotStepOrContinue);
        this.continueButton.disableProperty().bind((ObservableValue)this.cannotStepOrContinue);
        this.stopButton.disableProperty().bind((ObservableValue)this.cannotHalt);
        this.staticList = this.makeVarListView();
        JavaFXUtil.addStyleClass(this.staticList, new String[]{"debugger-static-var-list"});
        this.instanceList = this.makeVarListView();
        this.localList = this.makeVarListView();
        this.stackList = new ListView();
        this.stackList.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        JavaFXUtil.addStyleClass(this.stackList, new String[]{"debugger-stack"});
        this.stackList.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(false));
        JavaFXUtil.addChangeListenerPlatform(this.stackList.getSelectionModel().selectedIndexProperty(), index -> this.stackFrameSelectionChanged(this.getSelectedThreadDetails() == null ? null : this.getSelectedThreadDetails().getThread(), index.intValue()));
        Label placeholder = new Label(ExecControls.removeHTML(Config.getString("debugger.threadRunning")));
        placeholder.setTextAlignment(TextAlignment.CENTER);
        this.stackList.setPlaceholder((Node)placeholder);
        if (debuggerThreads != null) {
            FilteredList filteredThreads = new FilteredList(debuggerThreads, this::showThread);
            this.threadList = new ComboBox((ObservableList)filteredThreads);
            JavaFXUtil.addChangeListenerPlatform(this.hideSystemThreads, sys -> {
                filteredThreads.setPredicate(null);
                filteredThreads.setPredicate(this::showThread);
            });
            JavaFXUtil.addChangeListenerPlatform(this.threadList.getSelectionModel().selectedItemProperty(), this::selectedThreadChanged);
        }
    }

    private static String removeHTML(String label) {
        return label.replace("<html>", "").replace("<center>", "").replace("<br>", "\n").replace("</html>", "");
    }

    private boolean showThread(Project.DebuggerThreadDetails thread) {
        if (this.hideSystemThreads.get()) {
            return !thread.getThread().isKnownSystemThread();
        }
        return true;
    }

    private ListView<VarDisplayInfo> makeVarListView() {
        ListView listView = new ListView();
        listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        listView.setCellFactory(lv -> new VarDisplayCell(this.project, (Window)this.window));
        return listView;
    }

    private MenuBar makeMenuBar() {
        MenuBar menubar = new MenuBar();
        menubar.setUseSystemMenuBar(true);
        Menu menu = new Menu(Config.getString("terminal.options"));
        if (!Config.isGreenfoot()) {
            CheckMenuItem systemThreadItem = JavaFXUtil.makeCheckMenuItem(Config.getString("debugger.hideSystemThreads"), (Property<Boolean>)this.hideSystemThreads, null);
            menu.getItems().add((Object)systemThreadItem);
            menu.getItems().add((Object)new SeparatorMenuItem());
        }
        menu.getItems().add((Object)JavaFXUtil.makeMenuItem(Config.getString("close"), this::hide, (KeyCombination)new KeyCodeCombination(KeyCode.W, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})));
        menubar.getMenus().add((Object)menu);
        return menubar;
    }

    public void show() {
        this.window.show();
        this.window.toFront();
    }

    public void hide() {
        this.window.hide();
    }

    public Project.DebuggerThreadDetails getSelectedThreadDetails() {
        if (this.threadList != null) {
            return (Project.DebuggerThreadDetails)this.threadList.getSelectionModel().getSelectedItem();
        }
        return this.selectedThread;
    }

    public BooleanProperty showingProperty() {
        return this.showingProperty;
    }

    private static Node makeStepIcon() {
        Polygon arrowShape = ExecControls.makeScaledUpArrow(false);
        JavaFXUtil.addStyleClass((Styleable)arrowShape, "step-icon-arrow");
        Rectangle bar = new Rectangle(28.0, 6.0);
        JavaFXUtil.addStyleClass((Styleable)bar, "step-icon-bar");
        VBox vBox = new VBox(new Node[]{arrowShape, bar});
        JavaFXUtil.addStyleClass((Styleable)vBox, "step-icon");
        return vBox;
    }

    private static Polygon makeScaledUpArrow(boolean shortTail) {
        Polygon arrowShape = Config.makeArrowShape(shortTail);
        JavaFXUtil.scalePolygonPoints(arrowShape, 1.5, true);
        return arrowShape;
    }

    private static Node makeContinueIcon() {
        Polygon arrowShape1 = ExecControls.makeScaledUpArrow(true);
        Polygon arrowShape2 = ExecControls.makeScaledUpArrow(true);
        Polygon arrowShape3 = ExecControls.makeScaledUpArrow(true);
        JavaFXUtil.addStyleClass((Styleable)arrowShape1, "continue-icon-arrow");
        JavaFXUtil.addStyleClass((Styleable)arrowShape2, "continue-icon-arrow");
        JavaFXUtil.addStyleClass((Styleable)arrowShape3, "continue-icon-arrow");
        arrowShape1.setOpacity(0.2);
        arrowShape2.setOpacity(0.5);
        Pane pane = new Pane(new Node[]{arrowShape1, arrowShape2, arrowShape3});
        arrowShape2.setLayoutX(2.0);
        arrowShape2.setLayoutY(6.0);
        arrowShape3.setLayoutX(4.0);
        arrowShape3.setLayoutY(12.0);
        return pane;
    }

    private static Node makeStepIntoIcon() {
        SVGPath path = new SVGPath();
        path.setContent("M2 16 Q24 8 38 16 L40 10 L48 26 L32 34 L34 28 Q22 22 6 28 Z");
        path.setScaleX(0.75);
        path.setScaleY(0.85);
        JavaFXUtil.addStyleClass((Styleable)path, "step-into-icon");
        return new Group(new Node[]{path});
    }

    private static Node makeTerminateIcon() {
        Polygon s = new Polygon(new double[]{5.0, 0.0, 15.0, 10.0, 25.0, 0.0, 30.0, 5.0, 20.0, 15.0, 30.0, 25.0, 25.0, 30.0, 15.0, 20.0, 5.0, 30.0, 0.0, 25.0, 10.0, 15.0, 0.0, 5.0});
        JavaFXUtil.addStyleClass((Styleable)s, "terminate-icon");
        return s;
    }

    private static class VarDisplayCell
    extends ListCell<VarDisplayInfo> {
        private final Label access = new Label();
        private final Label type = new Label();
        private final Label name = new Label();
        private final Label value = new Label();
        private final BooleanProperty nonEmpty = new SimpleBooleanProperty();
        private static final Image objectImage = Config.getImageAsFXImage("image.eval.object");
        private final SimpleObjectProperty<Supplier<DebuggerObject>> fetchObject = new SimpleObjectProperty(null);

        public VarDisplayCell(Project project, Window window) {
            ImageView objectImageView = new ImageView(objectImage);
            JavaFXUtil.addStyleClass((Styleable)objectImageView, "debugger-var-object-ref");
            objectImageView.visibleProperty().bind((ObservableValue)this.fetchObject.isNotNull());
            objectImageView.managedProperty().bind((ObservableValue)objectImageView.visibleProperty());
            objectImageView.setOnMouseClicked(e -> {
                if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 1) {
                    this.inspect(project, window, (Node)objectImageView);
                }
            });
            HBox hBox = new HBox(new Node[]{this.access, this.type, this.name, new Label("="), objectImageView, this.value});
            hBox.visibleProperty().bind((ObservableValue)this.nonEmpty);
            hBox.styleProperty().bind((ObservableValue)PrefMgr.getEditorFontCSS(false));
            JavaFXUtil.addStyleClass((Styleable)hBox, "debugger-var-cell");
            JavaFXUtil.addStyleClass((Styleable)this.access, "debugger-var-access");
            JavaFXUtil.addStyleClass((Styleable)this.type, "debugger-var-type");
            JavaFXUtil.addStyleClass((Styleable)this.name, "debugger-var-name");
            JavaFXUtil.addStyleClass((Styleable)this.value, "debugger-var-value");
            this.setGraphic((Node)hBox);
            hBox.setOnMouseClicked(e -> {
                if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                    this.inspect(project, window, (Node)objectImageView);
                }
            });
        }

        @OnThread(value=Tag.FXPlatform)
        private void inspect(Project project, Window window, Node sourceNode) {
            if (this.fetchObject.get() != null) {
                project.getInspectorInstance((DebuggerObject)((Supplier)this.fetchObject.get()).get(), null, null, null, window, sourceNode);
            }
        }

        @OnThread(value=Tag.FXPlatform, ignoreParent=true)
        protected void updateItem(VarDisplayInfo item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.nonEmpty.set(!empty);
            if (empty) {
                this.access.setText("");
                this.type.setText("");
                this.name.setText("");
                this.value.setText("");
                this.fetchObject.set(null);
            } else {
                this.access.setText(item.getAccess());
                this.type.setText(item.getType());
                this.name.setText(item.getName());
                this.value.setText(item.getValue());
                this.fetchObject.set(item.getFetchObject());
            }
        }
    }

    private class TerminateAction
    extends FXAbstractAction {
        public TerminateAction() {
            super(terminateButtonText, ExecControls.makeTerminateIcon());
        }

        @Override
        public void actionPerformed(boolean viaContextMenu) {
            try {
                ExecControls.this.clearThreadDetails();
                ExecControls.this.project.restartVM();
                DataCollector.debuggerTerminate(ExecControls.this.project);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private class ContinueAction
    extends FXAbstractAction {
        public ContinueAction() {
            super(continueButtonText, ExecControls.makeContinueIcon());
        }

        @Override
        public void actionPerformed(boolean viaContextMenu) {
            Project.DebuggerThreadDetails details = ExecControls.this.getSelectedThreadDetails();
            if (details == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            ExecControls.this.project.removeStepMarks();
            if (details.isSuspended()) {
                details.getThread().cont();
                DataCollector.debuggerContinue(ExecControls.this.project, details.getThread().getName());
            }
        }
    }

    private class StepIntoAction
    extends FXAbstractAction {
        public StepIntoAction() {
            super(stepIntoButtonText, ExecControls.makeStepIntoIcon());
        }

        @Override
        public void actionPerformed(boolean viaContextMenu) {
            Project.DebuggerThreadDetails details = ExecControls.this.getSelectedThreadDetails();
            if (details == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            ExecControls.this.project.removeStepMarks();
            if (details.isSuspended()) {
                details.getThread().stepInto();
            }
        }
    }

    private class StepAction
    extends FXAbstractAction {
        public StepAction() {
            super(stepButtonText, ExecControls.makeStepIcon());
        }

        @Override
        public void actionPerformed(boolean viaContextMenu) {
            Project.DebuggerThreadDetails details = ExecControls.this.getSelectedThreadDetails();
            if (details == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            ExecControls.this.project.removeStepMarks();
            if (details.isSuspended()) {
                details.getThread().step();
            }
            ExecControls.this.project.updateInspectors();
        }
    }

    private class StopAction
    extends FXAbstractAction {
        public StopAction() {
            super(haltButtonText, Config.makeStopIcon(true));
        }

        @Override
        public void actionPerformed(boolean viaContextMenu) {
            Project.DebuggerThreadDetails details = ExecControls.this.getSelectedThreadDetails();
            if (details == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            if (!details.isSuspended()) {
                details.getThread().halt();
            }
        }
    }
}

