/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.TextType;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ParameterList;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.dialog.DialogPaneAnimateError;
import bluej.views.CallableView;
import bluej.views.TypeParamView;
import bluej.views.View;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public abstract class CallDialog
extends Dialog<Void>
implements ObjectBenchListener {
    protected static final String emptyFieldMsg = Config.getString("error.methodCall.emptyField");
    protected static final String emptyTypeFieldMsg = Config.getString("error.methodCall.emptyTypeField");
    private Label errorLabel;
    protected ParameterList parameterList;
    protected ParameterList typeParameterList;
    protected final ObjectBenchInterface bench;
    protected String defaultParamValue = "";
    private Pane descPanel;
    protected TextField focusedTextField;
    protected CallHistory history;
    private DialogPaneAnimateError dialogPane;

    public CallDialog(Window parent, ObjectBenchInterface objectBench, String title) {
        this.initOwner(parent);
        this.setTitle(title);
        this.initModality(Modality.NONE);
        this.setResizable(true);
        this.bench = objectBench;
        this.bench.addObjectBenchListener(this);
    }

    public abstract void handleOK();

    public void setWaitCursor(boolean wait) {
        this.getDialogPane().setCursor(wait ? Cursor.WAIT : Cursor.DEFAULT);
    }

    public void setOKEnabled(boolean state) {
        this.dialogPane.getOKButton().setDisable(!state);
    }

    public void setErrorMessage(String message) {
        int index = message.indexOf("location:");
        if (index != -1) {
            message = message.substring(0, index - 1);
        }
        String messageFinal = message;
        JavaFXUtil.runNowOrLater(() -> this.errorLabel.setText(messageFinal));
    }

    @Override
    @OnThread(value=Tag.FXPlatform)
    public void objectEvent(ObjectBenchEvent obe) {
        NamedValue value = obe.getValue();
        String name = value.getName();
        this.insertText(name);
    }

    protected static TypeParamView[] getFormalTypeParams(CallableView callable) {
        View clazz = callable.getDeclaringView();
        return clazz.getTypeParams();
    }

    protected Pane createParameterPanel(String prefix) {
        CallableView method = this.getCallableView();
        Class<?>[] paramClasses = this.getArgTypes(false);
        String[] paramNames = method.getParamNames();
        String[] paramTypes = method.getParamTypeStrings();
        this.parameterList = new ParameterList(paramClasses.length, this.defaultParamValue, f -> {
            this.focusedTextField = f;
        }, this::fireOK);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (method.isVarArgs() && i == paramClasses.length - 1) {
                List<String> historyList = this.history.getHistory(paramClasses[i].getComponentType());
                this.parameterList.addVarArgsTypes(paramTypes[i], paramNames == null ? null : paramNames[i]);
                this.parameterList.setHistory(i, historyList);
                continue;
            }
            this.parameterList.addNormalParameter(paramTypes[i], paramNames == null ? null : paramNames[i], this.history.getHistory(paramClasses[i]));
        }
        return this.createParameterPanel(prefix + "(", ")", this.parameterList);
    }

    protected void fireOK() {
        this.dialogPane.getOKButton().fire();
    }

    protected Pane createParameterPanel(String startString, String endString, ParameterList parameterList) {
        GridPane parameterPanel = new GridPane();
        parameterPanel.getStyleClass().add((Object)"grid");
        Label startParenthesis = new Label(startString);
        startParenthesis.setAlignment(Pos.BASELINE_LEFT);
        parameterPanel.add((Node)startParenthesis, 0, 0);
        GridPane.setValignment((Node)startParenthesis, (VPos)VPos.BASELINE);
        for (int i = 0; i < parameterList.formalCount(); ++i) {
            ObservableList<? extends Node> components = parameterList.getNodesForFormal(i);
            if (components.size() == 1) {
                Node child = (Node)components.get(0);
                parameterPanel.add(child, 1, i);
            } else {
                GridPane varargsPane = new GridPane();
                varargsPane.getStyleClass().add((Object)"grid");
                varargsPane.setAlignment(Pos.BASELINE_LEFT);
                GridPane.setValignment((Node)varargsPane, (VPos)VPos.BASELINE);
                this.arrangeVarargsComponents(varargsPane, components);
                components.addListener(c -> {
                    this.arrangeVarargsComponents(varargsPane, (ObservableList<? extends Node>)c.getList());
                    this.getDialogPane().getScene().getWindow().sizeToScene();
                });
                ColumnConstraints column2 = new ColumnConstraints();
                column2.setHgrow(Priority.ALWAYS);
                varargsPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), column2, new ColumnConstraints(), new ColumnConstraints()});
                parameterPanel.add((Node)varargsPane, 1, i);
            }
            Label type = new Label(i == parameterList.formalCount() - 1 ? endString : ",");
            type.setAlignment(Pos.BOTTOM_LEFT);
            parameterPanel.add((Node)type, 2, i);
            GridPane.setValignment((Node)type, (VPos)VPos.BOTTOM);
        }
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setHgrow(Priority.ALWAYS);
        parameterPanel.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), column2, new ColumnConstraints()});
        return parameterPanel;
    }

    private void arrangeVarargsComponents(GridPane varargsPane, ObservableList<? extends Node> components) {
        varargsPane.getChildren().clear();
        int lastComponentIndex = components.size() - 1;
        for (int j = 0; j < lastComponentIndex; ++j) {
            varargsPane.add((Node)components.get(j), j % 3, j / 3);
        }
        varargsPane.add((Node)components.get(lastComponentIndex), 3, (lastComponentIndex - 1) / 3);
    }

    public Class<?>[] getArgTypes(boolean varArgsExpanded) {
        boolean hasVarArgs;
        CallableView method = this.getCallableView();
        Class<?>[] params = method.getParameters();
        boolean bl = hasVarArgs = method.isVarArgs() && this.parameterList != null && this.parameterList.actualCount() >= params.length;
        if (hasVarArgs && varArgsExpanded) {
            int totalParams = this.parameterList.actualCount();
            Class[] allParams = new Class[totalParams];
            System.arraycopy(params, 0, allParams, 0, params.length);
            Class<?> varArgType = params[params.length - 1].getComponentType();
            for (int i = params.length - 1; i < totalParams; ++i) {
                allParams[i] = varArgType;
            }
            return allParams;
        }
        return params;
    }

    public String[] getArgs() {
        String[] args = null;
        if (this.parameterList != null) {
            args = new String[this.parameterList.actualCount()];
            for (int i = 0; i < this.parameterList.actualCount(); ++i) {
                args[i] = this.parameterList.getActualParameter(i).getEditor().getText();
            }
        }
        return args;
    }

    public boolean parameterFieldsOk() {
        if (this.parameterList != null) {
            for (int i = 0; i < this.parameterList.actualCount(); ++i) {
                String arg = this.parameterList.getActualParameter(i).getEditor().getText();
                if (arg == null || arg.trim().equals("")) {
                    JavaFXUtil.setPseudoclass("bj-dialog-error", true, new Node[]{this.parameterList.getActualParameter(i).getEditor()});
                    return false;
                }
                JavaFXUtil.setPseudoclass("bj-dialog-error", false, new Node[]{this.parameterList.getActualParameter(i).getEditor()});
            }
        }
        return true;
    }

    public boolean typeParameterFieldsOk() {
        boolean oneIsTypedIn = false;
        boolean oneIsEmpty = false;
        if (this.typeParameterList != null) {
            ArrayList<TextField> empties = new ArrayList<TextField>();
            for (int i = 0; i < this.typeParameterList.actualCount(); ++i) {
                TextField field = this.typeParameterList.getActualParameter(i).getEditor();
                JavaFXUtil.setPseudoclass("bj-dialog-error", false, new Node[]{field});
                String arg = field.getText();
                if (arg == null || arg.trim().equals("")) {
                    oneIsEmpty = true;
                    empties.add(field);
                } else {
                    oneIsTypedIn = true;
                }
                if (!oneIsEmpty || !oneIsTypedIn) continue;
                empties.forEach(f -> JavaFXUtil.setPseudoclass("bj-dialog-error", true, new Node[]{field}));
                return false;
            }
        }
        return true;
    }

    protected void makeDialog(Pane centerPanel) {
        VBox dialogPanel = new VBox();
        JavaFXUtil.addStyleClass((Styleable)dialogPanel, "call-dialog-content");
        this.descPanel = new VBox();
        this.errorLabel = JavaFXUtil.withStyleClass(new Label(" "), "dialog-error-label");
        dialogPanel.getChildren().addAll((Object[])new Node[]{this.descPanel, new Separator(), centerPanel, this.errorLabel});
        this.dialogPane = new DialogPaneAnimateError(this.errorLabel, () -> {});
        Config.addDialogStylesheets(this.dialogPane);
        this.setDialogPane(this.dialogPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.dialogPane.getOKButton().addEventFilter(ActionEvent.ACTION, e -> {
            this.handleOK();
            e.consume();
        });
        this.getDialogPane().setContent((Node)dialogPanel);
        this.setOnHidden(e -> this.bench.removeObjectBenchListener(this));
    }

    protected void setDescription(Node label) {
        this.descPanel.getChildren().setAll((Object[])new Node[]{label});
    }

    public void insertText(String text) {
        if (this.parameterList != null && this.focusedTextField != null) {
            this.focusedTextField.setText(text);
            ((Stage)this.focusedTextField.getScene().getWindow()).toFront();
            this.focusedTextField.requestFocus();
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public void saveCallHistory() {
        if (this.parameterList != null) {
            Class<?>[] paramClasses = this.getArgTypes(true);
            for (int i = 0; i < this.parameterList.actualCount(); ++i) {
                this.history.addCall(paramClasses[i], this.parameterList.getActualParameter(i).getEditor().getText());
            }
        }
        if (this.typeParameterList != null) {
            int i;
            CallableView callable = this.getCallableView();
            TypeParamView[] formalTypeParams = CallDialog.getFormalTypeParams(callable);
            String[] typeParams = this.getTypeParams();
            for (i = 0; i < typeParams.length; ++i) {
                this.history.addCall(formalTypeParams[i], typeParams[i]);
            }
            for (i = 0; i < typeParams.length; ++i) {
                List<String> historyList = this.history.getHistory(formalTypeParams[i]);
                this.typeParameterList.setHistory(i, historyList);
            }
        }
    }

    public String[] getTypeParams() {
        if (this.typeParameterList == null) {
            return new String[0];
        }
        String[] typeParams = new String[this.typeParameterList.actualCount()];
        for (int i = 0; i < this.typeParameterList.actualCount(); ++i) {
            typeParams[i] = this.typeParameterList.getActualParameter(i).getEditor().getText();
            if (typeParams[i] != null && !typeParams[i].equals("")) continue;
            return new String[0];
        }
        return typeParams;
    }

    public JavaType[] getArgGenTypes(boolean varArgsExpanded) {
        CallableView method = this.getCallableView();
        boolean raw = this.targetIsRaw();
        Map<String, GenTypeParameter> typeParameterMap = this.getTargetTypeArgs();
        HashMap<String, GenTypeParameter> typeMap = new HashMap<String, GenTypeParameter>();
        if (typeParameterMap != null) {
            typeMap.putAll(typeParameterMap);
        }
        String[] typeParams = this.getTypeParams();
        TypeParamView[] formalTypeParamViews = CallDialog.getFormalTypeParams(method);
        int len = typeParams.length;
        for (int i = 0; i < len; ++i) {
            TypeParamView view = formalTypeParamViews[i];
            GenTypeDeclTpar formalType = view.getParamType();
            TextType actualType = new TextType(typeParams[i]);
            typeMap.put(formalType.getTparName(), actualType);
        }
        JavaType[] params = method.getParamTypes(raw);
        for (int i = 0; i < params.length; ++i) {
            params[i] = params[i].mapTparsToTypes(typeMap).getUpperBound();
        }
        if (this.hasVarArgs(method, params) && varArgsExpanded) {
            int totalParams = this.parameterList.actualCount();
            JavaType[] allParams = new JavaType[totalParams];
            System.arraycopy(params, 0, allParams, 0, params.length);
            JavaType varArgType = params[params.length - 1].getArrayComponent();
            for (int i = params.length - 1; i < totalParams; ++i) {
                allParams[i] = varArgType;
            }
            return allParams;
        }
        return params;
    }

    private boolean hasVarArgs(CallableView method, JavaType[] params) {
        if (!method.isVarArgs()) {
            return false;
        }
        if (this.parameterList == null) {
            return false;
        }
        if (this.parameterList.actualCount() < params.length) {
            return false;
        }
        return this.getArgs().length != 1 || !this.isEmptyArg(this.getArgs()[0]);
    }

    private boolean isEmptyArg(String value) {
        String[] emptyArgs = new String[]{"{ }", "{}", ""};
        return Arrays.asList(emptyArgs).contains(value.trim());
    }

    protected String getNewInstanceName() {
        return null;
    }

    protected abstract CallableView getCallableView();

    protected boolean targetIsRaw() {
        return false;
    }

    protected Map<String, GenTypeParameter> getTargetTypeArgs() {
        return Collections.emptyMap();
    }
}

