/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.VMReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.StepRequest;
import java.util.LinkedList;
import java.util.Queue;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
class VMEventHandler
extends Thread {
    static final String DONT_RESUME = "dontResume";
    private VMReference vm;
    private EventQueue queue;
    private @OnThread(value=Tag.Any, requireSynchronized=true) boolean queueEmpty;
    private Queue<ThreadEvent> haltedThreads = new LinkedList<ThreadEvent>();
    volatile @OnThread(value=Tag.Any) boolean exiting = false;

    VMEventHandler(VMReference vm, VirtualMachine vmm) {
        super("vm-event-handler");
        this.vm = vm;
        this.queue = vmm.eventQueue();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OnThread(value=Tag.Worker, ignoreParent=true)
    public void run() {
        while (!this.exiting) {
            try {
                Event ev;
                EventSet eventSet = this.queue.remove(1L);
                if (eventSet == null) {
                    VMEventHandler vMEventHandler = this;
                    synchronized (vMEventHandler) {
                        this.queueEmpty = true;
                        this.notifyAll();
                    }
                    this.handleThreadEvents();
                    try {
                        eventSet = this.queue.remove();
                    }
                    catch (InterruptedException ie) {
                        this.handleThreadEvents();
                        continue;
                    }
                    VMEventHandler ie = this;
                    synchronized (ie) {
                        this.isInterrupted();
                        this.queueEmpty = false;
                    }
                }
                this.handleThreadEvents();
                boolean addToSuspendCount = true;
                EventIterator it = eventSet.eventIterator();
                boolean examineSaidSkipUpdates = false;
                boolean gotBPEvent = false;
                while (it.hasNext()) {
                    ev = it.nextEvent();
                    examineSaidSkipUpdates |= this.screenEvent(ev);
                    if (ev.request() == null || !addToSuspendCount || ev.request().getProperty(DONT_RESUME) == null || !(ev instanceof LocatableEvent)) continue;
                    LocatableEvent le = (LocatableEvent)ev;
                    le.thread().suspend();
                    addToSuspendCount = false;
                    gotBPEvent |= ev instanceof BreakpointEvent;
                }
                it = eventSet.eventIterator();
                while (it.hasNext()) {
                    ev = it.nextEvent();
                    this.handleEvent(ev, examineSaidSkipUpdates, gotBPEvent);
                }
                eventSet.resume();
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.exiting = true;
            }
        }
    }

    private synchronized void handleThreadEvents() {
        ThreadEvent halted = this.haltedThreads.poll();
        while (halted != null) {
            if (halted.state) {
                this.vm.threadHaltedEvent(halted.thread);
            } else {
                this.vm.threadResumedEvent(halted.thread);
            }
            halted = this.haltedThreads.poll();
        }
    }

    @OnThread(value=Tag.Any)
    public synchronized void emitThreadEvent(JdiThread thr, boolean halted) {
        this.haltedThreads.add(new ThreadEvent(thr, halted));
        if (this.queueEmpty) {
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnThread(value=Tag.Any)
    public void waitQueueEmpty() {
        VMEventHandler vMEventHandler = this;
        synchronized (vMEventHandler) {
            try {
                while (!this.queueEmpty) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static int getStepType(StepEvent ev) {
        EventRequest req = ev.request();
        if (req instanceof StepRequest) {
            int stepDepth = ((StepRequest)req).depth();
            if (stepDepth == 1) {
                return 4;
            }
            if (stepDepth == 2) {
                return 3;
            }
        }
        return 2;
    }

    private boolean screenEvent(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.vm.screenBreakpointEvent((LocatableEvent)event, 5);
        }
        if (event instanceof StepEvent) {
            return this.vm.screenBreakpointEvent((LocatableEvent)event, VMEventHandler.getStepType((StepEvent)event));
        }
        return false;
    }

    private void handleEvent(Event event, boolean skipUpdate, boolean gotBP) {
        if (event instanceof VMStartEvent) {
            this.vm.vmStartEvent((VMStartEvent)event);
        } else if (!(event instanceof VMDeathEvent)) {
            if (event instanceof VMDisconnectEvent) {
                this.vm.vmDisconnectEvent();
            } else if (event instanceof ExceptionEvent) {
                this.vm.exceptionEvent((ExceptionEvent)event);
            } else if (event instanceof BreakpointEvent) {
                this.vm.breakpointEvent((LocatableEvent)event, 5, skipUpdate);
            } else if (event instanceof StepEvent) {
                if (!gotBP) {
                    this.vm.breakpointEvent((LocatableEvent)event, VMEventHandler.getStepType((StepEvent)event), skipUpdate);
                }
            } else if (event instanceof ThreadStartEvent) {
                this.vm.threadStartEvent((ThreadStartEvent)event);
            } else if (event instanceof ThreadDeathEvent) {
                this.vm.threadDeathEvent((ThreadDeathEvent)event);
            } else if (event instanceof ClassPrepareEvent) {
                this.classPrepareEvent(event);
            }
        }
    }

    private boolean classPrepareEvent(Event event) {
        ClassPrepareEvent cle = (ClassPrepareEvent)event;
        ReferenceType refType = cle.referenceType();
        if (refType.name().equals(VMReference.SERVER_CLASSNAME)) {
            this.vm.serverClassPrepared();
        }
        return true;
    }

    @OnThread(value=Tag.Any)
    private class ThreadEvent {
        JdiThread thread;
        boolean state;

        ThreadEvent(JdiThread thread, boolean state) {
            this.thread = thread;
            this.state = state;
        }
    }
}

