/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import threadchecker.OnThread;
import threadchecker.Tag;

public class JdiField
extends DebuggerField {
    private final @OnThread(value=Tag.Any) Field field;
    private final @OnThread(value=Tag.Any) JdiObject object;
    private boolean hidden;

    @OnThread(value=Tag.Any)
    public JdiField(Field field, JdiObject object, boolean hidden) {
        this.field = field;
        this.object = object;
        this.hidden = hidden;
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getName() {
        return this.field.name();
    }

    @Override
    public JavaType getType() {
        if (this.object != null) {
            return JdiReflective.fromField(this.field, this.object);
        }
        return JdiReflective.fromField(this.field);
    }

    @Override
    public int getModifiers() {
        return this.field.modifiers();
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getValueString() {
        Value value = this.object != null ? this.object.obj.getValue(this.field) : this.field.declaringType().getValue(this.field);
        return JdiUtils.getJdiUtils().getValueString(value);
    }

    @Override
    public DebuggerObject getValueObject(JavaType expectedType) {
        Value value = this.object != null ? this.object.obj.getValue(this.field) : this.field.declaringType().getValue(this.field);
        if (value == null) {
            return JdiObject.getDebuggerObject(null);
        }
        if (value instanceof ObjectReference) {
            ObjectReference or = (ObjectReference)value;
            if (expectedType == null) {
                expectedType = this.getType();
            }
            return JdiObject.getDebuggerObject(or, expectedType);
        }
        return null;
    }

    @Override
    public DebuggerClass getDeclaringClass() {
        return new JdiClass(this.field.declaringType());
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }
}

