/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import com.sun.jdi.LocalVariable;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;
import threadchecker.OnThread;
import threadchecker.Tag;

public class VarDisplayInfo {
    private final String access;
    private final String type;
    private final String name;
    private final String value;
    private final @OnThread(value=Tag.Any) Supplier<DebuggerObject> getObjectToInspect;

    @OnThread(value=Tag.FXPlatform)
    public VarDisplayInfo(DebuggerField field) {
        int mods = field.getModifiers();
        Object access = "";
        if (Modifier.isPrivate(mods)) {
            access = "private";
        } else if (Modifier.isPublic(mods)) {
            access = "public";
        } else if (Modifier.isProtected(mods)) {
            access = "protected";
        }
        if (field.isHidden()) {
            access = (String)access + "(hidden)";
        }
        this.access = access;
        this.type = field.getType().toString(true);
        this.name = field.getName();
        this.value = field.getValueString();
        this.getObjectToInspect = field.isReferenceType() && !field.isNull() ? () -> field.getValueObject(null) : null;
    }

    @OnThread(value=Tag.FXPlatform)
    public VarDisplayInfo(JavaType vartype, LocalVariable var, String value, Supplier<DebuggerObject> getObjectToInspect) {
        this.access = null;
        this.type = vartype.toString(true);
        this.name = var.name();
        this.value = value;
        this.getObjectToInspect = getObjectToInspect;
    }

    public String getAccess() {
        return this.access;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @OnThread(value=Tag.Any)
    public Supplier<DebuggerObject> getFetchObject() {
        return this.getObjectToInspect;
    }
}

