/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import com.sun.jdi.ObjectReference;
import java.lang.reflect.Modifier;
import java.util.List;

public abstract class DebuggerObject {
    public static final String OBJECT_REFERENCE = "<object reference>";

    public abstract String getClassName();

    public abstract DebuggerClass getClassRef();

    public abstract GenTypeClass getGenType();

    public abstract boolean isArray();

    public abstract boolean isNullObject();

    public abstract List<DebuggerField> getFields();

    public DebuggerField getField(int slot) {
        return this.getFields().get(slot);
    }

    public DebuggerField getInstanceField(int slot) {
        for (DebuggerField field : this.getFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (slot == 0) {
                return field;
            }
            --slot;
        }
        return null;
    }

    public abstract int getElementCount();

    public abstract JavaType getElementType();

    public abstract DebuggerObject getElementObject(int var1);

    public abstract String getElementValueString(int var1);

    public abstract ObjectReference getObjectReference();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

