/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Boot;
import bluej.Config;
import bluej.collect.CodeAnonymiser;
import bluej.collect.CollectUtility;
import bluej.collect.DataCollector;
import bluej.collect.DataSubmitter;
import bluej.collect.DiagnosticWithShown;
import bluej.collect.Event;
import bluej.collect.EventName;
import bluej.collect.FileKey;
import bluej.collect.GreenfootInterfaceEvent;
import bluej.collect.PlainEvent;
import bluej.collect.StrideEditReason;
import bluej.compiler.CompileInputFile;
import bluej.compiler.CompileReason;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.editor.stride.FrameCatalogue;
import bluej.extensions.SourceType;
import bluej.extmgr.ExtensionWrapper;
import bluej.groupwork.Repository;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.stride.generic.Frame;
import bluej.utility.Utility;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class DataCollectorImpl {
    private static IdentityHashMap<Inspector, Package> inspectorPackages = new IdentityHashMap();

    private static void submitEventNoData(Project project, Package pkg, EventName eventName) {
        DataCollectorImpl.submitEvent(project, pkg, eventName, new PlainEvent(new MultipartEntity()));
    }

    private static void submitEventWithLocalLocation(Project project, Package pkg, EventName eventName, MultipartEntity mpe, File sourceFile, int lineNumber) {
        if (mpe == null) {
            mpe = new MultipartEntity();
        }
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(new CollectUtility.ProjectDetails(project), sourceFile));
        mpe.addPart("event[line_number]", (ContentBody)CollectUtility.toBody(lineNumber));
        DataCollectorImpl.submitEvent(project, pkg, eventName, new PlainEvent(mpe));
    }

    private static void submitDebuggerEventWithLocation(Project project, EventName eventName, MultipartEntity mpe, SourceLocation[] stack) {
        if (mpe == null) {
            mpe = new MultipartEntity();
        }
        DataCollectorImpl.addStackTrace(mpe, "event[stack]", stack);
        DataCollectorImpl.submitEvent(project, null, eventName, new PlainEvent(mpe));
    }

    private static synchronized void submitEvent(Project project, Package pkg, final EventName eventName, final Event evt) {
        final String projectName = project == null ? null : project.getProjectName();
        final String projectPathHash = project == null ? null : CollectUtility.md5Hash(project.getProjectDir().getAbsolutePath());
        final String packageName = pkg == null ? null : pkg.getQualifiedName();
        final String uuidCopy = DataCollector.getUserID();
        final String experimentCopy = DataCollector.getExperimentIdentifier();
        final String participantCopy = DataCollector.getParticipantIdentifier();
        DataSubmitter.submitEvent(new Event(){

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                evt.success(fileVersions);
            }

            @Override
            @OnThread(value=Tag.Worker)
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                MultipartEntity mpe = evt.makeData(sequenceNum, fileVersions);
                if (mpe == null) {
                    return null;
                }
                mpe.addPart("user[uuid]", (ContentBody)CollectUtility.toBody(uuidCopy));
                mpe.addPart("session[id]", (ContentBody)CollectUtility.toBody(DataCollector.getSessionUuid()));
                mpe.addPart("participant[experiment]", (ContentBody)CollectUtility.toBody(experimentCopy));
                mpe.addPart("participant[participant]", (ContentBody)CollectUtility.toBody(participantCopy));
                if (projectName != null) {
                    mpe.addPart("project[name]", (ContentBody)CollectUtility.toBody(projectName));
                    mpe.addPart("project[path_hash]", (ContentBody)CollectUtility.toBody(projectPathHash));
                    if (packageName != null) {
                        mpe.addPart("package[name]", (ContentBody)CollectUtility.toBody(packageName));
                    }
                }
                mpe.addPart("event[source_time]", (ContentBody)CollectUtility.toBody(DateFormat.getDateTimeInstance().format(new Date())));
                mpe.addPart("event[name]", (ContentBody)CollectUtility.toBody(eventName.getName()));
                mpe.addPart("event[sequence_id]", (ContentBody)CollectUtility.toBody(Integer.toString(sequenceNum)));
                return mpe;
            }
        });
    }

    public static void compiled(Project proj, Package pkg, CompileInputFile[] sources, List<DiagnosticWithShown> diagnostics, boolean success, CompileReason compileReason, int compileSequence) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[compile_success]", (ContentBody)CollectUtility.toBody(success));
        mpe.addPart("event[compile_reason]", (ContentBody)CollectUtility.toBody(compileReason.getServerString()));
        if (compileSequence != -1) {
            mpe.addPart("event[compile_sequence]", (ContentBody)CollectUtility.toBody(compileSequence));
        }
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(proj);
        for (CompileInputFile src : sources) {
            mpe.addPart("event[compile_input][][source_file_name]", (ContentBody)CollectUtility.toBody(CollectUtility.toPath(projDetails, src.getUserSourceFile())));
        }
        for (DiagnosticWithShown dws : diagnostics) {
            Diagnostic d = dws.getDiagnostic();
            mpe.addPart("event[compile_output][][is_error]", (ContentBody)CollectUtility.toBody(d.getType() == Diagnostic.ERROR));
            mpe.addPart("event[compile_output][][message]", (ContentBody)CollectUtility.toBody(d.getMessage()));
            mpe.addPart("event[compile_output][][session_sequence]", (ContentBody)CollectUtility.toBody(d.getIdentifier()));
            mpe.addPart("event[compile_output][][origin]", (ContentBody)CollectUtility.toBody(d.getOrigin()));
            if (d.getFileName() == null) continue;
            if (d.getStartLine() >= 1L) {
                mpe.addPart("event[compile_output][][start_line]", (ContentBody)CollectUtility.toBody(d.getStartLine()));
            }
            if (d.getEndLine() >= 1L) {
                mpe.addPart("event[compile_output][][end_line]", (ContentBody)CollectUtility.toBody(d.getEndLine()));
            }
            if (d.getStartColumn() >= 1L) {
                mpe.addPart("event[compile_output][][start_column]", (ContentBody)CollectUtility.toBody(d.getStartColumn()));
            }
            if (d.getEndColumn() >= 1L) {
                mpe.addPart("event[compile_output][][end_column]", (ContentBody)CollectUtility.toBody(d.getEndColumn()));
            }
            if (d.getXPath() != null) {
                mpe.addPart("event[compile_output][][xpath]", (ContentBody)CollectUtility.toBody(d.getXPath()));
                if (d.getXmlStart() != -1) {
                    mpe.addPart("event[compile_output][][xml_start]", (ContentBody)CollectUtility.toBody(d.getXmlStart()));
                }
                if (d.getXmlEnd() != -1) {
                    mpe.addPart("event[compile_output][][xml_end]", (ContentBody)CollectUtility.toBody(d.getXmlEnd()));
                }
            }
            String relative = CollectUtility.toPath(projDetails, dws.getUserFileName());
            mpe.addPart("event[compile_output][][source_file_name]", (ContentBody)CollectUtility.toBody(relative));
        }
        DataCollectorImpl.submitEvent(proj, pkg, EventName.COMPILE, new PlainEvent(mpe));
    }

    public static void bluejOpened(String osVersion, String javaVersion, String bluejVersion, String interfaceLanguage, List<ExtensionWrapper> extensions) {
        if (Config.isGreenfoot() && !Boot.isTrialRecording()) {
            return;
        }
        DataSubmitter.initSequence();
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("installation[operating_system]", (ContentBody)CollectUtility.toBody(osVersion));
        mpe.addPart("installation[java_version]", (ContentBody)CollectUtility.toBody(javaVersion));
        mpe.addPart("installation[bluej_version]", (ContentBody)CollectUtility.toBody(bluejVersion));
        mpe.addPart("installation[interface_language]", (ContentBody)CollectUtility.toBody(interfaceLanguage));
        DataCollectorImpl.addExtensions(mpe, extensions);
        DataCollectorImpl.submitEvent(null, null, EventName.BLUEJ_START, new PlainEvent(mpe));
    }

    private static void addExtensions(MultipartEntity mpe, List<ExtensionWrapper> extensions) {
        for (ExtensionWrapper ext : extensions) {
            mpe.addPart("extensions[][name]", (ContentBody)CollectUtility.toBody(ext.safeGetExtensionName()));
            mpe.addPart("extensions[][version]", (ContentBody)CollectUtility.toBody(ext.safeGetExtensionVersion()));
        }
    }

    public static void projectOpened(Project proj, List<ExtensionWrapper> projectExtensions) {
        MultipartEntity mpe = new MultipartEntity();
        DataCollectorImpl.addExtensions(mpe, projectExtensions);
        DataCollectorImpl.submitEventNoData(proj, null, EventName.PROJECT_OPENING);
    }

    public static void projectClosed(Project proj) {
        DataCollectorImpl.submitEventNoData(proj, null, EventName.PROJECT_CLOSING);
    }

    public static void packageOpened(Package pkg) {
        DataCollectorImpl.addCompleteFiles(pkg, EventName.PACKAGE_OPENING, pkg.getClassTargets(), null);
    }

    private static void addCompleteFiles(Package pkg, EventName eventName, List<ClassTarget> classTargets, Consumer<MultipartEntity> extra) {
        final MultipartEntity mpe = new MultipartEntity();
        if (extra != null) {
            extra.accept(mpe);
        }
        CollectUtility.ProjectDetails proj = new CollectUtility.ProjectDetails(pkg.getProject());
        final HashMap<FileKey, List<String>> versions = new HashMap<FileKey, List<String>>();
        for (ClassTarget ct : classTargets) {
            for (ClassTarget.SourceFileInfo fileInfo : ct.getAllSourceFilesJavaLast()) {
                String relative = CollectUtility.toPath(proj, fileInfo.file);
                mpe.addPart("project[source_files][][name]", (ContentBody)CollectUtility.toBody(relative));
                switch (fileInfo.sourceType) {
                    case Java: {
                        mpe.addPart("project[source_files][][source_type]", (ContentBody)CollectUtility.toBody("java"));
                        break;
                    }
                    case Stride: {
                        mpe.addPart("project[source_files][][source_type]", (ContentBody)CollectUtility.toBody("stride"));
                    }
                }
                String anonymisedContent = CollectUtility.readFileAndAnonymise(proj, fileInfo.file);
                String generatedFrom = null;
                if (fileInfo.sourceType == SourceType.Java && ct.getSourceType() == SourceType.Stride) {
                    generatedFrom = CollectUtility.toPath(proj, ct.getSourceFile());
                    if (anonymisedContent == null) {
                        anonymisedContent = "";
                    }
                }
                if (anonymisedContent == null) continue;
                DataCollectorImpl.addSourceHistoryItem(mpe, relative, "complete", anonymisedContent, generatedFrom);
                versions.put(new FileKey(proj, relative), Arrays.asList(Utility.splitLines(anonymisedContent)));
            }
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, eventName, new Event(){

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                fileVersions.putAll(versions);
            }

            @Override
            @OnThread(value=Tag.Worker)
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                return mpe;
            }
        });
    }

    @OnThread(value=Tag.Any)
    private static void addSourceHistoryItem(MultipartEntity mpe, String relativeName, String type, String anonymisedContent, String generatedFrom) {
        mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody(type));
        mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBody(relativeName));
        if (generatedFrom != null) {
            mpe.addPart("source_histories[][generated_from]", (ContentBody)CollectUtility.toBody(generatedFrom));
        }
        if (anonymisedContent != null) {
            mpe.addPart("source_histories[][content]", (ContentBody)CollectUtility.toBody(anonymisedContent));
        }
    }

    public static void packageClosed(Package pkg) {
        DataCollectorImpl.addCompleteFiles(pkg, EventName.PACKAGE_CLOSING, pkg.getClassTargets(), mpe -> mpe.addPart("event[has_hash]", (ContentBody)CollectUtility.toBody(true)));
    }

    public static void bluejClosed() {
        DataCollectorImpl.submitEventNoData(null, null, EventName.BLUEJ_FINISH);
        DataSubmitter.waitForQueueFlush(1000);
    }

    public static void restartVM(Project project) {
        DataCollectorImpl.submitEventNoData(project, null, EventName.RESETTING_VM);
    }

    static void edit(Package pkg, final List<EditedFileInfo> editedFiles) {
        Project proj = pkg.getProject();
        final CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(proj);
        for (EditedFileInfo editedFile : editedFiles) {
            editedFile.fileKey = new FileKey(projDetails, CollectUtility.toPath(projDetails, editedFile.path));
            editedFile.anonSource = Arrays.asList(Utility.splitLines(CodeAnonymiser.anonymise(editedFile.source)));
        }
        DataCollectorImpl.submitEvent(proj, pkg, EventName.EDIT, new Event(){

            private boolean isOneLineDiff(Patch patch) {
                if (patch.getDeltas().size() > 1) {
                    return false;
                }
                Delta theDelta = (Delta)patch.getDeltas().get(0);
                return theDelta.getOriginal().size() == 1 && theDelta.getRevised().size() == 1;
            }

            @Override
            @OnThread(value=Tag.Worker)
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                MultipartEntity mpe = new MultipartEntity();
                for (EditedFileInfo editedFile : editedFiles) {
                    Patch patch;
                    List<String> previousDoc = fileVersions.get(editedFile.fileKey);
                    if (previousDoc == null) {
                        previousDoc = new ArrayList<String>();
                    }
                    if ((patch = DiffUtils.diff(previousDoc, editedFile.anonSource)).getDeltas().isEmpty() || this.isOneLineDiff(patch) && !editedFile.includeOneLineEdits) {
                        editedFile.dontSend = true;
                        continue;
                    }
                    String diff = DataCollectorImpl.makeDiff(patch);
                    DataCollectorImpl.addSourceHistoryItem(mpe, CollectUtility.toPath(projDetails, editedFile.path), editedFile.editType, diff, editedFile.generatedFrom == null ? null : CollectUtility.toPath(projDetails, editedFile.generatedFrom));
                    if (editedFile.strideEditReason == null || editedFile.strideEditReason.getText() == null) continue;
                    mpe.addPart("source_histories[][reason]", (ContentBody)CollectUtility.toBody(editedFile.strideEditReason.getText()));
                }
                if (editedFiles.stream().allMatch(f -> f.dontSend)) {
                    return null;
                }
                return mpe;
            }

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                for (EditedFileInfo editedFile : editedFiles) {
                    if (editedFile.dontSend) continue;
                    fileVersions.put(editedFile.fileKey, editedFile.anonSource);
                }
            }
        });
    }

    @OnThread(value=Tag.Any)
    protected static String makeDiff(Patch patch) {
        StringBuilder diff = new StringBuilder();
        for (Delta delta : patch.getDeltas()) {
            int destLine;
            int srcLine;
            int srcSize = delta.getOriginal().size();
            int destSize = delta.getRevised().size();
            if (srcSize > 0) {
                srcLine = delta.getOriginal().getPosition() + 1;
                destLine = delta.getRevised().getPosition() + 1;
            } else {
                srcLine = delta.getOriginal().getPosition();
                destLine = delta.getRevised().getPosition();
            }
            diff.append("@@ -" + srcLine + "," + srcSize + " +" + destLine + "," + destSize + " @@\n");
            for (String l : delta.getOriginal().getLines()) {
                diff.append("-" + l + "\n");
            }
            for (String l : delta.getRevised().getLines()) {
                diff.append("+" + l + "\n");
            }
        }
        return diff.toString();
    }

    public static void debuggerTerminate(Project project) {
        DataCollectorImpl.submitEventNoData(project, null, EventName.DEBUGGER_TERMINATE);
    }

    public static void debuggerChangeVisible(Project project, boolean newVis) {
        DataCollectorImpl.submitEventNoData(project, null, newVis ? EventName.DEBUGGER_OPEN : EventName.DEBUGGER_CLOSE);
    }

    public static void debuggerBreakpointToggle(Package pkg, File sourceFile, int lineNumber, boolean newState) {
        DataCollectorImpl.submitEventWithLocalLocation(pkg.getProject(), pkg, newState ? EventName.DEBUGGER_BREAKPOINT_ADD : EventName.DEBUGGER_BREAKPOINT_REMOVE, null, sourceFile, lineNumber);
    }

    public static void debuggerContinue(Project project, String threadName) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitEvent(project, null, EventName.DEBUGGER_CONTINUE, new PlainEvent(mpe));
    }

    public static void debuggerHalt(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_HALT, mpe, stack);
    }

    public static void debuggerStepInto(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_STEP_INTO, mpe, stack);
    }

    public static void debuggerStepOver(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_STEP_OVER, mpe, stack);
    }

    public static void debuggerHitBreakpoint(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_HIT_BREAKPOINT, mpe, stack);
    }

    public static void codePadSuccess(Package pkg, String command, String output) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[codepad][outcome]", (ContentBody)CollectUtility.toBody("success"));
        mpe.addPart("event[codepad][command]", (ContentBody)CollectUtility.toBody(command));
        mpe.addPart("event[codepad][result]", (ContentBody)CollectUtility.toBody(output));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CODEPAD, new PlainEvent(mpe));
    }

    public static void codePadError(Package pkg, String command, String error) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[codepad][outcome]", (ContentBody)CollectUtility.toBody("error"));
        mpe.addPart("event[codepad][command]", (ContentBody)CollectUtility.toBody(command));
        mpe.addPart("event[codepad][error]", (ContentBody)CollectUtility.toBody(error));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CODEPAD, new PlainEvent(mpe));
    }

    public static void codePadException(Package pkg, String command, String exception) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[codepad][outcome]", (ContentBody)CollectUtility.toBody("exception"));
        mpe.addPart("event[codepad][command]", (ContentBody)CollectUtility.toBody(command));
        mpe.addPart("event[codepad][exception]", (ContentBody)CollectUtility.toBody(exception));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CODEPAD, new PlainEvent(mpe));
    }

    public static void renamedClass(Package pkg, File oldFrameSourceFile, File newFrameSourceFile, File oldJavaSourceFile, File newJavaSourceFile) {
        String eventType = "rename";
        final CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(pkg.getProject());
        final boolean isFrameFile = newFrameSourceFile != null;
        final String oldFrameFilePath = isFrameFile ? CollectUtility.toPath(projDetails, oldFrameSourceFile) : null;
        final String newFrameFilePath = isFrameFile ? CollectUtility.toPath(projDetails, newFrameSourceFile) : null;
        final String oldJavaFilePath = CollectUtility.toPath(projDetails, oldJavaSourceFile);
        final String newJavaFilePath = CollectUtility.toPath(projDetails, newJavaSourceFile);
        MultipartEntity mpe = new MultipartEntity();
        if (isFrameFile) {
            DataCollectorImpl.addSourceHistoryItem(mpe, newFrameFilePath, "rename", oldFrameFilePath, null);
        }
        DataCollectorImpl.addSourceHistoryItem(mpe, newJavaFilePath, "rename", oldJavaFilePath, newFrameFilePath);
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.RENAME, new PlainEvent(mpe){

            @Override
            @OnThread(value=Tag.Worker)
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                if (isFrameFile) {
                    FileKey oldFrameKey = new FileKey(projDetails, oldFrameFilePath);
                    FileKey newFrameKey = new FileKey(projDetails, newFrameFilePath);
                    fileVersions.put(newFrameKey, fileVersions.get(oldFrameKey));
                    fileVersions.remove(oldFrameKey);
                }
                FileKey oldJavaKey = new FileKey(projDetails, oldJavaFilePath);
                FileKey newJavaKey = new FileKey(projDetails, newJavaFilePath);
                fileVersions.put(newJavaKey, fileVersions.get(oldJavaKey));
                fileVersions.remove(oldJavaKey);
                return super.makeData(sequenceNum, fileVersions);
            }
        });
    }

    public static void removeClass(Package pkg, File frameSourceFile, File javaSourceFile) {
        String eventType = "file_delete";
        final CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(pkg.getProject());
        final boolean isStrideFile = frameSourceFile != null;
        final String strideFilePath = isStrideFile ? CollectUtility.toPath(projDetails, frameSourceFile) : null;
        final String javaFilePath = CollectUtility.toPath(projDetails, javaSourceFile);
        MultipartEntity mpe = new MultipartEntity();
        if (isStrideFile) {
            DataCollectorImpl.addSourceHistoryItem(mpe, strideFilePath, "file_delete", null, null);
        }
        DataCollectorImpl.addSourceHistoryItem(mpe, javaFilePath, "file_delete", null, strideFilePath);
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.DELETE, new PlainEvent(mpe){

            @Override
            @OnThread(value=Tag.Worker)
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                if (isStrideFile) {
                    fileVersions.remove(new FileKey(projDetails, strideFilePath));
                }
                fileVersions.remove(new FileKey(projDetails, javaFilePath));
                return super.makeData(sequenceNum, fileVersions);
            }
        });
    }

    static void conversion(Package pkg, File javaSourceFile, File strideSourceFile, final boolean strideToJava) {
        String anonStride;
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(pkg.getProject());
        MultipartEntity mpe = new MultipartEntity();
        if (strideToJava) {
            DataCollectorImpl.addSourceHistoryItem(mpe, CollectUtility.toPath(projDetails, strideSourceFile), "file_delete", null, null);
            anonStride = null;
        } else {
            anonStride = CollectUtility.readFileAndAnonymise(projDetails, strideSourceFile);
            DataCollectorImpl.addSourceHistoryItem(mpe, CollectUtility.toPath(projDetails, strideSourceFile), "java_to_stride", anonStride, null);
            mpe.addPart("source_histories[][converted_from]", (ContentBody)CollectUtility.toBodyLocal(projDetails, javaSourceFile));
        }
        mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody(strideToJava ? "stride_to_java" : "diff_generated"));
        mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBodyLocal(projDetails, javaSourceFile));
        final List<String> anonJava = Arrays.asList(Utility.splitLines(CollectUtility.readFileAndAnonymise(projDetails, javaSourceFile)));
        if (strideToJava) {
            mpe.addPart("source_histories[][converted_from]", (ContentBody)CollectUtility.toBodyLocal(projDetails, strideSourceFile));
        } else {
            mpe.addPart("source_histories[][generated_from]", (ContentBody)CollectUtility.toBodyLocal(projDetails, strideSourceFile));
        }
        final FileKey strideFileKey = new FileKey(projDetails, CollectUtility.toPath(projDetails, strideSourceFile));
        final FileKey javaFileKey = new FileKey(projDetails, CollectUtility.toPath(projDetails, javaSourceFile));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, strideToJava ? EventName.CONVERT_STRIDE_TO_JAVA : EventName.CONVERT_JAVA_TO_STRIDE, new PlainEvent(mpe){

            @Override
            @OnThread(value=Tag.Worker)
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                List<String> previousDoc = fileVersions.get(javaFileKey);
                if (previousDoc == null) {
                    previousDoc = new ArrayList<String>();
                }
                MultipartEntity mpe = new MultipartEntity();
                Patch patch = DiffUtils.diff(previousDoc, (List)anonJava);
                String diff = DataCollectorImpl.makeDiff(patch);
                mpe.addPart("source_histories[][content]", (ContentBody)CollectUtility.toBody(diff));
                fileVersions.put(javaFileKey, anonJava);
                if (strideToJava) {
                    fileVersions.remove(strideFileKey);
                } else {
                    fileVersions.put(strideFileKey, Arrays.asList(Utility.splitLines(anonStride)));
                }
                return super.makeData(sequenceNum, fileVersions);
            }
        });
    }

    public static void addClass(Package pkg, ClassTarget ct) {
        DataCollectorImpl.addCompleteFiles(pkg, EventName.ADD, Collections.singletonList(ct), null);
    }

    public static void openClass(Package pkg, File sourceFile) {
        DataCollectorImpl.classEvent(pkg, sourceFile, EventName.FILE_OPEN);
    }

    public static void closeClass(Package pkg, File sourceFile) {
        DataCollectorImpl.classEvent(pkg, sourceFile, EventName.FILE_CLOSE);
    }

    public static void selectClass(Package pkg, File sourceFile) {
        DataCollectorImpl.classEvent(pkg, sourceFile, EventName.FILE_SELECT);
    }

    private static void classEvent(Package pkg, File sourceFile, EventName eventName) {
        MultipartEntity mpe = new MultipartEntity();
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(pkg.getProject());
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(projDetails, sourceFile));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, eventName, new PlainEvent(mpe));
    }

    public static void teamShareProject(Project project, Repository repo) {
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_SHARE, new PlainEvent(DataCollectorImpl.getRepoMPE(repo)));
    }

    public static void teamPushProject(Project project, Repository repo, Collection<File> pushedFiles) {
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(project);
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (File f : pushedFiles) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(projDetails, f));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_PUSH, new PlainEvent(mpe));
    }

    public static void teamCommitProject(Project project, Repository repo, Collection<File> committedFiles) {
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(project);
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (File f : committedFiles) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(projDetails, f));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_COMMIT, new PlainEvent(mpe));
    }

    public static void teamUpdateProject(Project project, Repository repo, Collection<File> updatedFiles) {
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(project);
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (File f : updatedFiles) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(projDetails, f));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_UPDATE, new PlainEvent(mpe));
    }

    public static void teamStatusProject(Project project, Repository repo, Map<File, String> status) {
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(project);
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (Map.Entry<File, String> s : status.entrySet()) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(projDetails, s.getKey()));
            mpe.addPart("vcs_files[][status]", (ContentBody)CollectUtility.toBody(s.getValue()));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_STATUS, new PlainEvent(mpe));
    }

    public static void teamHistoryProject(Project project, Repository repo) {
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_HISTORY, new PlainEvent(DataCollectorImpl.getRepoMPE(repo)));
    }

    public static void showHideTerminal(Project project, boolean show) {
        DataCollectorImpl.submitEventNoData(project, null, show ? EventName.TERMINAL_OPEN : EventName.TERMINAL_CLOSE);
    }

    public static void invokeCompileError(Package pkg, String code, String compilationError) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("compile_error"));
        mpe.addPart("event[invoke][compile_error]", (ContentBody)CollectUtility.toBody(compilationError));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void invokeMethodSuccess(Package pkg, String code, String objName, String typeName, int testIdentifier, int invocationIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][type_name]", (ContentBody)CollectUtility.toBody(typeName));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("success"));
        mpe.addPart("event[invoke][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        mpe.addPart("event[invoke][invoke_identifier]", (ContentBody)CollectUtility.toBody(invocationIdentifier));
        if (objName != null) {
            mpe.addPart("event[invoke][bench_object][class_name]", (ContentBody)CollectUtility.toBody(typeName));
            mpe.addPart("event[invoke][bench_object][name]", (ContentBody)CollectUtility.toBody(objName));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void invokeMethodException(Package pkg, String code, ExceptionDescription ed) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("exception"));
        mpe.addPart("event[invoke][exception_class]", (ContentBody)CollectUtility.toBody(ed.getClassName()));
        mpe.addPart("event[invoke][exception_message]", (ContentBody)CollectUtility.toBody(ed.getText()));
        DataCollectorImpl.addStackTrace(mpe, "event[invoke][exception_stack]", ed.getStack().toArray(new SourceLocation[0]));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void invokeMethodTerminated(Package pkg, String code) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("terminated"));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void removeObject(Package pkg, String name) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[object_name]", (ContentBody)CollectUtility.toBody(name));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.REMOVE_OBJECT, new PlainEvent(mpe));
    }

    public static void inspectorClassShow(Project proj, Package pkg, Inspector inspector, String className) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[inspect][unique]", (ContentBody)CollectUtility.toBody(inspector.getUniqueId()));
        mpe.addPart("event[inspect][static_class]", (ContentBody)CollectUtility.toBody(className));
        inspectorPackages.put(inspector, pkg);
        DataCollectorImpl.submitEvent(proj, pkg, EventName.INSPECTOR_SHOW, new PlainEvent(mpe));
    }

    public static void inspectorObjectShow(Package pkg, Inspector inspector, String benchName, String className, String displayName) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[inspect][unique]", (ContentBody)CollectUtility.toBody(inspector.getUniqueId()));
        mpe.addPart("event[inspect][display_name]", (ContentBody)CollectUtility.toBody(displayName));
        mpe.addPart("event[inspect][class_name]", (ContentBody)CollectUtility.toBody(className));
        if (benchName != null) {
            mpe.addPart("event[inspect][bench_object_name]", (ContentBody)CollectUtility.toBody(benchName));
        }
        inspectorPackages.put(inspector, pkg);
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INSPECTOR_SHOW, new PlainEvent(mpe));
    }

    public static void inspectorHide(Project project, Inspector inspector) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[inspect][unique]", (ContentBody)CollectUtility.toBody(inspector.getUniqueId()));
        if (inspector instanceof ClassInspector || inspector instanceof ObjectInspector) {
            DataCollectorImpl.submitEvent(project, inspectorPackages.get((Object)inspector), EventName.INSPECTOR_HIDE, new PlainEvent(mpe));
        }
    }

    public static void benchGet(Package pkg, String benchName, String typeName, int testIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[bench_object][class_name]", (ContentBody)CollectUtility.toBody(typeName));
        mpe.addPart("event[bench_object][name]", (ContentBody)CollectUtility.toBody(benchName));
        mpe.addPart("event[test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.BENCH_GET, new PlainEvent(mpe));
    }

    public static void startTestMethod(Package pkg, int testIdentifier, File sourceFile, String testName) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[test][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        mpe.addPart("event[test][source_file]", (ContentBody)CollectUtility.toBodyLocal(new CollectUtility.ProjectDetails(pkg.getProject()), sourceFile));
        mpe.addPart("event[test][method_name]", (ContentBody)CollectUtility.toBody(testName));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.START_TEST, new PlainEvent(mpe));
    }

    public static void cancelTestMethod(Package pkg, int testIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[test][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CANCEL_TEST, new PlainEvent(mpe));
    }

    public static void endTestMethod(Package pkg, int testIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[test][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.END_TEST, new PlainEvent(mpe));
    }

    public static void assertTestMethod(Package pkg, int testIdentifier, int invocationIdentifier, String assertion, String param1, String param2) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[assert][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        mpe.addPart("event[assert][invoke_identifier]", (ContentBody)CollectUtility.toBody(invocationIdentifier));
        mpe.addPart("event[assert][assertion]", (ContentBody)CollectUtility.toBody(assertion));
        mpe.addPart("event[assert][param1]", (ContentBody)CollectUtility.toBody(param1));
        mpe.addPart("event[assert][param2]", (ContentBody)CollectUtility.toBody(param2));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.ASSERTION, new PlainEvent(mpe));
    }

    public static void objectBenchToFixture(Package pkg, File sourceFile, List<String> benchNames) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(new CollectUtility.ProjectDetails(pkg.getProject()), sourceFile));
        for (String name : benchNames) {
            mpe.addPart("event[bench_objects][][name]", (ContentBody)CollectUtility.toBody(name));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.BENCH_TO_FIXTURE, new PlainEvent(mpe));
    }

    public static void fixtureToObjectBench(Package pkg, File sourceFile, List<DataCollector.NamedTyped> objects) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(new CollectUtility.ProjectDetails(pkg.getProject()), sourceFile));
        for (DataCollector.NamedTyped obj : objects) {
            mpe.addPart("event[bench_objects][][name]", (ContentBody)CollectUtility.toBody(obj.getName()));
            mpe.addPart("event[bench_objects][][class_name]", (ContentBody)CollectUtility.toBody(obj.getType()));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.FIXTURE_TO_BENCH, new PlainEvent(mpe));
    }

    public static void testResult(Package pkg, DebuggerTestResult lastResult) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[class_name]", (ContentBody)CollectUtility.toBody(lastResult.getQualifiedClassName()));
        mpe.addPart("event[method_name]", (ContentBody)CollectUtility.toBody(lastResult.getMethodName()));
        mpe.addPart("event[run_time]", (ContentBody)CollectUtility.toBody(lastResult.getRunTimeMs()));
        String status = "unknown";
        if (lastResult.isSuccess()) {
            status = "success";
        } else if (lastResult.isFailure()) {
            status = "failure";
        } else if (lastResult.isError()) {
            status = "error";
        }
        mpe.addPart("event[result]", (ContentBody)CollectUtility.toBody(status));
        if (!lastResult.isSuccess()) {
            mpe.addPart("event[exception_message]", (ContentBody)CollectUtility.toBody(lastResult.getExceptionMessage()));
            mpe.addPart("event[exception_trace]", (ContentBody)CollectUtility.toBody(lastResult.getTrace()));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.RUN_TEST, new PlainEvent(mpe));
    }

    private static void addStackTrace(MultipartEntity mpe, String listName, SourceLocation[] stack) {
        for (int i = 0; i < stack.length; ++i) {
            mpe.addPart(listName + "[][entry]", (ContentBody)CollectUtility.toBody(i));
            mpe.addPart(listName + "[][class_name]", (ContentBody)CollectUtility.toBody(stack[i].getClassName()));
            mpe.addPart(listName + "[][class_source_name]", (ContentBody)CollectUtility.toBody(stack[i].getFileName()));
            mpe.addPart(listName + "[][line_number]", (ContentBody)CollectUtility.toBody(stack[i].getLineNumber()));
        }
    }

    private static MultipartEntity getRepoMPE(Repository repo) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[vcs][vcs_type]", (ContentBody)CollectUtility.toBody(repo.getVCSType()));
        mpe.addPart("event[vcs][protocol]", (ContentBody)CollectUtility.toBody(repo.getVCSProtocol()));
        return mpe;
    }

    public static void showErrorIndicators(Package pkg, Collection<Integer> errorIdentifiers) {
        MultipartEntity mpe = new MultipartEntity();
        if (errorIdentifiers.isEmpty()) {
            return;
        }
        for (Integer errorIdentifier : errorIdentifiers) {
            mpe.addPart("event[error_sequences][]", (ContentBody)CollectUtility.toBody(errorIdentifier));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.SHOWN_ERROR_INDICATOR, new PlainEvent(mpe));
    }

    public static void showErrorMessage(Package pkg, int errorIdentifier, List<String> quickFixes) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[error_sequence]", (ContentBody)CollectUtility.toBody(errorIdentifier));
        if (quickFixes != null && !quickFixes.isEmpty()) {
            quickFixes.forEach(fix -> mpe.addPart("event[quick_fixes][][text]", (ContentBody)CollectUtility.toBody(fix)));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.SHOWN_ERROR_MESSAGE, new PlainEvent(mpe));
    }

    public static void fixExecuted(Package pkg, int errorIdentifier, int fixIndex) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[error_sequence]", (ContentBody)CollectUtility.toBody(errorIdentifier));
        mpe.addPart("event[fix_order]", (ContentBody)CollectUtility.toBody(fixIndex));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.FIX_EXECUTED, new PlainEvent(mpe));
    }

    public static void greenfootEvent(Project project, Package pkg, GreenfootInterfaceEvent greenfootEvent) {
        MultipartEntity mpe = new MultipartEntity();
        EventName event = null;
        switch (greenfootEvent) {
            case WINDOW_ACTIVATED: {
                event = EventName.GREENFOOT_WINDOW_ACTIVATED;
                break;
            }
            case WORLD_RESET: {
                event = EventName.GREENFOOT_WORLD_RESET;
                break;
            }
            case WORLD_ACT: {
                event = EventName.GREENFOOT_WORLD_ACT;
                break;
            }
            case WORLD_RUN: {
                event = EventName.GREENFOOT_WORLD_RUN;
                break;
            }
            case WORLD_PAUSE: {
                event = EventName.GREENFOOT_WORLD_PAUSE;
            }
        }
        if (event != null) {
            DataCollectorImpl.submitEvent(project, pkg, event, new PlainEvent(mpe));
        }
    }

    public static void codeCompletionStarted(Project project, Package pkg, Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex, String stem, int codeCompletionId) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[code_completion][trigger]", (ContentBody)CollectUtility.toBody("start"));
        mpe.addPart("event[code_completion][completion_sequence]", (ContentBody)CollectUtility.toBody(codeCompletionId));
        DataCollectorImpl.addCodeCompletionLocation(mpe, lineNumber, columnNumber, xpath, subIndex);
        if (stem != null) {
            mpe.addPart("event[code_completion][stem]", (ContentBody)CollectUtility.toBody(stem));
        }
        DataCollectorImpl.submitEvent(project, pkg, EventName.CODE_COMPLETION_STARTED, new PlainEvent(mpe));
    }

    public static void codeCompletionEnded(Project project, Package pkg, Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex, String stem, String replacement, int codeCompletionId) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[code_completion][trigger]", (ContentBody)CollectUtility.toBody("selected"));
        mpe.addPart("event[code_completion][completion_sequence]", (ContentBody)CollectUtility.toBody(codeCompletionId));
        DataCollectorImpl.addCodeCompletionLocation(mpe, lineNumber, columnNumber, xpath, subIndex);
        if (stem != null) {
            mpe.addPart("event[code_completion][stem]", (ContentBody)CollectUtility.toBody(stem));
        }
        if (replacement != null) {
            mpe.addPart("event[code_completion][replacement]", (ContentBody)CollectUtility.toBody(replacement));
        }
        DataCollectorImpl.submitEvent(project, pkg, EventName.CODE_COMPLETION_ENDED, new PlainEvent(mpe));
    }

    private static void addCodeCompletionLocation(MultipartEntity mpe, Integer lineNumber, Integer columnNumber, String xpath, Integer subIndex) {
        if (lineNumber != null) {
            mpe.addPart("event[code_completion][line_number]", (ContentBody)CollectUtility.toBody(lineNumber));
        }
        if (columnNumber != null) {
            mpe.addPart("event[code_completion][column_number]", (ContentBody)CollectUtility.toBody(columnNumber));
        }
        if (xpath != null) {
            mpe.addPart("event[code_completion][xpath]", (ContentBody)CollectUtility.toBody(xpath));
        }
        if (subIndex != null) {
            mpe.addPart("event[code_completion][xml_index]", (ContentBody)CollectUtility.toBody(subIndex));
        }
    }

    public static void unknownFrameCommandKey(Project project, Package pkg, String enclosingFrameXpath, int cursorIndex, char key) {
        MultipartEntity mpe = new MultipartEntity();
        if (enclosingFrameXpath != null) {
            mpe.addPart("event[unknown_frame_command][enclosing_xpath]", (ContentBody)CollectUtility.toBody(enclosingFrameXpath));
            mpe.addPart("event[unknown_frame_command][enclosing_index]", (ContentBody)CollectUtility.toBody(cursorIndex));
        }
        mpe.addPart("event[unknown_frame_command][command]", (ContentBody)CollectUtility.toBody(Character.toString(key)));
        DataCollectorImpl.submitEvent(project, pkg, EventName.UNKNOWN_FRAME_COMMAND, new PlainEvent(mpe));
    }

    public static void showHideFrameCatalogue(Project project, Package pkg, String enclosingFrameXpath, int cursorIndex, boolean show, FrameCatalogue.ShowReason reason) {
        MultipartEntity mpe = new MultipartEntity();
        if (enclosingFrameXpath != null) {
            mpe.addPart("event[frame_catalogue_showing][enclosing_xpath]", (ContentBody)CollectUtility.toBody(enclosingFrameXpath));
            mpe.addPart("event[frame_catalogue_showing][enclosing_index]", (ContentBody)CollectUtility.toBody(cursorIndex));
        }
        mpe.addPart("event[frame_catalogue_showing][show]", (ContentBody)CollectUtility.toBody(show));
        mpe.addPart("event[frame_catalogue_showing][reason]", (ContentBody)CollectUtility.toBody(reason.getText()));
        DataCollectorImpl.submitEvent(project, pkg, EventName.FRAME_CATALOGUE_SHOWING, new PlainEvent(mpe));
    }

    public static void viewModeChange(Project project, Package pkg, File sourceFile, String enclosingFrameXpath, int cursorIndex, Frame.View oldView, Frame.View newView, Frame.ViewChangeReason reason) {
        MultipartEntity mpe = new MultipartEntity();
        CollectUtility.ProjectDetails projDetails = new CollectUtility.ProjectDetails(pkg.getProject());
        mpe.addPart("event[view_mode_change][source_file_name]", (ContentBody)CollectUtility.toBodyLocal(projDetails, sourceFile));
        if (enclosingFrameXpath != null) {
            mpe.addPart("event[view_mode_change][enclosing_xpath]", (ContentBody)CollectUtility.toBody(enclosingFrameXpath));
            mpe.addPart("event[view_mode_change][enclosing_index]", (ContentBody)CollectUtility.toBody(cursorIndex));
        }
        mpe.addPart("event[view_mode_change][old_view]", (ContentBody)CollectUtility.toBody(oldView.getText()));
        mpe.addPart("event[view_mode_change][new_view]", (ContentBody)CollectUtility.toBody(newView.getText()));
        mpe.addPart("event[view_mode_change][reason]", (ContentBody)CollectUtility.toBody(reason.getText()));
        DataCollectorImpl.submitEvent(project, pkg, EventName.VIEW_MODE_CHANGE, new PlainEvent(mpe));
    }

    static class EditedFileInfo {
        private final String editType;
        private final File path;
        private final String source;
        private final boolean includeOneLineEdits;
        private final File generatedFrom;
        private final StrideEditReason strideEditReason;
        private FileKey fileKey;
        private List<String> anonSource;
        public boolean dontSend = false;

        EditedFileInfo(String editType, File path, String source, boolean includeOneLineEdits, File generatedFrom, StrideEditReason strideEditReason) {
            this.editType = editType;
            this.path = path;
            this.source = source;
            this.includeOneLineEdits = includeOneLineEdits;
            this.generatedFrom = generatedFrom;
            this.strideEditReason = strideEditReason;
        }
    }
}

