/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.collect.CodeAnonymiser;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.http.entity.mime.content.StringBody;
import threadchecker.OnThread;
import threadchecker.Tag;

class CollectUtility {
    private static final Charset utf8 = Charset.forName("UTF-8");

    CollectUtility() {
    }

    @OnThread(value=Tag.FXPlatform)
    static String readFileAndAnonymise(ProjectDetails proj, File f) {
        try {
            StringBuilder sb = new StringBuilder();
            FileInputStream inputStream = new FileInputStream(f);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, proj.charset);
            char[] buf = new char[4096];
            int read = reader.read(buf);
            while (read != -1) {
                sb.append(buf, 0, read);
                read = reader.read(buf);
            }
            reader.close();
            inputStream.close();
            return CodeAnonymiser.anonymise(sb.toString());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    static String toPath(ProjectDetails proj, File f) {
        return proj.projectDir.toURI().relativize(f.toURI()).getPath();
    }

    static StringBody toBodyLocal(ProjectDetails project, File sourceFile) {
        return CollectUtility.toBody(CollectUtility.toPath(project, sourceFile));
    }

    static String md5Hash(String src) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(src.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            Debug.reportError(e);
            return "";
        }
        catch (UnsupportedEncodingException e) {
            Debug.reportError(e);
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (byte b : hash) {
            s.append(String.format("%02X", b));
        }
        return s.toString();
    }

    static StringBody toBody(String s) {
        try {
            return new StringBody(s == null ? "" : s, utf8);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    static StringBody toBody(int i) {
        return CollectUtility.toBody(Integer.toString(i));
    }

    static StringBody toBody(long l) {
        return CollectUtility.toBody(Long.toString(l));
    }

    static StringBody toBody(boolean b) {
        return CollectUtility.toBody(Boolean.toString(b));
    }

    static class ProjectDetails {
        final Charset charset;
        final File projectDir;

        @OnThread(value=Tag.FXPlatform)
        ProjectDetails(Project project) {
            this.projectDir = project.getProjectDir();
            this.charset = project.getProjectCharset();
        }
    }
}

