/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import bluej.classmgr.ClassPathEntry;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgrDialog;
import bluej.prefmgr.PrefPanelListener;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import bluej.utility.javafx.NoMultipleSelectionModel;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.FXPlatform)
public class ClassMgrPrefPanel
extends VBox
implements PrefPanelListener {
    private static final String userlibPrefix = "bluej.userlibrary";
    private static @OnThread(value=Tag.Any, requireSynchronized=true) List<ClassPathEntry> savedUserLibraries = null;
    private ListView<ClassPathEntry> userLibrariesListView = null;
    private ObservableList<ClassPathEntry> editingUserLibraries;
    private boolean classPathModified = false;

    public ClassMgrPrefPanel() {
        JavaFXUtil.addStyleClass((Styleable)this, "prefmgr-pref-panel", "prefmgr-library-panel");
        ClassMgrPrefPanel.loadSavedUserLibraries();
        List userlibExtLibrariesList = Project.getUserlibContent().stream().map(url -> {
            try {
                return new ClassPathEntry(new File(url.toURI()), "");
            }
            catch (URISyntaxException e) {
                return null;
            }
        }).filter(f -> f != null).distinct().collect(Collectors.toList());
        BorderPane userLibPane = new BorderPane();
        JavaFXUtil.addStyleClass((Styleable)userLibPane, "prefmgr-library-userlib-hbox");
        this.editingUserLibraries = FXCollections.observableArrayList();
        this.editingUserLibraries.setAll(savedUserLibraries);
        this.userLibrariesListView = this.makeClassPathEntryListView(this.editingUserLibraries);
        this.userLibrariesListView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        VBox buttonPane = new VBox();
        JavaFXUtil.addStyleClass((Styleable)buttonPane, "prefmgr-library-userlib-buttons");
        Button addFileButton = new Button(Config.getString("classmgr.addFile"));
        addFileButton.setOnAction(e -> this.addUserLibraryFile());
        Button deleteButton = new Button(Config.getString("classmgr.delete"));
        deleteButton.setOnAction(e -> this.deleteUserLibrary());
        deleteButton.disableProperty().bind((ObservableValue)this.userLibrariesListView.getSelectionModel().selectedItemProperty().isNull());
        buttonPane.getChildren().addAll((Object[])new Node[]{addFileButton, deleteButton});
        userLibPane.setCenter(this.userLibrariesListView);
        userLibPane.setRight((Node)buttonPane);
        ListView userlibExtLibrariesListView = this.makeClassPathEntryListView((ObservableList<ClassPathEntry>)FXCollections.observableArrayList(userlibExtLibrariesList));
        userlibExtLibrariesListView.setSelectionModel(new NoMultipleSelectionModel());
        userlibExtLibrariesListView.setFocusTraversable(false);
        String userlibLocation = Config.getString("classmgr.userliblibraries") + " " + Config.getBlueJLibDir() + File.separator + "userlib";
        this.getChildren().add((Object)PrefMgrDialog.headedVBox("classmgr.userlibraries", Arrays.asList(userLibPane)));
        this.getChildren().add((Object)PrefMgrDialog.headedVBoxTranslated(userlibLocation, Arrays.asList(userlibExtLibrariesListView)));
    }

    @OnThread(value=Tag.Any)
    private static synchronized void loadSavedUserLibraries() {
        if (savedUserLibraries == null) {
            savedUserLibraries = new ArrayList<ClassPathEntry>();
            ClassMgrPrefPanel.addConfigEntries(savedUserLibraries, userlibPrefix);
        }
    }

    private ListView makeClassPathEntryListView(ObservableList<ClassPathEntry> userlibExtLibrariesList) {
        ListView userlibExtLibrariesListView = new ListView(userlibExtLibrariesList);
        JavaFXUtil.addStyleClass((Styleable)userlibExtLibrariesListView, "prefmgr-library-listview");
        userlibExtLibrariesListView.setCellFactory(lv -> new TextFieldListCell((StringConverter)new StringConverter<ClassPathEntry>(){

            public ClassPathEntry fromString(String string) {
                return null;
            }

            public String toString(ClassPathEntry cpe) {
                return cpe.getCanonicalPathNoException() + " (" + cpe.getStatusString() + ")";
            }
        }));
        userlibExtLibrariesListView.setEditable(false);
        return userlibExtLibrariesListView;
    }

    @OnThread(value=Tag.Any)
    public static synchronized List<URL> getUserConfigContent() {
        ClassMgrPrefPanel.loadSavedUserLibraries();
        return Utility.mapList(savedUserLibraries, ClassPathEntry::safeGetURL);
    }

    @OnThread(value=Tag.Any)
    private static void addConfigEntries(List<ClassPathEntry> cp, String prefix) {
        int resourceID = 1;
        try {
            String location;
            while ((location = Config.getPropString(prefix + resourceID + ".location", null)) != null) {
                try {
                    StringTokenizer st = new StringTokenizer(location, File.pathSeparator);
                    while (st.hasMoreTokens()) {
                        String entry = st.nextToken();
                        ClassPathEntry cpentry = new ClassPathEntry(entry, "");
                        if (cp.contains(cpentry)) continue;
                        cp.add(cpentry);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++resourceID;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    @Override
    public void beginEditing(Project project) {
    }

    @Override
    public synchronized void revertEditing(Project project) {
        this.editingUserLibraries.setAll(savedUserLibraries);
    }

    @Override
    public void commitEditing(Project project) {
        if (this.classPathModified) {
            DialogManager.showMessageFX(null, "classmgr-changes-no-effect", new String[0]);
            this.classPathModified = false;
        }
        this.saveUserLibraries();
    }

    private synchronized void saveUserLibraries() {
        String r1;
        savedUserLibraries.clear();
        savedUserLibraries.addAll((Collection<ClassPathEntry>)this.editingUserLibraries);
        int resourceID = 1;
        while ((r1 = Config.removeProperty(userlibPrefix + resourceID + ".location")) != null) {
            ++resourceID;
        }
        Iterator<ClassPathEntry> it = savedUserLibraries.iterator();
        resourceID = 1;
        while (it.hasNext()) {
            ClassPathEntry nextEntry = it.next();
            Config.putPropString(userlibPrefix + resourceID + ".location", nextEntry.getPath());
            ++resourceID;
        }
    }

    private void addUserLibraryFile() {
        List<File> files = FileUtility.getOpenFilesFX(this.getScene().getWindow(), Config.getString("prefmgr.misc.addLibTitle"), Arrays.asList(new FileChooser.ExtensionFilter(Config.getString("prefmgr.misc.libFileFilter"), new String[]{"*.zip", "*.jar"})), false);
        if (files != null) {
            for (File file : files) {
                this.editingUserLibraries.add((Object)new ClassPathEntry(file.getAbsolutePath(), "", true));
            }
            this.classPathModified = true;
        }
    }

    private void deleteUserLibrary() {
        int which = this.userLibrariesListView.getSelectionModel().getSelectedIndex();
        if (which != -1) {
            this.classPathModified = true;
            this.editingUserLibraries.remove(which);
        }
    }
}

