/*
 * Decompiled with CFR 0.152.
 */
package bluej;

import bluej.BlueJPropStringSource;
import bluej.Boot;
import bluej.PropParser;
import bluej.stride.generic.InteractionManager;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.utility.javafx.JavaFXUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Polygon;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import threadchecker.OnThread;
import threadchecker.Tag;

public final class Config {
    public static final String nl = System.getProperty("line.separator");
    public static final String osname = System.getProperty("os.name", "");
    public static final String DEFAULT_LANGUAGE = "english";
    public static final String BLUEJ_OPENPACKAGE = "bluej.openPackage";
    public static final String bluejDebugLogName = "bluej-debuglog.txt";
    public static final String greenfootDebugLogName = "greenfoot-debuglog.txt";
    public static final KeyCodeCombination GREENFOOT_SET_PLAYER_NAME_SHORTCUT = new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN});
    private static final String BLUEJ_DEBUG_DOCK_ICON = "vm.icns";
    private static final String GREENFOOT_DEBUG_DOCK_ICON = "greenfootvm.icns";
    private static final String BLUEJ_DEBUG_DOCK_NAME = "BlueJ Virtual Machine";
    private static final String GREENFOOT_DEBUG_DOCK_NAME = "Greenfoot";
    public static Properties moeSystemProps;
    public static Properties moeUserProps;
    private static final Map<String, BooleanProperty> booleanProperties;
    public static String language;
    public static Rectangle screenBounds;
    public static String debugLogName;
    public static List<String> fontOptions;
    private static Border focusBorder;
    private static Border normalBorder;
    private static Properties systemProps;
    private static Properties userProps;
    private static Properties greenfootProps;
    private static Properties commandProps;
    private static Properties initialCommandLineProps;
    private static Properties langProps;
    private static Properties langVarProps;
    private static File bluejLibDir;
    private static File userPrefDir;
    private static File templateDir;
    private static File greenfootLibDir;
    private static boolean initialised;
    private static boolean isGreenfoot;
    private static List<String> debugVMArgs;
    private static boolean isDebugVm;
    public static final String EDITOR_COUNT_JAVA = "session.numeditors.java";
    public static final String EDITOR_COUNT_STRIDE = "session.numeditors.stride";
    public static final String MESSAGE_LATEST_SEEN = "bluej.latest.msg";
    private static long MAX_DEBUG_LOG_SIZE;

    public static void initialise(File bluejLibDir, Properties tempCommandLineProps, boolean bootingGreenfoot) {
        Config.initialise(bluejLibDir, tempCommandLineProps, bootingGreenfoot, true);
        Config.initDebugVMArgs();
    }

    private static void initialise(File bluejLibDir, Properties tempCommandLineProps, boolean bootingGreenfoot, boolean createUserhome) {
        if (initialised) {
            return;
        }
        initialised = true;
        initialCommandLineProps = tempCommandLineProps;
        isGreenfoot = bootingGreenfoot;
        screenBounds = Config.calculateScreenBounds();
        Config.bluejLibDir = bluejLibDir;
        greenfootLibDir = new File(bluejLibDir, "greenfoot");
        if (systemProps == null) {
            isDebugVm = false;
            systemProps = Config.loadDefs("bluej.defs", System.getProperties());
            if (Config.isGreenfoot()) {
                greenfootProps = Config.loadDefs("greenfoot.defs", systemProps);
                userProps = new Properties(greenfootProps);
            } else {
                userProps = new Properties(systemProps);
            }
        }
        commandProps = new Properties(userProps);
        commandProps.putAll((Map<?, ?>)tempCommandLineProps);
        commandProps.setProperty("bluej.libdir", bluejLibDir.getAbsolutePath());
        if (createUserhome) {
            Config.initUserHome();
            Config.loadProperties(Config.getApplicationName().toLowerCase(), userProps);
            if (isGreenfoot) {
                debugLogName = greenfootDebugLogName;
            }
            Config.checkDebug(userPrefDir);
        }
        Config.initLanguage();
        moeSystemProps = Config.loadDefs("moe.defs", System.getProperties());
        moeUserProps = new Properties(moeSystemProps);
        Config.loadProperties("moe", moeUserProps);
        String macOSscreenMenuBar = Config.getPropString("bluej.macos.screenmenubar", "true");
        System.setProperty("apple.laf.useScreenMenuBar", macOSscreenMenuBar);
        Config.setVMLocale();
        commandProps.setProperty("bluej.version", "4.2.2");
    }

    private static void initLanguage() {
        language = commandProps.getProperty("bluej.language", null);
        if (language == null) {
            language = DEFAULT_LANGUAGE;
            try {
                String langString;
                String iso3lang = Locale.getDefault().getISO3Language();
                int i = 1;
                while ((langString = Config.getPropString("bluej.language" + i, null)) != null) {
                    int secondColon;
                    int colonIndex = langString.indexOf(58);
                    if (colonIndex != -1 && (secondColon = langString.indexOf(58, colonIndex + 1)) != -1 && langString.substring(secondColon + 1).equals(iso3lang)) {
                        language = langString.substring(0, colonIndex);
                        Config.putPropString("bluej.language", language);
                        break;
                    }
                    ++i;
                }
                Debug.log("Detected language \"" + language + "\" based on iso639-2 code \"" + iso3lang + "\"");
            }
            catch (MissingResourceException mre) {
                Debug.log("Using default language \"" + language + "\"");
            }
        }
        langProps = Config.loadLanguageLabels(language);
    }

    private static void initUserHome() {
        String propertyName;
        String homeDir = Config.getPropString("bluej.userHome", "$user.home");
        File userHome = new File(homeDir);
        String prefDirName = Config.getBlueJPrefDirName();
        userPrefDir = new File(userHome, prefDirName);
        int nameCounter = 1;
        while (!(userPrefDir.isDirectory() ? userPrefDir.canWrite() : userPrefDir.mkdirs()) && (homeDir = Config.getPropString(propertyName = "bluej.userHome" + ++nameCounter, null)) != null) {
            userHome = new File(homeDir);
            userPrefDir = new File(userHome, prefDirName);
        }
        if (homeDir == null) {
            homeDir = System.getProperty("user.home");
            userHome = new File(homeDir);
            userPrefDir = new File(userHome, prefDirName);
        }
    }

    public static void initializeVMside(File bluejLibDir, File userConfigDir, final BlueJPropStringSource propSource) {
        isDebugVm = true;
        userPrefDir = userConfigDir;
        systemProps = new Properties(){

            @Override
            public String getProperty(String key) {
                return propSource.getBlueJPropertyString(key, null);
            }

            @Override
            public String getProperty(String key, String def) {
                return propSource.getBlueJPropertyString(key, def);
            }
        };
        userProps = new Properties(systemProps){

            @Override
            public synchronized Object setProperty(String key, String val) {
                Debug.printCallStack("Internal error: setting user property on debug VM");
                return null;
            }

            @Override
            public String getProperty(String key) {
                return propSource.getBlueJPropertyString(key, null);
            }

            @Override
            public String getProperty(String key, String def) {
                return propSource.getBlueJPropertyString(key, def);
            }
        };
        Config.initialise(bluejLibDir, new Properties(), true, false);
    }

    public static Properties getInitialCommandLineProperties() {
        return initialCommandLineProps;
    }

    public static void initializeStandalone(final BlueJPropStringSource propSource) {
        if (initialised) {
            return;
        }
        initialised = true;
        isGreenfoot = true;
        commandProps = langProps = new Properties(){

            @Override
            public String getProperty(String key) {
                return propSource.getLabel(key);
            }

            @Override
            public String getProperty(String key, String def) {
                return propSource.getLabel(key);
            }
        };
    }

    public static boolean isInitialised() {
        return initialised;
    }

    public static String getVMIconsName() {
        if (Config.isGreenfoot()) {
            return GREENFOOT_DEBUG_DOCK_ICON;
        }
        return BLUEJ_DEBUG_DOCK_ICON;
    }

    public static String getVMDockName() {
        if (Config.isGreenfoot()) {
            return GREENFOOT_DEBUG_DOCK_NAME;
        }
        return BLUEJ_DEBUG_DOCK_NAME;
    }

    public static boolean isDebugVM() {
        return isDebugVm;
    }

    public static boolean isMacOS() {
        return osname.startsWith("Mac");
    }

    private static boolean osVersionNumberAtLeast(int ... target) {
        return Config.versionAtLeast(System.getProperty("os.version"), target);
    }

    private static boolean javaVersionNumberAtLeast(int ... target) {
        return Config.versionAtLeast(System.getProperty("java.specification.version"), target);
    }

    private static boolean versionAtLeast(String version, int[] target) {
        String[] versionChunks = version.split("\\.");
        for (int i = 0; i < target.length; ++i) {
            if (versionChunks.length <= i) {
                return false;
            }
            if (target[i] < Integer.parseInt(versionChunks[i])) {
                return true;
            }
            if (target[i] <= Integer.parseInt(versionChunks[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isMacOSLeopard() {
        return osname.startsWith("Mac") && Config.osVersionNumberAtLeast(10, 5);
    }

    public static boolean isMacOSSnowLeopard() {
        return osname.startsWith("Mac") && Config.osVersionNumberAtLeast(10, 6);
    }

    public static boolean isWinOS() {
        return osname.startsWith("Windows");
    }

    public static boolean isModernWinOS() {
        return Config.isWinOS() && Config.osVersionNumberAtLeast(6, 0);
    }

    public static boolean isLinux() {
        return osname.startsWith("Linux");
    }

    public static boolean isSolaris() {
        return osname.startsWith("Solaris");
    }

    public static boolean isJava17() {
        return Config.javaVersionNumberAtLeast(1, 7);
    }

    public static boolean isOpenJDK() {
        return System.getProperty("java.runtime.name").startsWith("OpenJDK");
    }

    public static boolean makeDialogsResizable() {
        return Config.isLinux();
    }

    private static String getBlueJPrefDirName() {
        String programName = "bluej";
        if (isGreenfoot) {
            programName = "greenfoot";
        }
        if (Config.isMacOS()) {
            return "Library/Preferences/org." + programName;
        }
        if (Config.isWinOS()) {
            return programName;
        }
        return "." + programName;
    }

    public static String getApplicationName() {
        if (isGreenfoot) {
            return GREENFOOT_DEBUG_DOCK_NAME;
        }
        return "BlueJ";
    }

    private static Rectangle calculateScreenBounds() {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        return new Rectangle(d);
    }

    private static void checkDebug(File userdir) {
        if (!Config.isDebugVM() && !"true".equals(commandProps.getProperty("bluej.debug"))) {
            File debugLogFile = new File(userdir, debugLogName);
            try {
                boolean append = debugLogFile.exists() && debugLogFile.length() < MAX_DEBUG_LOG_SIZE;
                PrintStream outStream = new PrintStream(new FileOutputStream(debugLogFile, append));
                System.setOut(outStream);
                System.setErr(outStream);
                Debug.setDebugStream(new OutputStreamWriter(outStream));
                if (append) {
                    Debug.message("====\n\n====");
                }
                Debug.message(Config.getApplicationName() + " run started: " + new Date());
                if (Config.isGreenfoot()) {
                    Debug.message("Greenfoot version: " + Boot.GREENFOOT_VERSION);
                } else {
                    Debug.message("BlueJ version 4.2.2");
                }
                Debug.message("Java version " + System.getProperty("java.version"));
                Debug.message("JavaFX version " + System.getProperty("javafx.runtime.version"));
                Debug.message("Virtual machine: " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vm.vendor") + ")");
                Debug.message("Running on: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
                Debug.message("Java Home: " + System.getProperty("java.home"));
                Debug.message("----");
                return;
            }
            catch (IOException e) {
                Debug.reportError("Warning: Unable to create debug log file.");
            }
        }
        Debug.setDebugStream(new OutputStreamWriter(System.out));
    }

    public static void handleExit() {
        Config.saveAppProperties();
        Config.saveProperties("moe", "properties.heading.moe", moeUserProps);
    }

    private static void saveAppProperties() {
        String name = Config.getApplicationName().toLowerCase();
        Config.saveProperties(name, "properties.heading." + name, userProps);
    }

    public static void recordEditorOpen(SourceType sourceType) {
        switch (sourceType) {
            case Java: {
                int javaEditors = Config.getPropInteger(EDITOR_COUNT_JAVA, 0, userProps);
                userProps.setProperty(EDITOR_COUNT_JAVA, Integer.toString(++javaEditors));
                Config.saveAppProperties();
                break;
            }
            case Stride: {
                int strideEditors = Config.getPropInteger(EDITOR_COUNT_STRIDE, 0, userProps);
                userProps.setProperty(EDITOR_COUNT_STRIDE, Integer.toString(++strideEditors));
                Config.saveAppProperties();
                break;
            }
        }
    }

    public static int getEditorCount(SourceType sourceType) {
        switch (sourceType) {
            case Java: {
                return Config.getPropInteger(EDITOR_COUNT_JAVA, -1, userProps);
            }
            case Stride: {
                return Config.getPropInteger(EDITOR_COUNT_STRIDE, -1, userProps);
            }
        }
        return -1;
    }

    public static void resetEditorsCount() {
        userProps.setProperty(EDITOR_COUNT_JAVA, "0");
        userProps.setProperty(EDITOR_COUNT_STRIDE, "0");
        Config.saveAppProperties();
    }

    public static void recordLatestSeen(LocalDate latestSeen) {
        userProps.setProperty(MESSAGE_LATEST_SEEN, latestSeen.toString());
        Config.saveAppProperties();
    }

    private static Properties loadDefs(String filename, Properties parentProperties) {
        File propsFile = new File(bluejLibDir, filename);
        Properties defs = new Properties(parentProperties);
        try {
            defs.load(new FileInputStream(propsFile));
        }
        catch (IOException e) {
            Debug.reportError("Unable to load definitions file: " + propsFile);
        }
        return defs;
    }

    private static Properties loadLanguageLabels(String language) {
        Properties labels = Config.loadDefs(DEFAULT_LANGUAGE + File.separator + "labels", System.getProperties());
        String frameLabels = DEFAULT_LANGUAGE + File.separator + "frame-labels";
        File frameLabelFile = new File(bluejLibDir, frameLabels);
        try {
            labels.load(new FileInputStream(frameLabelFile));
        }
        catch (Exception e) {
            Debug.reportError("Unable to load greenfoot labels file: " + frameLabelFile);
        }
        if (Config.isGreenfoot()) {
            String greenfootLabels = DEFAULT_LANGUAGE + File.separator + "greenfoot/greenfoot-labels";
            File greenfootLabelFile = new File(bluejLibDir, greenfootLabels);
            try {
                labels.load(new FileInputStream(greenfootLabelFile));
            }
            catch (IOException e) {
                Debug.reportError("Unable to load greenfoot labels file: " + greenfootLabelFile);
            }
        }
        if (!DEFAULT_LANGUAGE.equals(language)) {
            String languageFileName = language + File.separator + "labels";
            File languageFile = new File(bluejLibDir, languageFileName);
            try {
                labels.load(new FileInputStream(languageFile));
            }
            catch (Exception e) {
                Debug.reportError("Unable to load definitions file: " + languageFile);
            }
            String languageFrameLabels = language + File.separator + "frame-labels";
            File languageFrameLabelFile = new File(bluejLibDir, languageFrameLabels);
            try {
                labels.load(new FileInputStream(languageFrameLabelFile));
            }
            catch (Exception e) {
                Debug.reportError("Unable to load frame labels file: " + languageFrameLabelFile);
            }
            if (Config.isGreenfoot()) {
                File greenfootLabels = new File(bluejLibDir, language + File.separator + "greenfoot/greenfoot-labels");
                try {
                    labels.load(new FileInputStream(greenfootLabels));
                }
                catch (Exception e) {
                    Debug.reportError("Unable to load greenfoot labels file: " + greenfootLabels);
                }
            }
        }
        return labels;
    }

    private static void loadProperties(String filename, Properties props) {
        File propsFile = new File(userPrefDir, filename + ".properties");
        try {
            props.load(new FileInputStream(propsFile));
        }
        catch (IOException iOException) {
        }
        catch (Exception e) {
            Debug.reportError("Exception while loading properties", e);
        }
    }

    private static void saveProperties(String filename, String comment, Properties props) {
        File propsFile = new File(userPrefDir, filename + ".properties");
        try {
            props.store(new FileOutputStream(propsFile), Config.getString(comment));
        }
        catch (IOException e) {
            Debug.reportError("could not save properties file " + propsFile);
        }
    }

    public static Properties getMoeHelp() {
        return Config.loadDefs(language + File.separator + "moe.help", System.getProperties());
    }

    public static List<String> getStringList(String stem) {
        ArrayList<String> r = new ArrayList<String>();
        int i = 1;
        String s;
        while ((s = Config.getString(stem + Integer.toString(i), null)) != null) {
            r.add(s);
            ++i;
        }
        return r;
    }

    public static String getString(String strname) {
        return Config.getString(strname, strname);
    }

    public static String getString(String strname, String def) {
        return Config.getString(strname, def, null);
    }

    public static String getString(String strname, String def, Properties variables) {
        Object str;
        if (langVarProps == null) {
            langVarProps = new Properties();
            langVarProps.put("APPNAME", Config.getApplicationName());
        }
        Object object = str = langProps == null ? def : langProps.getProperty(strname, def);
        if (str != null) {
            int index;
            while ((index = ((String)str).indexOf(95)) != -1) {
                str = ((String)str).substring(0, index) + ((String)str).substring(index + 1);
            }
            index = ((String)str).indexOf(64);
            if (index != -1) {
                str = ((String)str).substring(0, index);
            }
            if (variables == null) {
                variables = langVarProps;
            } else {
                variables.putAll((Map<?, ?>)langVarProps);
            }
            str = PropParser.parsePropString((String)str, variables);
        }
        return str;
    }

    public static int getMnemonicKey(String strname) {
        String str = langProps.getProperty(strname, strname);
        int index = str.indexOf(95);
        int mnemonic = index == -1 || index + 1 >= str.length() ? 0 : str.codePointAt(index + 1);
        return mnemonic;
    }

    public static boolean hasAcceleratorKey(String strname) {
        return langProps.getProperty(strname, strname).indexOf(64) != -1;
    }

    @OnThread(value=Tag.FX)
    public static KeyCombination getAcceleratorKeyFX(String strname) {
        KeyCode keyCode;
        String keyString;
        if (!Config.hasAcceleratorKey(strname)) {
            return null;
        }
        ArrayList<KeyCombination.Modifier> modifiers = new ArrayList<KeyCombination.Modifier>();
        modifiers.add(KeyCombination.SHORTCUT_DOWN);
        String str = langProps.getProperty(strname, strname);
        int index = str.indexOf(64);
        if (str.charAt(++index) == '^') {
            ++index;
            modifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if ((keyString = str.substring(index).toUpperCase()).length() == 1) {
            return new KeyCharacterCombination(keyString, modifiers.toArray(new KeyCombination.Modifier[0]));
        }
        if (keyString.equals("BACK_SPACE")) {
            keyString = "Backspace";
        }
        if ((keyCode = KeyCode.getKeyCode((String)keyString)) != null) {
            return new KeyCodeCombination(keyCode, modifiers.toArray(new KeyCombination.Modifier[0]));
        }
        Debug.message("Unknown key: \"" + keyString + "\"");
        return null;
    }

    public static String getSystemPropString(String propName) {
        String sysID = osname != null && osname.startsWith("Windows 9") ? "win9x" : (osname != null && osname.equals("Windows Me") ? "win9x" : (osname != null && osname.startsWith("Windows") ? "win" : (osname != null && osname.startsWith("Linux") ? "linux" : (osname != null && osname.startsWith("SunOS") ? "solaris" : (osname != null && osname.startsWith("Mac") ? "macos" : "")))));
        String value = commandProps.getProperty(sysID + propName);
        if (value == null) {
            value = commandProps.getProperty(propName);
        }
        return value;
    }

    public static String getPropString(String strname) {
        String rval = Config.getPropString(strname, null);
        if (rval == null) {
            rval = strname;
        }
        return rval;
    }

    public static String getPropString(String strname, String def) {
        return Config.getPropString(strname, def, commandProps);
    }

    public static String getPropString(String strname, String def, Properties props) {
        String propVal = props.getProperty(strname, def);
        if (propVal == null) {
            propVal = def;
        }
        if (propVal != null) {
            return PropParser.parsePropString(propVal, props);
        }
        return null;
    }

    public static String getDefaultPropString(String strname, String def) {
        return systemProps.getProperty(strname, def);
    }

    public static int getPropInteger(String intname, int def) {
        int value;
        try {
            value = Integer.parseInt(Config.getPropString(intname, String.valueOf(def)));
        }
        catch (NumberFormatException nfe) {
            return def;
        }
        return value;
    }

    private static int getPropInteger(String intname, int def, Properties props) {
        int value;
        try {
            value = Integer.parseInt(Config.getPropString(intname, String.valueOf(def), props));
        }
        catch (NumberFormatException nfe) {
            return def;
        }
        return value;
    }

    @OnThread(value=Tag.FXPlatform)
    public static BooleanProperty getPropBooleanProperty(String propname) {
        return booleanProperties.computeIfAbsent(propname, p -> {
            boolean initial = Config.getPropBoolean(propname);
            SimpleBooleanProperty prop = new SimpleBooleanProperty(initial);
            JavaFXUtil.addChangeListener(prop, b -> Config.putPropBoolean(propname, b));
            return prop;
        });
    }

    public static boolean getPropBoolean(String propname) {
        return Config.parseBoolean(Config.getPropString(propname, null));
    }

    public static boolean getPropBoolean(String propname, boolean def) {
        String propval = Config.getPropString(propname);
        if (propval == null) {
            return def;
        }
        return Config.parseBoolean(propval);
    }

    private static boolean parseBoolean(String s) {
        return s != null && s.equalsIgnoreCase("true");
    }

    public static String removeProperty(String propertyName) {
        return (String)userProps.remove(propertyName);
    }

    private static File getImageFile(String propname) {
        String filename = Config.getPropString(propname, null);
        if (filename != null) {
            return new File(bluejLibDir, "images" + File.separator + filename);
        }
        return null;
    }

    @OnThread(value=Tag.Swing)
    public static ImageIcon getImageAsIcon(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return new ImageIcon(u);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @OnThread(value=Tag.FX)
    public static javafx.scene.image.Image getImageAsFXImage(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return new javafx.scene.image.Image(u.toString());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @OnThread(value=Tag.Swing)
    public static ImageIcon getFixedImageAsIcon(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Cannot load null image");
        }
        File image = new File(bluejLibDir, "images" + File.separator + filename);
        try {
            return new ImageIcon(image.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @OnThread(value=Tag.FX)
    public static javafx.scene.image.Image getFixedImageAsFXImage(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Cannot load null image");
        }
        File image = new File(bluejLibDir, "images" + File.separator + filename);
        try {
            return new javafx.scene.image.Image(image.toURI().toURL().toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static Image getImage(String propname) {
        try {
            URL u = Config.getImageFile(propname).toURI().toURL();
            return Toolkit.getDefaultToolkit().createImage(u);
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public static String getJDKExecutablePath(String propName, String executableName) {
        String p;
        if (executableName == null) {
            throw new IllegalArgumentException("must provide an executable name");
        }
        String string = p = propName == null ? null : Config.getSystemPropString(propName);
        if (p == null) {
            String jdkPathName = System.getProperty("java.home");
            if (jdkPathName != null) {
                File jdkPath = new File(jdkPathName);
                File binPath = new File(jdkPath, "bin");
                File potentialExe = new File(binPath, executableName);
                if (potentialExe.exists()) {
                    return potentialExe.getAbsolutePath();
                }
                potentialExe = new File(binPath, executableName + ".exe");
                if (potentialExe.exists()) {
                    return potentialExe.getAbsolutePath();
                }
                if ((jdkPath = jdkPath.getParentFile()) != null) {
                    binPath = new File(jdkPath, "bin");
                    potentialExe = new File(binPath, executableName);
                    if (potentialExe.exists()) {
                        return potentialExe.getAbsolutePath();
                    }
                    potentialExe = new File(binPath, executableName + ".exe");
                    if (potentialExe.exists()) {
                        return potentialExe.getAbsolutePath();
                    }
                }
            }
            return executableName;
        }
        return p;
    }

    public static File getTemplateDir() {
        if (templateDir == null) {
            String path = Config.getPropString("bluej.templatePath", "");
            if (path.length() == 0) {
                templateDir = Config.getLanguageFile("templates");
                if (!templateDir.exists()) {
                    templateDir = Config.getDefaultLanguageFile("templates");
                }
                return templateDir;
            }
            templateDir = new File(path);
        }
        return templateDir;
    }

    public static File getTemplateFile(String base) {
        return new File(Config.getTemplateDir(), base + ".tmpl");
    }

    public static File getClassTemplateDir() {
        return new File(Config.getTemplateDir(), "newclass");
    }

    public static File getClassTemplateFile(String base) {
        return new File(Config.getClassTemplateDir(), base + ".tmpl");
    }

    public static File getLanguageFile(String base) {
        return new File(bluejLibDir, language + File.separator + base);
    }

    public static File getDefaultLanguageFile(String base) {
        return new File(bluejLibDir, DEFAULT_LANGUAGE + File.separator + base);
    }

    public static File getUserConfigFile(String base) {
        return new File(userPrefDir, base);
    }

    public static File getUserConfigDir() {
        return userPrefDir;
    }

    public static Color getItemColour(String itemname) {
        try {
            String rgbStr = Config.getPropString(itemname, "255,0,255");
            String[] rgbVal = Utility.split(rgbStr, ",");
            if (rgbVal.length >= 3) {
                int r = Integer.parseInt(rgbVal[0].trim());
                int g = Integer.parseInt(rgbVal[1].trim());
                int b = Integer.parseInt(rgbVal[2].trim());
                return new Color(r, g, b);
            }
            Debug.reportError("Error reading colour [" + itemname + "]");
        }
        catch (NumberFormatException e) {
            Debug.reportError("Could not get colour for " + itemname);
        }
        return null;
    }

    public static Color getOptionalItemColour(String itemname) {
        try {
            String rgbStr = Config.getPropString(itemname, null);
            if (rgbStr == null) {
                return null;
            }
            String[] rgbVal = Utility.split(rgbStr, ",");
            if (rgbVal.length >= 3) {
                int r = Integer.parseInt(rgbVal[0].trim());
                int g = Integer.parseInt(rgbVal[1].trim());
                int b = Integer.parseInt(rgbVal[2].trim());
                return new Color(r, g, b);
            }
            Debug.reportError("Error reading colour [" + itemname + "]");
        }
        catch (NumberFormatException e) {
            Debug.reportError("Could not get colour for " + itemname);
        }
        return null;
    }

    public static Font getFont(String propertyName, String defaultFontName, int size) {
        int style;
        String fontName = Config.getPropString(propertyName, defaultFontName);
        if (fontName.endsWith("-bold")) {
            style = 1;
            fontName = fontName.substring(0, fontName.length() - 5);
        } else {
            style = 0;
        }
        return new Font(fontName, style, size);
    }

    private static void putLocation(String itemPrefix, int x, int y) {
        Config.putPropInteger(itemPrefix + ".x", Math.max(0, x));
        Config.putPropInteger(itemPrefix + ".y", Math.max(0, y));
    }

    @OnThread(value=Tag.FX)
    private static Point2D getLocation(String itemPrefix) {
        int x = Config.getPropInteger(itemPrefix + ".x", 16);
        int y = Config.getPropInteger(itemPrefix + ".y", 16);
        return Config.ensureOnScreen(x, y);
    }

    private static Dimension getSize(String itemPrefix) {
        int w = Config.getPropInteger(itemPrefix + ".width", -1);
        int h = Config.getPropInteger(itemPrefix + ".height", -1);
        if (w == -1 || h == -1) {
            return null;
        }
        return new Dimension(Math.max(w, 50), Math.max(h, 50));
    }

    private static void putSize(String itemPrefix, int width, int height) {
        Config.putPropInteger(itemPrefix + ".width", Math.max(width, 100));
        Config.putPropInteger(itemPrefix + ".height", Math.max(height, 100));
    }

    public static void putPropInteger(String intname, int value) {
        String defVal = systemProps.getProperty(intname);
        if (defVal != null) {
            try {
                if (value == Integer.valueOf(defVal)) {
                    userProps.remove(intname);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        userProps.setProperty(intname, Integer.toString(value));
    }

    public static void putPropString(String strname, String value) {
        String defVal = systemProps.getProperty(strname);
        if (!(value == null || defVal != null && defVal.equals(value))) {
            userProps.setProperty(strname, value);
        } else {
            userProps.remove(strname);
        }
    }

    public static void putPropBoolean(String propname, boolean value) {
        String sysval = systemProps.getProperty(propname);
        if (Boolean.valueOf(sysval) == value) {
            userProps.remove(propname);
        } else {
            userProps.setProperty(propname, String.valueOf(value));
        }
    }

    public static File getBlueJLibDir() {
        return bluejLibDir;
    }

    public static File getGreenfootLibDir() {
        return greenfootLibDir;
    }

    public static String getBlueJIconPath() {
        return bluejLibDir.getPath() + "/images";
    }

    private static void setVMLocale() {
        String lang = Config.getPropString("vm.language", null);
        String region = Config.getPropString("vm.country", null);
        if ((lang == null || "".equals(lang)) && (region == null || "".equals(region))) {
            return;
        }
        if (lang == null || lang.equals("")) {
            lang = System.getProperty("user.language");
        }
        if (region == null || region.equals("")) {
            region = System.getProperty("user.country");
        }
        debugVMArgs.add("-Duser.language=" + lang);
        debugVMArgs.add("-Duser.country=" + region);
        Locale loc = new Locale(lang, region);
        Locale.setDefault(loc);
    }

    private static void initDebugVMArgs() {
        String args = Config.getPropString("bluej.vm.args");
        if (args != null && !args.equals("bluej.vm.args")) {
            List<String> splitArgs = Utility.dequoteCommandLine(args);
            debugVMArgs.addAll(splitArgs);
        }
    }

    public static List<String> getDebugVMArgs() {
        return debugVMArgs;
    }

    public static final boolean isGreenfoot() {
        return isGreenfoot;
    }

    public static boolean isZipFile(File file) {
        try {
            if (file.isDirectory()) {
                return false;
            }
            if (!file.canRead()) {
                throw new IOException();
            }
            if (file.length() < 4L) {
                return false;
            }
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int magicNumber = in.readInt();
            in.close();
            return magicNumber == 1347093252;
        }
        catch (IOException exc) {
            Debug.reportError("Could not read file: " + file.getAbsolutePath(), exc);
            return false;
        }
    }

    @OnThread(value=Tag.FX)
    public static void addEditorStylesheets(Scene scene) {
        String[] stylesheetStems;
        for (String stem : stylesheetStems = new String[]{"frame-style", "editor-banners", "editor-catalogue", "editor-error-bar", "editor-error-fix", "editor-expression", "editor-help", "editor-menu", "editor-selection", "editor-slot-choice", "editor-suggestions", "editor-tabs", "moe", "shared"}) {
            Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), stem);
        }
        Config.addJavaColorsStylesheet((ObservableList<String>)scene.getStylesheets());
    }

    @OnThread(value=Tag.FX)
    public static void addInspectorStylesheets(Scene scene) {
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "inspectors");
    }

    @OnThread(value=Tag.FX)
    public static void addPopupStylesheets(Parent root) {
        Config.addStylesheet((ObservableList<String>)root.getStylesheets(), "popup");
    }

    @OnThread(value=Tag.FX)
    public static void addTestsStylesheets(Scene scene) {
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "tests");
    }

    @OnThread(value=Tag.FX)
    public static void addTerminalStylesheets(Scene scene) {
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "terminal");
    }

    @OnThread(value=Tag.FX)
    public static void addDebuggerStylesheets(Scene scene) {
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "debugger");
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "shared");
    }

    @OnThread(value=Tag.FX)
    public static void addPMFStylesheets(Scene scene) {
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "pkgmgrframe");
    }

    @OnThread(value=Tag.FX)
    public static void addGreenfootStylesheets(Scene scene) {
        Config.addStylesheet((ObservableList<String>)scene.getStylesheets(), "greenfoot");
    }

    @OnThread(value=Tag.FX)
    private static void addStylesheet(ObservableList<String> sheetList, String stem) {
        try {
            sheetList.add((Object)new File(bluejLibDir + "/stylesheets", stem + ".css").toURI().toURL().toString());
        }
        catch (MalformedURLException e) {
            Debug.reportError(e);
        }
    }

    @OnThread(value=Tag.FX)
    public static void addDialogStylesheets(DialogPane dialogPane) {
        Config.addStylesheet((ObservableList<String>)dialogPane.getStylesheets(), "dialogs");
        Config.addJavaColorsStylesheet((ObservableList<String>)dialogPane.getStylesheets());
    }

    @OnThread(value=Tag.FX)
    private static void addJavaColorsStylesheet(ObservableList<String> stylesheets) {
        Config.addStylesheet(stylesheets, "java-colors");
        File userColorsFile = Config.getUserConfigFile("java-colors.css");
        if (userColorsFile.exists()) {
            try {
                stylesheets.add((Object)userColorsFile.toURI().toURL().toString());
                Debug.log("Using user-specified java-colors file.");
            }
            catch (MalformedURLException e) {
                Debug.reportError(e);
            }
        }
    }

    @OnThread(value=Tag.Swing)
    public static Border getFocusBorder() {
        if (focusBorder == null) {
            focusBorder = new CompoundBorder(new LineBorder(Color.BLACK), new BevelBorder(1, new Color(195, 195, 195), new Color(240, 240, 240), new Color(195, 195, 195), new Color(124, 124, 124)));
        }
        return focusBorder;
    }

    @OnThread(value=Tag.Swing)
    public static Border getNormalBorder() {
        if (normalBorder == null) {
            normalBorder = new CompoundBorder(new EmptyBorder(1, 1, 1, 1), new BevelBorder(1, new Color(195, 195, 195), new Color(240, 240, 240), new Color(124, 124, 124), new Color(195, 195, 195)));
        }
        return normalBorder;
    }

    public static void loadFXFonts() {
        if (!fontOptions.isEmpty()) {
            return;
        }
        for (File file : new File(bluejLibDir + "/fonts").listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".ttf")) continue;
            try {
                FileInputStream fis = new FileInputStream(file);
                javafx.scene.text.Font font = javafx.scene.text.Font.loadFont((InputStream)fis, (double)10.0);
                fis.close();
                if (font == null) {
                    Debug.reportError("Unknown problem loading TTF JavaFX font: " + file.getAbsolutePath());
                }
                if (font == null || fontOptions.contains(font.getFamily())) continue;
                fontOptions.add(font.getFamily());
                Collections.sort(fontOptions);
            }
            catch (Throwable e) {
                Debug.reportError("Error loading font: " + file.getAbsolutePath(), e);
            }
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void loadAndTrackPosition(Window window, String locationPrefix) {
        JavaFXUtil.addChangeListener(window.xProperty(), x -> Config.putLocation(locationPrefix, (int)window.getX(), (int)window.getY()));
        JavaFXUtil.addChangeListener(window.yProperty(), y -> Config.putLocation(locationPrefix, (int)window.getX(), (int)window.getY()));
        Point2D location = Config.getLocation(locationPrefix);
        window.setX(location.getX());
        window.setY(location.getY());
    }

    @OnThread(value=Tag.FXPlatform)
    public static void loadAndTrackPositionAndSize(Window window, String locationPrefix) {
        Config.loadAndTrackPosition(window, locationPrefix);
        JavaFXUtil.addChangeListener(window.widthProperty(), x -> Config.putSize(locationPrefix, (int)window.getWidth(), (int)window.getHeight()));
        JavaFXUtil.addChangeListener(window.heightProperty(), y -> Config.putSize(locationPrefix, (int)window.getWidth(), (int)window.getHeight()));
        Dimension location = Config.getSize(locationPrefix);
        if (location != null) {
            window.setWidth((double)location.width);
            window.setHeight((double)location.height);
        }
    }

    @OnThread(value=Tag.FXPlatform)
    public static void rememberDividerPosition(Window window, SplitPane splitPane, String locationName) {
        double SCALE = 1000000.0;
        double initialPos = (double)Config.getPropInteger(locationName, (int)(0.5 * SCALE)) / SCALE;
        JavaFXUtil.addChangeListener(((SplitPane.Divider)splitPane.getDividers().get(0)).positionProperty(), pos -> Config.putPropInteger(locationName, (int)(pos.doubleValue() * SCALE)));
        if (window.isShowing()) {
            splitPane.setDividerPosition(0, initialPos);
        } else {
            window.addEventHandler(WindowEvent.WINDOW_SHOWN, e -> splitPane.setDividerPosition(0, initialPos));
        }
    }

    public static KeyCode getKeyCodeForYesNo(InteractionManager.ShortcutKey keyPurpose) {
        switch (keyPurpose) {
            case YES_ANYWHERE: {
                return KeyCode.F2;
            }
            case NO_ANYWHERE: {
                return KeyCode.F3;
            }
        }
        return null;
    }

    public static boolean isGreenfootStartupProject(File projectDir) {
        return Config.getGreenfootStartupProjectPath().equals(projectDir.getAbsolutePath());
    }

    public static String getGreenfootStartupProjectPath() {
        return new File(Config.getBlueJLibDir(), "greenfoot/startupProject").getAbsolutePath();
    }

    @OnThread(value=Tag.FX)
    public static Point2D ensureOnScreen(int x, int y) {
        boolean onScreenAlready = Screen.getScreens().stream().anyMatch(screen -> screen.getVisualBounds().contains((double)x, (double)y) && screen.getVisualBounds().contains((double)(x + 80), (double)(y + 80)));
        if (onScreenAlready) {
            return new Point2D((double)x, (double)y);
        }
        return new Point2D(Screen.getPrimary().getBounds().getMinX() + 100.0, Screen.getPrimary().getBounds().getMinY() + 100.0);
    }

    @OnThread(value=Tag.FX)
    public static Node makeStopIcon(boolean large) {
        Polygon octagon = new Polygon(new double[]{9.0, 0.0, 22.0, 0.0, 31.0, 9.0, 31.0, 22.0, 22.0, 31.0, 9.0, 31.0, 0.0, 22.0, 0.0, 9.0});
        if (!large) {
            JavaFXUtil.scalePolygonPoints(octagon, 0.5, false);
        }
        JavaFXUtil.addStyleClass((Styleable)octagon, "octagon");
        Label stop = new Label("STOP");
        StackPane stackPane = new StackPane(new Node[]{octagon, stop});
        JavaFXUtil.setPseudoclass("bj-large", large, new Node[]{stackPane});
        JavaFXUtil.addStyleClass((Styleable)stackPane, "stop-icon");
        return stackPane;
    }

    @OnThread(value=Tag.FX)
    public static Polygon makeArrowShape(boolean shortTail) {
        return new Polygon(new double[]{10.0, 0.0, 18.0, 10.0, 10.0, 20.0, 10.0, 14.0, shortTail ? 4.0 : 0.0, 14.0, shortTail ? 4.0 : 0.0, 6.0, 10.0, 6.0});
    }

    static {
        booleanProperties = new HashMap<String, BooleanProperty>();
        debugLogName = bluejDebugLogName;
        fontOptions = new ArrayList<String>();
        initialised = false;
        isGreenfoot = false;
        debugVMArgs = new ArrayList<String>();
        isDebugVm = true;
        MAX_DEBUG_LOG_SIZE = 0x100000L;
    }

    public static enum SourceType {
        Java,
        Stride;

    }
}

