/*
 * Decompiled with CFR 0.152.
 */
package baumstrukturen;

import baumstrukturen.ComparableContent;
import java.io.Serializable;

public class BinarySearchTree<ContentType extends ComparableContent<ContentType>>
implements Serializable {
    static final long serialVersionUID = 10220L;
    private BSTNode<ContentType> node = null;

    public boolean isEmpty() {
        return this.node == null;
    }

    public void insert(ContentType pContent) {
        if (pContent != null) {
            if (this.isEmpty()) {
                this.node = new BSTNode(this, pContent);
            } else if (pContent.isLess((ComparableContent)((BSTNode)this.node).content)) {
                ((BSTNode)this.node).left.insert(pContent);
            } else if (pContent.isGreater((ComparableContent)((BSTNode)this.node).content)) {
                ((BSTNode)this.node).right.insert(pContent);
            }
        }
    }

    public BinarySearchTree<ContentType> getLeftTree() {
        if (this.isEmpty()) {
            return null;
        }
        return ((BSTNode)this.node).left;
    }

    public ContentType getContent() {
        if (this.isEmpty()) {
            return null;
        }
        return (ContentType)((BSTNode)this.node).content;
    }

    public BinarySearchTree<ContentType> getRightTree() {
        if (this.isEmpty()) {
            return null;
        }
        return ((BSTNode)this.node).right;
    }

    public void remove(ContentType pContent) {
        if (this.isEmpty()) {
            return;
        }
        if (pContent.isLess((ComparableContent)((BSTNode)this.node).content)) {
            ((BSTNode)this.node).left.remove(pContent);
        } else if (pContent.isGreater((ComparableContent)((BSTNode)this.node).content)) {
            ((BSTNode)this.node).right.remove(pContent);
        } else if (((BSTNode)this.node).left.isEmpty()) {
            this.node = ((BSTNode)this.node).right.isEmpty() ? null : this.getNodeOfRightSuccessor();
        } else if (((BSTNode)this.node).right.isEmpty()) {
            this.node = this.getNodeOfLeftSuccessor();
        } else if (((BSTNode)this.getNodeOfRightSuccessor()).left.isEmpty()) {
            ((BSTNode)this.node).content = ((BSTNode)this.getNodeOfRightSuccessor()).content;
            ((BSTNode)this.node).right = ((BSTNode)this.getNodeOfRightSuccessor()).right;
        } else {
            BinarySearchTree<ComparableContent> previous = ((BSTNode)this.node).right.ancestorOfSmallRight();
            BinarySearchTree smallest = ((BSTNode)previous.node).left;
            ((BSTNode)this.node).content = ((BSTNode)smallest.node).content;
            previous.remove(((BSTNode)smallest.node).content);
        }
    }

    public ContentType search(ContentType pContent) {
        if (this.isEmpty() || pContent == null) {
            return null;
        }
        ContentType content = this.getContent();
        if (pContent.isLess(content)) {
            return this.getLeftTree().search(pContent);
        }
        if (pContent.isGreater(content)) {
            return this.getRightTree().search(pContent);
        }
        if (pContent.isEqual(content)) {
            return content;
        }
        return null;
    }

    private BinarySearchTree<ContentType> ancestorOfSmallRight() {
        if (((BSTNode)this.getNodeOfLeftSuccessor()).left.isEmpty()) {
            return this;
        }
        return ((BSTNode)this.node).left.ancestorOfSmallRight();
    }

    private BSTNode<ContentType> getNodeOfLeftSuccessor() {
        return ((BSTNode)this.node).left.node;
    }

    private BSTNode<ContentType> getNodeOfRightSuccessor() {
        return ((BSTNode)this.node).right.node;
    }

    private static class BSTNode<CT extends ComparableContent<CT>>
    implements Serializable {
        static final long serialVersionUID = 10221L;
        private CT content;
        private BinarySearchTree<CT> left;
        private BinarySearchTree<CT> right;
        final /* synthetic */ BinarySearchTree this$0;

        public BSTNode(CT pContent) {
            this.this$0 = var1_1;
            this.content = pContent;
            this.left = new BinarySearchTree();
            this.right = new BinarySearchTree();
        }
    }
}

