/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BObject;
import bluej.extensions.Identifier;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.Debug;
import bluej.utility.Utility;
import bluej.views.FieldView;
import bluej.views.View;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.lang.reflect.Field;
import java.util.List;
import threadchecker.OnThread;
import threadchecker.Tag;

public class BField {
    private final FieldView bluej_view;
    private final Identifier parentId;

    BField(Identifier aParentId, FieldView i_bluej_view) {
        this.parentId = aParentId;
        this.bluej_view = i_bluej_view;
    }

    @Deprecated
    public boolean matches(String fieldName) {
        return this.getName().equals(fieldName);
    }

    public String getName() {
        return this.bluej_view.getName();
    }

    public Class<?> getType() {
        return this.bluej_view.getType().getViewClass();
    }

    public Field getJavaField() {
        return this.bluej_view.getField();
    }

    public int getModifiers() {
        return this.bluej_view.getModifiers();
    }

    @OnThread(value=Tag.SwingIsFX)
    private Object getStaticField() throws ProjectNotOpenException, PackageNotFoundException {
        DebuggerClass debuggerClass;
        Package bluejPkg = this.parentId.getBluejPackage();
        PkgMgrFrame aFrame = this.parentId.getPackageFrame();
        String wantFieldName = this.getName();
        View parentView = this.bluej_view.getDeclaringView();
        String className = parentView.getQualifiedName();
        try {
            debuggerClass = (DebuggerClass)bluejPkg.getDebugger().getClass(className, true).get();
        }
        catch (ClassNotFoundException cnfe) {
            Debug.message((String)("BField.getStaticField: Class=" + className + " Field=" + wantFieldName + " WARNING: cannod get debuggerClass"));
            return null;
        }
        DebuggerObject debugObj = null;
        List staticFields = debuggerClass.getStaticFields();
        for (DebuggerField field : staticFields) {
            if (!wantFieldName.equals(field.getName())) continue;
            debugObj = field.getValueObject(null);
            break;
        }
        if (debugObj == null) {
            return null;
        }
        ObjectReference objRef = debugObj.getObjectReference();
        if (objRef == null) {
            return null;
        }
        return BField.doGetVal(aFrame, wantFieldName, objRef);
    }

    public Object getValue(BObject onThis) throws ProjectNotOpenException, PackageNotFoundException {
        return this.getValue(onThis, false);
    }

    Object getValue(BObject onThis, boolean unpackArray) throws ProjectNotOpenException, PackageNotFoundException {
        if (onThis == null) {
            return this.getStaticField();
        }
        ObjectReference objRef = onThis.getObjectReference();
        ReferenceType type = objRef.referenceType();
        com.sun.jdi.Field thisField = type.fieldByName(this.bluej_view.getName());
        if (thisField == null) {
            return null;
        }
        PkgMgrFrame aFrame = onThis.getPackageFrame();
        return BField.doGetVal(aFrame, this.bluej_view.getName(), objRef.getValue(thisField), unpackArray);
    }

    private static Object doGetVal(PkgMgrFrame packageFrame, String instanceName, Value val, boolean unpackArray) {
        if (val == null) {
            return null;
        }
        if (val instanceof StringReference) {
            return ((StringReference)val).value();
        }
        if (val instanceof BooleanValue) {
            return ((BooleanValue)val).value();
        }
        if (val instanceof ByteValue) {
            return ((ByteValue)val).value();
        }
        if (val instanceof CharValue) {
            return Character.valueOf(((CharValue)val).value());
        }
        if (val instanceof DoubleValue) {
            return ((DoubleValue)val).value();
        }
        if (val instanceof FloatValue) {
            return Float.valueOf(((FloatValue)val).value());
        }
        if (val instanceof IntegerValue) {
            return ((IntegerValue)val).value();
        }
        if (val instanceof LongValue) {
            return ((LongValue)val).value();
        }
        if (val instanceof ShortValue) {
            return ((ShortValue)val).value();
        }
        if (unpackArray && val instanceof ArrayReference) {
            return Utility.mapList(((ArrayReference)val).getValues(), v -> BField.doGetVal(packageFrame, instanceName, v, false));
        }
        if (val instanceof ObjectReference) {
            JdiObject obj = JdiObject.getDebuggerObject((ObjectReference)((ObjectReference)val));
            ObjectWrapper objWrap = ObjectWrapper.getWrapper((PkgMgrFrame)packageFrame, (ObjectBench)packageFrame.getObjectBench(), (DebuggerObject)obj, (GenTypeClass)obj.getGenType(), (String)instanceName);
            return objWrap.getBObject();
        }
        return val.toString();
    }

    static Object doGetVal(PkgMgrFrame packageFrame, String instanceName, Value val) {
        return BField.doGetVal(packageFrame, instanceName, val, false);
    }
}

