/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.temperature.impl;

import com.pi4j.component.temperature.TemperatureSensor;
import com.pi4j.component.temperature.TemperatureSensorBase;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import com.pi4j.temperature.TemperatureScale;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Tmp102
extends TemperatureSensorBase
implements TemperatureSensor {
    int i2cAddr;
    I2CDevice dev;

    public Tmp102(int i2cBus, int i2cAddr) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this.i2cAddr = i2cAddr;
        this.dev = I2CFactory.getInstance((int)i2cBus).getDevice(i2cAddr);
    }

    @Override
    public double getTemperature() {
        double retVal = 0.0;
        boolean temp = false;
        byte[] tempBuffer = new byte[2];
        try {
            this.dev.read(tempBuffer, 0, 2);
            int msb = tempBuffer[0] < 0 ? 256 + tempBuffer[0] : tempBuffer[0];
            int lsb = tempBuffer[1] < 0 ? 256 + tempBuffer[1] : tempBuffer[1];
            int count = (msb <<= 4) | (lsb >>= 4);
            retVal = (double)count * 0.0625;
        }
        catch (IOException ex) {
            Logger.getLogger(Tmp102.class.getName()).log(Level.SEVERE, null, ex);
        }
        return retVal;
    }

    @Override
    public double getTemperature(TemperatureScale t) {
        double retVal = 0.0;
        double rawTemp = this.getTemperature();
        if (TemperatureScale.FARENHEIT == t) {
            System.out.println("Converting to farenheit");
            System.out.println("RawTemp = " + rawTemp);
            retVal = rawTemp * 9.0 / 5.0 + 32.0;
        }
        return retVal;
    }

    @Override
    public TemperatureScale getScale() {
        return TemperatureScale.CELSIUS;
    }
}

