/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.lcd.impl;

import com.pi4j.component.lcd.LCD;
import com.pi4j.component.lcd.LCDBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.wiringpi.Gpio;
import com.pi4j.wiringpi.Lcd;

public class GpioLcdDisplay
extends LCDBase
implements LCD {
    protected int rows;
    protected int columns;
    private int lcdHandle;

    public GpioLcdDisplay(int rows, int columns, Pin rsPin, Pin strobePin, Pin ... dataPins) {
        this.rows = rows;
        this.columns = columns;
        int[] bits = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        Gpio.wiringPiSetup();
        for (int index = 0; index < 8; ++index) {
            if (index >= dataPins.length) continue;
            bits[index] = dataPins[index].getAddress();
        }
        this.lcdHandle = Lcd.lcdInit((int)rows, (int)columns, (int)dataPins.length, (int)rsPin.getAddress(), (int)strobePin.getAddress(), (int)bits[0], (int)bits[1], (int)bits[2], (int)bits[3], (int)bits[4], (int)bits[5], (int)bits[6], (int)bits[7]);
        if (this.lcdHandle == -1) {
            throw new RuntimeException("Invalid LCD handle returned from wiringPi: " + this.lcdHandle);
        }
    }

    @Override
    public int getRowCount() {
        return this.rows;
    }

    @Override
    public int getColumnCount() {
        return this.columns;
    }

    @Override
    public void clear() {
        Lcd.lcdClear((int)this.lcdHandle);
    }

    @Override
    public void setCursorHome() {
        Lcd.lcdHome((int)this.lcdHandle);
    }

    @Override
    public void setCursorPosition(int row, int column) {
        this.validateCoordinates(row, column);
        Lcd.lcdPosition((int)this.lcdHandle, (int)column, (int)row);
    }

    @Override
    public void write(byte data) {
        Lcd.lcdPutchar((int)this.lcdHandle, (byte)data);
    }

    @Override
    public void write(String data) {
        Lcd.lcdPuts((int)this.lcdHandle, (String)data);
    }
}

