/*
 * Decompiled with CFR 0.152.
 */
package graphstrukturen;

import graphstrukturen.Edge;
import graphstrukturen.Vertex;
import java.io.Serializable;
import linearestrukturen.List;

public class Graph
implements Serializable {
    static final long serialVersionUID = 10330L;
    private List<Vertex> vertices = new List();
    private List<Edge> edges = new List();

    public List<Vertex> getVertices() {
        List<Vertex> result = new List<Vertex>();
        this.vertices.toFirst();
        while (this.vertices.hasAccess()) {
            result.append(this.vertices.getContent());
            this.vertices.next();
        }
        result.toFirst();
        return result;
    }

    public List<Edge> getEdges() {
        List<Edge> result = new List<Edge>();
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            result.append(this.edges.getContent());
            this.edges.next();
        }
        result.toFirst();
        return result;
    }

    public Vertex getVertex(String pID) {
        Vertex result = null;
        this.vertices.toFirst();
        while (this.vertices.hasAccess() && result == null) {
            if (this.vertices.getContent().getID().equals(pID)) {
                result = this.vertices.getContent();
            }
            this.vertices.next();
        }
        return result;
    }

    public void addVertex(Vertex pVertex) {
        if (pVertex != null && pVertex.getID() != null) {
            boolean freeID = true;
            this.vertices.toFirst();
            while (this.vertices.hasAccess() && freeID) {
                if (this.vertices.getContent().getID().equals(pVertex.getID())) {
                    freeID = false;
                }
                this.vertices.next();
            }
            if (freeID) {
                this.vertices.append(pVertex);
            }
        }
    }

    public void addEdge(Edge pEdge) {
        Vertex[] vertexPair;
        if (pEdge != null && (vertexPair = pEdge.getVertices())[0] != null && vertexPair[1] != null && this.getVertex(vertexPair[0].getID()) == vertexPair[0] && this.getVertex(vertexPair[1].getID()) == vertexPair[1] && this.getEdge(vertexPair[0], vertexPair[1]) == null && vertexPair[0] != vertexPair[1]) {
            this.edges.append(pEdge);
        }
    }

    public void removeVertex(Vertex pVertex) {
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            Vertex[] akt = this.edges.getContent().getVertices();
            if (akt[0] == pVertex || akt[1] == pVertex) {
                this.edges.remove();
                continue;
            }
            this.edges.next();
        }
        this.vertices.toFirst();
        while (this.vertices.hasAccess() && this.vertices.getContent() != pVertex) {
            this.vertices.next();
        }
        if (this.vertices.hasAccess()) {
            this.vertices.remove();
        }
    }

    public void removeEdge(Edge pEdge) {
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            if (this.edges.getContent() == pEdge) {
                this.edges.remove();
                continue;
            }
            this.edges.next();
        }
    }

    public void setAllVertexMarks(boolean pMark) {
        this.vertices.toFirst();
        while (this.vertices.hasAccess()) {
            this.vertices.getContent().setMark(pMark);
            this.vertices.next();
        }
    }

    public void setAllEdgeMarks(boolean pMark) {
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            this.edges.getContent().setMark(pMark);
            this.edges.next();
        }
    }

    public boolean allVerticesMarked() {
        boolean result = true;
        this.vertices.toFirst();
        while (this.vertices.hasAccess()) {
            if (!this.vertices.getContent().isMarked()) {
                result = false;
            }
            this.vertices.next();
        }
        return result;
    }

    public boolean allEdgesMarked() {
        boolean result = true;
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            if (!this.edges.getContent().isMarked()) {
                result = false;
            }
            this.edges.next();
        }
        return result;
    }

    public List<Vertex> getNeighbours(Vertex pVertex) {
        List<Vertex> result = new List<Vertex>();
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            Vertex[] vertexPair = this.edges.getContent().getVertices();
            if (vertexPair[0] == pVertex) {
                result.append(vertexPair[1]);
            } else if (vertexPair[1] == pVertex) {
                result.append(vertexPair[0]);
            }
            this.edges.next();
        }
        return result;
    }

    public List<Edge> getEdges(Vertex pVertex) {
        List<Edge> result = new List<Edge>();
        this.edges.toFirst();
        while (this.edges.hasAccess()) {
            Vertex[] vertexPair = this.edges.getContent().getVertices();
            if (vertexPair[0] == pVertex) {
                result.append(this.edges.getContent());
            } else if (vertexPair[1] == pVertex) {
                result.append(this.edges.getContent());
            }
            this.edges.next();
        }
        return result;
    }

    public Edge getEdge(Vertex pVertex, Vertex pAnotherVertex) {
        Edge result = null;
        this.edges.toFirst();
        while (this.edges.hasAccess() && result == null) {
            Vertex[] vertexPair = this.edges.getContent().getVertices();
            if (vertexPair[0] == pVertex && vertexPair[1] == pAnotherVertex || vertexPair[0] == pAnotherVertex && vertexPair[1] == pVertex) {
                result = this.edges.getContent();
            }
            this.edges.next();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.vertices.isEmpty();
    }
}

