/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import bluej.extensions.BlueJ;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownServiceException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.bluej.extensions.submitter.transport.FileSession;
import org.bluej.extensions.submitter.transport.FtpSession;
import org.bluej.extensions.submitter.transport.HttpSession;
import org.bluej.extensions.submitter.transport.JarSession;
import org.bluej.extensions.submitter.transport.MessageSession;
import org.bluej.extensions.submitter.transport.SmtpSession;
import org.bluej.extensions.submitter.transport.SocketSession;
import org.bluej.extensions.submitter.transport.TransportReport;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.SwingIsFX)
public abstract class TransportSession {
    protected Properties envProps;
    protected final Properties urlProps;
    protected final @OnThread(value=Tag.Any) URL url;
    protected @OnThread(value=Tag.Any) String result;
    protected @OnThread(value=Tag.Any) SocketSession connection;
    protected @OnThread(value=Tag.Any) TransportReport transportReport;
    protected BlueJ bluej;

    @OnThread(value=Tag.Any)
    public static TransportSession createTransportSession(URL url, Properties environment, BlueJ bluej) throws UnknownServiceException, UnsupportedEncodingException {
        TransportSession ts;
        String protocol = url.getProtocol();
        if (protocol.equals("mailto")) {
            if (environment.getProperty("smtphost") == null) {
                throw new IllegalArgumentException("environment does not contain smtphost");
            }
            if (environment.getProperty("useraddr") == null) {
                throw new IllegalArgumentException("environment does not contain useraddr");
            }
            ts = new SmtpSession(url, environment, bluej);
        } else if (protocol.equals("http") || protocol.equals("https")) {
            ts = new HttpSession(url, environment, bluej);
        } else if (protocol.equals("ftp")) {
            ts = new FtpSession(url, environment);
        } else if (protocol.equals("file")) {
            ts = new FileSession(url, environment);
        } else if (protocol.equals("message")) {
            ts = new MessageSession(url, environment);
        } else {
            throw new UnknownServiceException(protocol);
        }
        return ts;
    }

    @OnThread(value=Tag.Any)
    public static TransportSession createJarTransportSession(URL url, Properties environment, String jarName, BlueJ bluej) throws UnknownServiceException, UnsupportedEncodingException {
        JarSession ts = new JarSession(url, environment, jarName, bluej);
        return ts;
    }

    TransportSession(URL url, Properties environment, BlueJ bluej) throws UnsupportedEncodingException {
        this.url = url;
        this.bluej = bluej;
        this.envProps = environment;
        this.urlProps = new Properties(this.envProps);
        String query = url.getQuery();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String value;
                String key;
                String param = st.nextToken();
                int equals = param.indexOf(61);
                if (equals == -1) {
                    key = param;
                    value = "";
                } else {
                    key = param.substring(0, equals);
                    value = param.substring(equals + 1);
                }
                value = URLDecoder.decode(value, "UTF-8");
                this.urlProps.setProperty(key, value);
            }
        }
        this.result = "No connection established";
    }

    @OnThread(value=Tag.Any)
    public abstract void connect() throws IOException;

    @OnThread(value=Tag.Any)
    public abstract void send(InputStream var1, String var2, boolean var3) throws IOException;

    @OnThread(value=Tag.Any)
    public abstract void disconnect() throws IOException;

    @OnThread(value=Tag.Any)
    public boolean isConnected() {
        return this.connection != null;
    }

    @OnThread(value=Tag.Any)
    public String getResult() {
        return this.result;
    }

    @OnThread(value=Tag.Any)
    public String getProtocol() {
        return this.url.getProtocol();
    }

    @OnThread(value=Tag.Any)
    public void setTransportReport(TransportReport i_transportReport) {
        this.transportReport = i_transportReport;
    }

    @OnThread(value=Tag.Any)
    protected final void reportEvent(String message) {
        if (this.transportReport == null) {
            return;
        }
        this.transportReport.reportEvent(message);
    }

    @OnThread(value=Tag.Any)
    protected final void reportLog(String message) {
        if (this.transportReport == null) {
            return;
        }
        this.transportReport.reportLog(message);
    }
}

