/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import bluej.extensions.BlueJ;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.bluej.extensions.submitter.transport.TransportReport;
import org.bluej.extensions.submitter.transport.TransportSession;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class JarSession
extends TransportSession {
    private TransportSession onwardTS;
    private JarOutputStream jos;
    private PipedOutputStream pos;
    private PipedInputStream pis;
    private String jarName;
    private IOException failure;
    private Thread sendingThread;

    JarSession(URL url, Properties environment, String i_jarName, BlueJ bluej) throws UnknownServiceException, UnsupportedEncodingException {
        super(url, environment, bluej);
        this.onwardTS = JarSession.createTransportSession(url, environment, bluej);
        this.jarName = this.expandJarName(i_jarName);
        this.sendingThread = null;
    }

    private String expandJarName(String i_jarName) {
        String o_jarName = "noNameGiven.jar";
        if (i_jarName == null) {
            return o_jarName;
        }
        if (i_jarName.length() <= 0) {
            return o_jarName;
        }
        StringBuffer risul = new StringBuffer(100);
        StringBuffer varName = new StringBuffer(50);
        char[] inputName = i_jarName.toCharArray();
        boolean isVarName = false;
        for (int index = 0; index < inputName.length; ++index) {
            char thisChar = inputName[index];
            if (thisChar == '<') {
                isVarName = true;
                continue;
            }
            if (thisChar == '>') {
                isVarName = false;
                String aValue = this.envProps.getProperty(varName.toString());
                if (aValue == null) {
                    aValue = this.urlProps.getProperty(varName.toString());
                }
                if (aValue != null) {
                    risul.append(aValue);
                }
                varName = new StringBuffer(50);
                continue;
            }
            if (isVarName) {
                varName.append(thisChar);
                continue;
            }
            risul.append(thisChar);
        }
        return risul.toString();
    }

    @Override
    @OnThread(value=Tag.Any)
    public void connect() throws IOException {
        this.onwardTS.connect();
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.jos = new JarOutputStream(this.pos);
        this.failure = null;
        this.sendingThread = new Thread(){

            @Override
            public void run() {
                try {
                    JarSession.this.onwardTS.send(JarSession.this.pis, JarSession.this.jarName, true);
                }
                catch (IOException ex) {
                    JarSession.this.failure = ex;
                }
            }
        };
        this.sendingThread.start();
    }

    @Override
    @OnThread(value=Tag.Any)
    public void send(InputStream is, String name, boolean binary) throws IOException {
        int c;
        JarEntry je = new JarEntry(name);
        this.jos.putNextEntry(je);
        while ((c = is.read()) != -1) {
            this.jos.write(c);
        }
        this.jos.closeEntry();
    }

    @Override
    @OnThread(value=Tag.Any)
    public void disconnect() throws IOException {
        this.jos.finish();
        this.jos.close();
        if (this.failure != null) {
            throw this.failure;
        }
        try {
            this.sendingThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.failure != null) {
            throw this.failure;
        }
        this.onwardTS.disconnect();
    }

    @Override
    @OnThread(value=Tag.Any)
    public boolean isConnected() {
        return this.onwardTS.isConnected();
    }

    @Override
    @OnThread(value=Tag.Any)
    public String getResult() {
        return this.onwardTS.getResult();
    }

    @Override
    public void setTransportReport(TransportReport i_transportReport) {
        this.onwardTS.setTransportReport(i_transportReport);
    }
}

