/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import bluej.extensions.BlueJ;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.bluej.extensions.submitter.transport.SocketSession;
import org.bluej.extensions.submitter.transport.TransportSession;
import threadchecker.OnThread;
import threadchecker.Tag;

@OnThread(value=Tag.Any)
public class HttpSession
extends TransportSession {
    private static final String VAR_fileNamePrefix = "file";
    private final String boundaryString;
    private OutputStream out = null;
    private int fileCounter = 0;
    private HttpURLConnection connection;

    public HttpSession(URL url, Properties environment, BlueJ bluej) throws UnsupportedEncodingException {
        super(url, environment, bluej);
        String boundary = "";
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            boundary = boundary + (char)SocketSession.encode((byte)random.nextInt(62));
        }
        this.boundaryString = "---------------------------" + boundary;
    }

    @Override
    public void connect() throws IOException {
        this.fileCounter = 0;
        String s = this.url.toString();
        int position = s.indexOf(63);
        if (position > -1) {
            s = s.substring(0, position);
        }
        URL temp = new URL(s);
        this.connection = this.url.getProtocol().equals("https") ? (HttpsURLConnection)temp.openConnection() : (HttpURLConnection)temp.openConnection();
        this.connection.setDoOutput(true);
        this.connection.setAllowUserInteraction(true);
        this.reportEvent("Creating message...");
        this.connection.setRequestProperty("Accept", "text/html");
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundaryString);
        this.connection.setRequestProperty("Connection", "Close");
        this.out = this.connection.getOutputStream();
        Enumeration<Object> e = this.urlProps.keys();
        while (e.hasMoreElements()) {
            String field = (String)e.nextElement();
            String value = this.urlProps.getProperty(field);
            this.addMimeField(field, value);
        }
        Authenticator.setDefault(new HttpUserAuthenticator());
    }

    @Override
    public void send(InputStream is, String name, boolean binary) throws IOException {
        this.addMimeFile(is, name, binary, ++this.fileCounter);
    }

    @Override
    public void disconnect() throws IOException {
        this.addBoundary(true);
        this.reportEvent("Sending message...");
        this.result = this.send();
    }

    private void addMimeFile(InputStream is, String name, boolean binary, int index) throws IOException {
        this.addBoundary(false);
        this.addMessage("Content-Disposition: form-data; name=\"" + VAR_fileNamePrefix + index + "\"; filename=\"" + name + "\"");
        if (binary) {
            this.addMessage("Content-Type: application/octet-stream");
            this.reportLog("Adding binary file " + name);
        } else {
            this.addMessage("Content-Type: text/plain");
            this.reportLog("Adding text file " + name);
        }
        this.addMessage(null);
        this.addStream(is);
        this.addMessage(null);
    }

    private void addMimeField(String field, String value) throws IOException {
        this.addBoundary(false);
        this.addMessage("Content-Disposition: form-data; name=\"" + field + "\"");
        this.addMessage(null);
        this.addMessage(value);
    }

    private String send() throws IOException {
        int b;
        this.reportEvent("Waiting for response...");
        this.out.close();
        this.connection.connect();
        StringWriter sr = new StringWriter();
        InputStream is = this.connection.getInputStream();
        while ((b = is.read()) != -1) {
            sr.write(b);
        }
        is.close();
        String response = sr.toString();
        this.reportEvent("Sent OK");
        return response;
    }

    private void addBoundary(boolean end) throws IOException {
        this.addMessage("--" + this.boundaryString + (end ? "--" : ""));
    }

    private String formatMessage(String message) {
        int l;
        String end;
        if (message == null) {
            message = "";
        }
        if ((end = (l = message.length()) == 0 ? "" : (l == 1 ? message : message.substring(l - 2, l))).indexOf(13) == -1) {
            message = message + '\r';
        }
        if (end.indexOf(10) == -1) {
            message = message + '\n';
        }
        return message;
    }

    private void sendMessage(String message) throws IOException {
        this.out.write(this.formatMessage(message).getBytes());
    }

    private void addMessage(String message) throws IOException {
        String toSend = this.formatMessage(message);
        this.out.write(toSend.getBytes(), 0, toSend.length());
    }

    private void addStream(InputStream is) throws IOException {
        int read;
        byte[] input = new byte[1024];
        while ((read = is.read(input)) > 0) {
            this.out.write(input, 0, read);
        }
    }

    @OnThread(value=Tag.SwingIsFX)
    private class HttpUserAuthenticator
    extends Authenticator {
        @OnThread(value=Tag.Any)
        public HttpUserAuthenticator() {
        }

        @Override
        @OnThread(value=Tag.SwingIsFX, ignoreParent=true)
        protected @OnThread(value=Tag.SwingIsFX, ignoreParent=true) PasswordAuthentication getPasswordAuthentication() {
            String title = HttpSession.this.bluej.getLabel("authentication.dialog.title") + " ";
            String mainPrompt = HttpSession.this.bluej.getLabel("authentication.dialog.label");
            String usernamePrompt = HttpSession.this.bluej.getLabel("authentication.dialog.label.username");
            String passwordPrompt = HttpSession.this.bluej.getLabel("authentication.dialog.label.password");
            Box box = new Box(3);
            String s = HttpSession.this.bluej.getExtensionPropertyString("username", System.getProperty("user.name", ""));
            JTextField username = new JTextField(s, 20);
            JPasswordField password = new JPasswordField(20);
            box.add(new JLabel(mainPrompt + "  \"" + this.getRequestingPrompt() + "\""));
            box.add(Box.createVerticalStrut(10));
            box.add(new JLabel(usernamePrompt));
            box.add(username);
            box.add(Box.createVerticalStrut(5));
            box.add(new JLabel(passwordPrompt));
            box.add(password);
            box.add(Box.createVerticalStrut(10));
            String dialogTitle = title + this.getRequestingProtocol() + "://" + this.getRequestingHost();
            int i = JOptionPane.showConfirmDialog(null, box, dialogTitle, 2, -1);
            if (i == 2) {
                return null;
            }
            return new PasswordAuthentication(username.getText(), password.getPassword());
        }
    }
}

