/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import sum.transduktor.FiniteStateAutomaton;
import sum.transduktor.FsaRunStates;
import sum.transduktor.Tourist;

class TouristManager
implements Runnable,
FsaRunStates {
    FiniteStateAutomaton client;
    Vector tourists;
    Tourist tourist;
    int state;
    boolean stepping;
    boolean starting;

    int getState() {
        return this.state;
    }

    void reset() {
        this.state = 0;
        this.client.setup();
    }

    public void delay(int nMilliSeconds) {
        Date currentDate = new Date();
        long nCurrentTime = currentDate.getTime();
        long nEndTime = currentDate.getTime() + (long)nMilliSeconds;
        while (nEndTime > nCurrentTime) {
            currentDate = new Date();
            nCurrentTime = currentDate.getTime();
        }
    }

    TouristManager(FiniteStateAutomaton fsa) {
        this.client = fsa;
        this.state = 0;
        this.stepping = false;
        this.starting = true;
    }

    public void run() {
        Vector<Tourist> deadTourists = new Vector<Tourist>();
        boolean resuming = false;
        switch (this.state) {
            case 1: {
                this.state = 0;
            }
            case 0: {
                do {
                    Enumeration touristEnum = this.client.getTourists();
                    do {
                        this.tourist = (Tourist)touristEnum.nextElement();
                        resuming = true;
                        this.client.select(this.tourist);
                        this.tourist.setDisplay();
                        do {
                            switch (this.tourist.getState()) {
                                default: {
                                    break;
                                }
                                case 1: {
                                    if (this.stepping && !resuming) break;
                                }
                                case 0: {
                                    this.tourist.tour();
                                }
                            }
                            this.client.repaint();
                            try {
                                Thread.sleep(12L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            resuming = false;
                        } while (this.tourist.getState() == 0);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedexception) {
                            // empty catch block
                        }
                        switch (this.tourist.getState()) {
                            case 2: {
                                this.state = 2;
                                break;
                            }
                            case 3: {
                                deadTourists.addElement(this.tourist);
                            }
                        }
                    } while (touristEnum.hasMoreElements() && this.state != 2);
                    if (this.state == 2) continue;
                    touristEnum = deadTourists.elements();
                    while (touristEnum.hasMoreElements()) {
                        this.client.remove((Tourist)touristEnum.nextElement());
                    }
                    this.state = this.client.numTourists() == 0 ? 3 : 1;
                } while (!this.stepping && this.state == 1);
                this.client.setControls(this.state);
            }
        }
    }

    void setStepping(boolean stepping) {
        this.stepping = stepping;
    }
}

