/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sum.transduktor.Direction;
import sum.transduktor.Edge;
import sum.transduktor.FiniteStateAutomaton;
import sum.transduktor.Location;
import sum.transduktor.Tourist;

class Node
implements Location {
    protected int number;
    Point center;
    Hashtable symbolIndex;
    Hashtable inEdges;
    Hashtable outEdges;
    Vector emptyEdges;
    Vector tourists;
    char name;
    static final int RADIUS = 14;
    static final int DIAMETER = 29;
    static final char FIRST_SYMBOL = '!';
    static final int NUM_SYMBOLS = 94;
    FiniteStateAutomaton parent = null;
    boolean initialState;
    boolean highlight;
    Point tailbase;
    Point tailupper;
    Point taillower;
    static final Direction TAIL_UP = new Direction(3.5342917352885173);
    static final Direction TAIL_DN = new Direction(2.748893571891069);

    void setNumber(int num) {
        this.number = num;
    }

    FiniteStateAutomaton getOwner() {
        return this.parent;
    }

    boolean inLoopRange(int x, int y) {
        int xdiff = this.center.x - x;
        int ydiff = this.center.y - y;
        int distance = (int)Math.round(Math.sqrt(xdiff * xdiff + ydiff * ydiff));
        return distance > 14 && distance <= 58;
    }

    protected void updateTail() {
        this.tailbase.move(this.center.x - 14, this.center.y);
        this.tailupper.move(this.tailbase.x, this.tailbase.y);
        this.taillower.move(this.tailbase.x, this.tailbase.y);
        TAIL_UP.translatePoint(this.tailupper, 10);
        TAIL_DN.translatePoint(this.taillower, 10);
    }

    static Node read(DataInputStream dis) throws IOException {
        int xPosition = dis.readInt();
        int yPosition = dis.readInt();
        char ch = dis.readChar();
        boolean initialState = dis.readBoolean();
        Node newNode = new Node(xPosition, yPosition, ch);
        if (initialState) {
            newNode.setInitialState(true);
        }
        return newNode;
    }

    void removeAllEdges() {
        Edge e;
        Enumeration edges = this.outEdges.elements();
        edges = this.outEdges.elements();
        while (edges.hasMoreElements()) {
            e = (Edge)edges.nextElement();
            e.getDestination().removeInEdge(this);
        }
        edges = this.inEdges.elements();
        while (edges.hasMoreElements()) {
            e = (Edge)edges.nextElement();
            e.getSource().removeOutEdge(this);
        }
    }

    void addEmptyEdge(Edge e) {
        if (!this.emptyEdges.contains(e)) {
            this.emptyEdges.addElement(e);
        }
    }

    void addInEdge(Node n, Edge e) {
        this.inEdges.put(n, e);
        if (!this.equals(n) && this.isEdgeTo(n)) {
            this.getEdgeTo(n).update();
        }
    }

    void removeOutEdge(Node n) {
        Edge e = (Edge)this.outEdges.get(n);
        this.parent.remove(e);
        this.outEdges.remove(n);
        int i = 0;
        do {
            if (!e.labelSet.get(i)) continue;
            this.removeEdgeSymbol((char)(i + 33), e);
        } while (++i < 94);
        if (this.emptyEdges.contains(e)) {
            this.removeEmptyEdge(e);
        }
        n.removeInEdge(this);
    }

    int indexOf() {
        return this.parent.indexOf(this);
    }

    Edge getEdgeTo(Node n) {
        return (Edge)this.outEdges.get(n);
    }

    Edge addOutEdge(Node n, String label, String outText) {
        Edge e = null;
        e = this.equals(n) ? new Edge(this, 1.5707963267948966) : new Edge(this, n);
        this.outEdges.put(n, e);
        n.addInEdge(this, e);
        this.parent.add(e);
        e.setLabel(label);
        e.setTextOut(outText);
        return e;
    }

    void update() {
        Enumeration e = this.outEdges.elements();
        while (e.hasMoreElements()) {
            ((Edge)e.nextElement()).update();
        }
        e = this.inEdges.elements();
        while (e.hasMoreElements()) {
            ((Edge)e.nextElement()).update();
        }
        if (this.initialState) {
            this.updateTail();
        }
    }

    Edge addOutEdge(Edge e, Node dest) {
        e.straighten();
        e.setDestination(dest);
        this.outEdges.put(dest, e);
        dest.addInEdge(this, e);
        this.parent.add(e);
        e.registerLabel();
        return e;
    }

    Edge addOutEdge(double angle, String label, String outText) {
        Edge e = new Edge(this, angle);
        this.outEdges.put(this, e);
        this.addInEdge(this, e);
        this.parent.add(e);
        e.setLabel(label);
        e.setTextOut(outText);
        return e;
    }

    Edge addOutEdge(Edge e) {
        e.loop();
        e.setDestination(this);
        this.outEdges.put(this, e);
        this.addInEdge(this, e);
        this.parent.add(e);
        e.registerLabel();
        return e;
    }

    void setInitialState(boolean b) {
        this.initialState = b;
        this.updateTail();
        if (this.parent != null) {
            if (b) {
                this.parent.addInitialState(this);
            } else {
                this.parent.removeInitialState(this);
            }
        }
    }

    int getSelectedSymbolIndex() {
        return this.name;
    }

    void setSelectedSymbolIndex(int symbolIndex) {
        this.name = (char)(65 + symbolIndex);
    }

    void write(DataOutputStream dos) throws IOException {
        dos.writeInt(this.center.x);
        dos.writeInt(this.center.y);
        dos.writeChar(this.name);
        dos.writeBoolean(this.initialState);
    }

    void addEdgeSymbol(char symbol, Edge edge) {
        Character s = new Character(symbol);
        Vector<Edge> v = (Vector<Edge>)this.symbolIndex.get(s);
        if (v == null) {
            v = new Vector<Edge>();
            this.symbolIndex.put(s, v);
        }
        if (v.contains(edge)) {
            return;
        }
        v.addElement(edge);
    }

    void setHighlight(boolean highlight) {
        this.highlight = highlight;
        if (highlight) {
            this.paint(this.parent.getGraphics());
        }
    }

    public void handleTourist(Tourist tourist) {
        Vector labeledEdges;
        char symbol = tourist.currentSymbol();
        int ledges = 0;
        int uedges = 0;
        uedges = this.emptyEdges.size();
        if (symbol == 'A') {
            if (this.isGoal()) {
                tourist.payToll(true);
                return;
            }
            ++uedges;
        }
        if ((labeledEdges = this.getSymbolIndex(symbol)) != null) {
            ledges = labeledEdges.size();
        }
        if (ledges + uedges > 0) {
            Tourist t;
            Edge nextEdge;
            Enumeration edgeEnum;
            Vector<Tourist> tourists = new Vector<Tourist>();
            tourists.addElement(tourist);
            for (int i = 0; i < ledges + uedges - 1; ++i) {
                Tourist t2 = tourist.copy();
                this.parent.add(t2);
                tourists.addElement(t2);
            }
            Enumeration touristEnum = tourists.elements();
            if (labeledEdges != null) {
                edgeEnum = labeledEdges.elements();
                while (edgeEnum.hasMoreElements()) {
                    nextEdge = (Edge)edgeEnum.nextElement();
                    t = (Tourist)touristEnum.nextElement();
                    if (t == tourist) {
                        t.payToll(true);
                    } else {
                        t.payToll(false);
                    }
                    nextEdge.assignGuide(t);
                }
            }
            edgeEnum = this.emptyEdges.elements();
            while (edgeEnum.hasMoreElements()) {
                nextEdge = (Edge)edgeEnum.nextElement();
                t = (Tourist)touristEnum.nextElement();
                nextEdge.assignGuide(t);
            }
            if (touristEnum.hasMoreElements()) {
                t = (Tourist)touristEnum.nextElement();
                t.payToll(true);
                t.setGuide(null);
            }
        } else {
            tourist.payToll(true);
            tourist.setGuide(null);
        }
    }

    boolean isEdgeFrom(Node n) {
        return this.inEdges.containsKey(n);
    }

    Node() {
        this(14, 14, 'S');
    }

    Node(int x, int y, char ch) {
        this.center = new Point(x, y);
        this.name = ch;
        this.symbolIndex = new Hashtable();
        this.emptyEdges = new Vector();
        this.tourists = new Vector();
        this.inEdges = new Hashtable();
        this.outEdges = new Hashtable();
        this.highlight = false;
        this.tailbase = new Point(0, 0);
        this.tailupper = new Point(0, 0);
        this.taillower = new Point(0, 0);
        this.update();
    }

    void removeEmptyEdge(Edge e) {
        if (this.emptyEdges.contains(e)) {
            this.emptyEdges.removeElement(e);
        }
    }

    void removeInEdge(Node n) {
        this.inEdges.remove(n);
        if (this.isEdgeTo(n)) {
            ((Edge)this.outEdges.get(n)).update();
        }
    }

    boolean tooClose(int x, int y) {
        int xdiff = this.center.x - x;
        int ydiff = this.center.y - y;
        int distance = (int)Math.round(Math.sqrt(xdiff * xdiff + ydiff * ydiff));
        return distance < 58;
    }

    void setParent(FiniteStateAutomaton fsa) {
        this.parent = fsa;
    }

    void paint(Graphics g) {
        Font font = g.getFont();
        Enumeration edges = this.outEdges.elements();
        while (edges.hasMoreElements()) {
            Edge edge = (Edge)edges.nextElement();
            edge.paint(g);
        }
        if (this.highlight) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.white);
        }
        g.fillOval(this.center.x - 14 + 1, this.center.y - 14 + 1, 29, 29);
        g.setColor(Color.black);
        g.drawString("" + this.name, this.center.x - g.getFontMetrics(font).charWidth(this.name) / 2 + 1, this.center.y + g.getFontMetrics(font).getAscent() / 2 + 1);
        g.drawOval(this.center.x - 14 + 1, this.center.y - 14 + 1, 29, 29);
        if (this.initialState) {
            g.drawLine(this.tailbase.x, this.tailbase.y, this.tailupper.x, this.tailupper.y);
            g.drawLine(this.tailbase.x, this.tailbase.y, this.taillower.x, this.taillower.y);
        }
    }

    boolean inside(int x, int y) {
        int xdiff = this.center.x - x;
        int ydiff = this.center.y - y;
        return (int)Math.round(Math.sqrt(xdiff * xdiff + ydiff * ydiff)) <= 14;
    }

    void setCenter(Point newCenter) {
        this.center.move(newCenter.x, newCenter.y);
        this.update();
    }

    void setCenter(int x, int y) {
        this.center.move(x, y);
        this.update();
    }

    void removeEdgeSymbol(char symbol, Edge edge) {
        Character s = new Character(symbol);
        Vector v = (Vector)this.symbolIndex.get(s);
        if (v == null) {
            return;
        }
        v.removeElement(edge);
    }

    Edge getEdgeFrom(Node n) {
        return (Edge)this.inEdges.get(n);
    }

    Vector getSymbolIndex(char symbol) {
        return (Vector)this.symbolIndex.get(new Character(symbol));
    }

    public Point getPosition() {
        return this.center;
    }

    boolean isEdgeTo(Node n) {
        return this.outEdges.containsKey(n);
    }

    boolean isInitialState() {
        return this.initialState;
    }

    public boolean isGoal() {
        return true;
    }
}

