/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import sum.transduktor.Effects;

public class JifPanel
extends Panel
implements Effects {
    public static final int TAB_KEY = 9;
    public static final int TEXT_OFFSET = 5;
    protected int textStyle;
    protected int textPlacement;
    protected int style;
    protected int thickness = 2;
    protected int myWidth;
    protected int myHeight;
    protected String text;
    protected boolean skipLeft = false;
    protected boolean skipTop = false;
    protected boolean skipBottom = false;
    protected boolean skipRight = false;
    protected int currentPos;

    public JifPanel() {
        this(0);
    }

    public JifPanel(int i) {
        this.reshape(0, 0, 1, 1);
        this.resize(0, 0);
        this.style = i;
    }

    public JifPanel(String s) {
        this(0, s);
    }

    public JifPanel(int i, String s) {
        this(i);
        this.setText(s, 0, 0);
    }

    public JifPanel(int i, int j, int k, String s) {
        this(i);
        this.myWidth = j;
        this.myHeight = k;
        this.resize(j, k);
        this.setText(s, 0, 0);
    }

    public JifPanel(int i, int j, int k) {
        this(i, j, k, null);
    }

    public void addNotify() {
        super.addNotify();
        this.getMetrics();
    }

    public Insets insets() {
        FontMetrics fontmetrics;
        int i;
        int j = i = this.thickness + 1;
        if (this.isStyleSet(64) && (fontmetrics = this.getFontMetrics(this.getFont())) != null) {
            j += fontmetrics.getHeight() / 2 + 1;
        }
        return new Insets(j, i, i, i);
    }

    public void getMetrics() {
        Dimension dimension = this.minimumSize();
        if (this.text != null && this.myWidth == 0 && this.myHeight == 0 && dimension.width == 0 && dimension.height == 0) {
            FontMetrics fontmetrics = this.getFontMetrics(this.getFont());
            if (fontmetrics == null) {
                return;
            }
            int i = this.thickness * 2 + 10;
            this.myHeight = fontmetrics.getHeight() + i;
            this.myWidth = fontmetrics.stringWidth(this.text) + i;
            this.resize(this.myWidth + this.thickness * 2, this.myHeight + this.thickness * 2);
        }
    }

    public Dimension minimumSize() {
        if (this.myWidth != 0 && this.myHeight != 0) {
            int i = this.myWidth + this.thickness * 2;
            int j = this.myHeight + this.thickness * 2;
            return new Dimension(i, j);
        }
        Dimension dimension = super.preferredSize();
        Insets insets1 = this.insets();
        dimension.width += insets1.left + insets1.right;
        dimension.height += insets1.top + insets1.bottom;
        return dimension;
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setStyle(int i) {
        this.style = i;
        this.repaint();
    }

    public void setText(String s, int i, int j) {
        this.text = s;
        this.setTextStyle(i);
        this.setTextPlacement(j);
        this.repaint();
    }

    public void setText(String s) {
        this.text = s;
        this.setTextStyle(0);
        this.setTextPlacement(1);
        this.repaint();
    }

    public void setTextStyle(int i) {
        this.textStyle = i;
        this.repaint();
    }

    public void setTextPlacement(int i) {
        this.textPlacement = i;
        this.repaint();
    }

    public void setThickness(int i) {
        this.thickness = i;
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.size().width < 1) {
            this.getMetrics();
        }
        if (this.style != 0) {
            this.drawFrame(g);
            if (this.text != "" && this.text != null) {
                this.drawText(g);
            }
        }
    }

    public void drawFrame(Graphics g) {
        int k = 0;
        int l = 0;
        Dimension dimension = this.size();
        if (this.isStyleSet(64)) {
            FontMetrics fontmetrics = g.getFontMetrics();
            k = fontmetrics.getHeight() / 2;
        }
        int i = 0;
        int j = 1;
        while (i < this.thickness) {
            if (i != 0) {
                l = 0;
            } else if (this.isStyleSet(8)) {
                l = 1;
            }
            if (this.isStyleSet(16) || this.isStyleSet(32) && j < this.thickness || this.isStyleSet(2) && j > this.thickness) {
                g.setColor(Color.white);
            } else {
                g.setColor(Color.gray);
            }
            if (!this.skipTop) {
                g.fillRect(i + l, i + k, dimension.width - 2 * (i + l), 1);
            }
            if (!this.skipLeft) {
                g.fillRect(i, i + l + k, 1, dimension.height - (2 * i + 1 + l) - k);
            }
            if (this.isStyleSet(16) || this.isStyleSet(1) || this.isStyleSet(32) && j < this.thickness || this.isStyleSet(2) && j > this.thickness) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.white);
            }
            if (!this.skipBottom) {
                g.fillRect(i + l, dimension.height - (i + 1), dimension.width - 2 * (i + l), 1);
            }
            if (!this.skipRight) {
                g.fillRect(dimension.width - (i + 1), i + l + k, 1, dimension.height - (2 * i + 1 + l) - k);
            }
            ++i;
            j += 2;
        }
    }

    public void drawText(Graphics g) {
        Color color = g.getColor();
        int i = 0;
        int j = 0;
        FontMetrics fontmetrics = g.getFontMetrics();
        Dimension dimension = this.size();
        if (!this.isStyleSet(64)) {
            switch (this.textPlacement) {
                case 0: {
                    i = dimension.width / 2 - fontmetrics.stringWidth(this.text) / 2;
                    j = dimension.height / 2 - fontmetrics.getHeight() / 2;
                    break;
                }
                case 1: {
                    i = this.thickness + 5;
                    j = dimension.height / 2 - fontmetrics.getHeight() / 2;
                    break;
                }
                case 2: {
                    i = dimension.width - this.thickness - 5 - fontmetrics.stringWidth(this.text);
                    j = dimension.height / 2 - fontmetrics.getHeight() / 2;
                }
            }
        } else {
            int k = fontmetrics.charWidth('i');
            i = this.thickness + 5 + k;
            j = 0;
            g.setColor(this.getBackground());
            g.fillRect(i, j, fontmetrics.stringWidth(this.text) + k * 2, fontmetrics.getHeight());
            i += k;
        }
        j += fontmetrics.getHeight() - fontmetrics.getDescent() - 1;
        if (this.textStyle == 1) {
            g.setColor(Color.white);
            g.drawString(this.text, i + 1, j + 1);
        }
        if (this.textStyle == 2) {
            g.setColor(Color.white);
            g.drawString(this.text, i - 1, j - 1);
        }
        if (this.textStyle == 3) {
            g.setColor(Color.gray);
            g.drawString(this.text, i + 1, j + 1);
        }
        g.setColor(Color.black);
        g.drawString(this.text, i, j);
        g.setColor(color);
    }

    public boolean isStyleSet(int i) {
        return (this.style & i) != 0;
    }

    public void setSkip(String s, boolean flag) {
        if (s.equalsIgnoreCase("North")) {
            this.skipTop = flag;
            return;
        }
        if (s.equalsIgnoreCase("South")) {
            this.skipBottom = flag;
            return;
        }
        if (s.equalsIgnoreCase("East")) {
            this.skipRight = flag;
            return;
        }
        if (s.equalsIgnoreCase("West")) {
            this.skipLeft = flag;
            return;
        }
        if (s.equalsIgnoreCase("All")) {
            this.skipTop = flag;
            this.skipBottom = flag;
            this.skipRight = flag;
            this.skipLeft = flag;
        }
    }
}

