/*
 * Decompiled with CFR 0.152.
 */
package sum.transduktor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import sum.transduktor.Direction;
import sum.transduktor.EdgeLabel;
import sum.transduktor.FiniteStateAutomaton;
import sum.transduktor.LoopGuide;
import sum.transduktor.Node;
import sum.transduktor.StraightGuide;
import sum.transduktor.Tourist;

class Edge {
    static final int STRAIGHT = 0;
    static final int LOOP = 1;
    int type;
    Direction dir;
    Direction tempdir;
    BitSet labelSet = new BitSet(94);
    Point start;
    Point end;
    Point labelPos;
    Point ahpoint;
    Polygon arrowhead;
    String labelText = " ";
    String textOut = "";
    EdgeLabel label;
    boolean emptyString = false;
    boolean highlight = false;
    int distance;
    int startAngle;
    Node src;
    Node dest;
    Point arcStart;
    Point arcEnd;
    Point arcCorner;
    Point arcCenter;
    double angle;
    protected Point np;
    protected static final BitSet BLANK_BITSET = new BitSet(94);

    FiniteStateAutomaton getOwner() {
        return this.src.getOwner();
    }

    void checkUnorderedRange(char start, char end, StringBuffer sb) {
        int startIndex = start - 33;
        int endIndex = end - 33;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (!this.labelSet.get(i)) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append((char)(i + 33));
        }
    }

    void selectSymbol(int i) {
        this.labelSet.set(i);
        this.src.addEdgeSymbol((char)(i + 33), this);
        this.updateLabel();
    }

    void setSymbol(int index, boolean b) {
        if (b ^ this.labelSet.get(index)) {
            if (b) {
                this.labelSet.set(index);
                this.src.addEdgeSymbol((char)(index + 33), this);
            } else {
                this.labelSet.clear(index);
                this.src.removeEdgeSymbol((char)(index + 33), this);
            }
            this.updateLabel();
        }
    }

    void straighten() {
        this.type = 0;
        this.update();
    }

    boolean isSymbolSet(int index) {
        return this.labelSet.get(index);
    }

    static Edge read(FiniteStateAutomaton fsa, DataInputStream dis) throws IOException {
        int type = dis.readInt();
        if (type == 1) {
            Node src = fsa.nodeAt(dis.readInt());
            double angle = dis.readDouble();
            String labelChars = dis.readLine();
            String textOut = dis.readLine();
            return src.addOutEdge(angle, labelChars, textOut);
        }
        if (type == 0) {
            Node src = fsa.nodeAt(dis.readInt());
            Node dest = fsa.nodeAt(dis.readInt());
            String labelChars = dis.readLine();
            String textOut = dis.readLine();
            return src.addOutEdge(dest, labelChars, textOut);
        }
        return null;
    }

    Point getStart() {
        return this.start;
    }

    Point getArcEnd() {
        return this.arcEnd;
    }

    void setDestination(Node n) {
        this.dest = n;
        this.update();
    }

    Node getDestination() {
        return this.dest;
    }

    public void update() {
        if (this.type == 1) {
            this.dir.set(this.angle);
            this.dir.rotate(0.39269908169872414, this.tempdir);
            this.start.move(this.src.center.x, this.src.center.y);
            this.tempdir.translatePoint(this.start, 14);
            this.dir.rotate(-0.39269908169872414, this.tempdir);
            this.end.move(this.src.center.x, this.src.center.y);
            this.tempdir.translatePoint(this.end, 14);
            int xdiff = this.start.x - this.end.x;
            int ydiff = this.start.y - this.end.y;
            this.distance = (int)Math.round(Math.sqrt(xdiff * xdiff + ydiff * ydiff));
            this.arcStart.move(this.start.x, this.start.y);
            this.dir.translatePoint(this.arcStart, this.distance * 3);
            this.arcEnd.move(this.end.x, this.end.y);
            this.dir.translatePoint(this.arcEnd, this.distance * 3);
            this.dir.rotate(1.5707963267948966, this.tempdir);
            this.arcCenter.move(this.arcEnd.x, this.arcEnd.y);
            this.tempdir.translatePoint(this.arcCenter, this.distance / 2);
            this.arcCorner.move(this.arcCenter.x, this.arcCenter.y);
            this.arcCorner.translate(-(this.distance / 2), -(this.distance / 2));
            this.startAngle = (int)Math.round(this.tempdir.getAngleInDegrees());
            this.arrowhead = new Polygon();
            this.arrowhead.addPoint(this.end.x, this.end.y);
            this.ahpoint.move(this.end.x, this.end.y);
            this.dir.translatePoint(this.ahpoint, 12);
            this.tempdir.translatePoint(this.ahpoint, 5);
            this.arrowhead.addPoint(this.ahpoint.x, this.ahpoint.y);
            this.tempdir.translatePoint(this.ahpoint, -10);
            this.arrowhead.addPoint(this.ahpoint.x, this.ahpoint.y);
        } else if (this.type == 0) {
            this.dir.set(this.src.center, this.dest.center);
            this.start.move(this.src.center.x, this.src.center.y);
            this.end.move(this.dest.center.x, this.dest.center.y);
            if (this.src.isEdgeFrom(this.dest)) {
                this.dir.rotate(0.39269908169872414, this.tempdir);
                this.tempdir.translatePoint(this.start, 14);
                this.dir.rotate(2.748893571891069, this.tempdir);
                this.tempdir.translatePoint(this.end, 14);
            } else {
                this.dir.translatePoint(this.start, 14);
                this.dir.translatePoint(this.end, -14);
            }
            this.arrowhead = new Polygon();
            this.arrowhead.addPoint(this.end.x, this.end.y);
            this.ahpoint.move(this.end.x, this.end.y);
            this.dir.translatePoint(this.ahpoint, -12);
            this.dir.rotate(1.5707963267948966, this.tempdir);
            this.tempdir.translatePoint(this.ahpoint, 5);
            this.arrowhead.addPoint(this.ahpoint.x, this.ahpoint.y);
            this.tempdir.translatePoint(this.ahpoint, -10);
            this.arrowhead.addPoint(this.ahpoint.x, this.ahpoint.y);
        }
        this.updateLabel();
    }

    void write(DataOutputStream dos) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (this.type == 1) {
            dos.writeInt(1);
            dos.writeInt(this.src.indexOf());
            dos.writeDouble(this.angle);
        } else if (this.type == 0) {
            dos.writeInt(0);
            dos.writeInt(this.src.indexOf());
            dos.writeInt(this.dest.indexOf());
        }
        int i = 0;
        do {
            if (!this.labelSet.get(i)) continue;
            sb.append((char)(i + 33));
        } while (++i < 94);
        dos.writeBytes(sb.toString() + "\n");
        dos.writeBytes(this.textOut + "\n");
    }

    void addSymbol(char c) {
        int index = c - 33;
        if (index >= 0 && index < 94) {
            this.labelSet.set(index);
            this.updateLabel();
        }
    }

    void setHighlight(boolean highlight) {
        this.highlight = highlight;
        if (highlight) {
            this.paint(this.src.parent.getGraphics());
        }
    }

    boolean isStraight() {
        return this.type == 0;
    }

    int[] getSelectedSymbolIndexes() {
        int length = 0;
        int[] symbolIndexes = new int[this.labelSet.size()];
        for (int i = 0; i < this.labelSet.size(); ++i) {
            if (!this.labelSet.get(i)) continue;
            symbolIndexes[length] = i;
            ++length;
        }
        if (length < symbolIndexes.length) {
            int[] temp = new int[length];
            System.arraycopy(symbolIndexes, 0, temp, 0, length);
            symbolIndexes = temp;
        }
        return symbolIndexes;
    }

    void setSelectedSymbolIndexes(int[] symbolIndexes) {
        this.labelSet.and(BLANK_BITSET);
        for (int i = 0; i < symbolIndexes.length; ++i) {
            this.setSymbol(symbolIndexes[i], true);
        }
    }

    void registerLabel() {
        int i = 0;
        do {
            if (!this.labelSet.get(i)) continue;
            this.src.addEdgeSymbol((char)(i + 33), this);
        } while (++i < 94);
        if (this.emptyString) {
            this.src.addEmptyEdge(this);
        }
    }

    void buildLabel() {
        StringBuffer sb = new StringBuffer();
        this.checkUnorderedRange('!', '/', sb);
        this.checkOrderedRange('0', '9', sb);
        this.checkUnorderedRange(':', '@', sb);
        this.checkOrderedRange('A', 'Z', sb);
        this.checkUnorderedRange('[', '`', sb);
        this.checkOrderedRange('a', 'z', sb);
        this.checkUnorderedRange('{', '~', sb);
        this.labelText = sb.toString() + "/" + this.textOut;
    }

    void setEString(boolean value) {
        this.emptyString = value;
        if (value) {
            this.src.addEmptyEdge(this);
        } else {
            this.src.removeEmptyEdge(this);
        }
    }

    double length() {
        int xdiff = this.end.x - this.start.x;
        int ydiff = this.end.y - this.start.y;
        return Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }

    Node getSource() {
        return this.src;
    }

    void setSource(Node n) {
        this.src = n;
        this.update();
    }

    boolean isLoop() {
        return this.type == 1;
    }

    Edge() {
        this.dir = new Direction(0, 0, 0, 0);
        this.tempdir = new Direction(0, 0, 0, 0);
        this.start = new Point(0, 0);
        this.end = new Point(0, 0);
        this.arcStart = new Point(0, 0);
        this.arcEnd = new Point(0, 0);
        this.arcCorner = new Point(0, 0);
        this.arcCenter = new Point(0, 0);
        this.np = new Point(0, 0);
        this.ahpoint = new Point(0, 0);
        this.label = new EdgeLabel();
    }

    Edge(Node source, Node destination) {
        this();
        this.src = source;
        this.dest = destination;
        this.type = this.src == destination ? 1 : 0;
        this.update();
    }

    Edge(Node source, double angle) {
        this();
        this.src = source;
        this.dest = source;
        this.angle = angle;
        this.type = 1;
        this.update();
    }

    int getDistance() {
        return this.distance;
    }

    Polygon getArrowhead() {
        return this.arrowhead;
    }

    Point getEnd() {
        return this.end;
    }

    public void paint(Graphics g) {
        if (this.highlight) {
            g.setColor(Color.red);
        }
        if (this.type == 1) {
            g.drawLine(this.start.x, this.start.y, this.arcStart.x, this.arcStart.y);
            g.drawArc(this.arcCorner.x, this.arcCorner.y, this.distance, this.distance, 360 - this.startAngle, 180);
            g.drawLine(this.arcEnd.x, this.arcEnd.y, this.end.x, this.end.y);
        } else if (this.type == 0) {
            g.drawLine(this.start.x, this.start.y, this.end.x, this.end.y);
        }
        g.fillPolygon(this.arrowhead);
        this.label.paint(g);
        g.setColor(Color.black);
    }

    boolean inside(int x, int y) {
        return this.arrowhead.inside(x, y);
    }

    Point getArcStart() {
        return this.arcStart;
    }

    void removeSymbol(char c) {
        this.labelSet.clear(c - 33);
        this.updateLabel();
    }

    void checkOrderedRange(char start, char end, StringBuffer sb) {
        int startIndex = start - 33;
        int endIndex = end - 33;
        boolean previous = false;
        for (int i = startIndex; i <= endIndex; ++i) {
            if (this.labelSet.get(i)) {
                if (!previous) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append((char)(i + 33));
                }
                if (previous || i >= endIndex - 1 || !this.labelSet.get(i + 1) || !this.labelSet.get(i + 2)) continue;
                previous = true;
                continue;
            }
            if (!previous) continue;
            sb.append('-');
            sb.append((char)(i + 33 - 1));
            previous = false;
        }
        if (previous) {
            sb.append('-');
            sb.append(end);
        }
    }

    void updateLabel() {
        Point labelPos = new Point(0, 0);
        this.buildLabel();
        if (this.emptyString) {
            if (this.labelText.length() > 0) {
                this.label.setText(this.labelText + ", \\ie");
            } else {
                this.label.setText("\\ie");
            }
        } else {
            this.label.setText(this.labelText);
        }
        Graphics g = this.src.parent.getGraphics();
        int width = this.label.getWidth(g);
        int ascent = this.label.getAscent(g);
        double angle = this.dir.getAngle();
        if (this.type == 1) {
            labelPos.move(this.src.center.x, this.src.center.y);
            this.dir.translatePoint(labelPos, (int)(14.0 + 3.5 * (double)this.distance + 2.0));
            if (angle < 1.5707963267948966) {
                if (angle - 0.1 < 0.0) {
                    labelPos.translate(0, ascent / 2);
                } else if (angle + 0.2 > 1.5707963267948966) {
                    labelPos.translate(-(width / 2), ascent);
                } else {
                    labelPos.translate(0, ascent);
                }
            } else if (angle < Math.PI) {
                if (angle - 0.2 < 1.5707963267948966) {
                    labelPos.translate(-(width / 2), ascent);
                } else if (angle + 0.1 > Math.PI) {
                    labelPos.translate(-width, ascent / 2);
                } else {
                    labelPos.translate(-width, ascent);
                }
            } else if (angle < 4.71238898038469) {
                if (angle - 0.1 < Math.PI) {
                    labelPos.translate(-width, ascent / 2);
                } else if (angle + 0.1 > 4.71238898038469) {
                    labelPos.translate(-(width / 2), 0);
                } else {
                    labelPos.translate(-width, 0);
                }
            } else if (angle - 0.1 < 4.71238898038469) {
                labelPos.translate(-(width / 2), 0);
            } else if (angle + 0.1 > Math.PI * 2) {
                labelPos.translate(0, ascent / 2);
            }
        } else if (this.type == 0) {
            labelPos.move(this.start.x, this.start.y);
            this.dir.translatePoint(labelPos, (int)(this.length() / 2.0));
            this.dir.rotate(1.5707963267948966, this.tempdir);
            this.tempdir.translatePoint(labelPos, 2);
            if (angle < 1.5707963267948966) {
                if (angle - 0.001 < 0.0) {
                    labelPos.translate(-(width / 2), ascent);
                } else {
                    labelPos.translate(-width, ascent);
                }
            } else if (angle < Math.PI) {
                if (angle - 0.001 < 1.5707963267948966) {
                    labelPos.translate(-width, -(ascent / 2));
                } else {
                    labelPos.translate(-width, 0);
                }
            } else if (angle < 4.71238898038469) {
                if (angle - 0.001 < Math.PI) {
                    labelPos.translate(-(width / 2), 0);
                }
            } else if (angle - 0.001 < 4.71238898038469) {
                labelPos.translate(0, ascent / 2);
            } else {
                labelPos.translate(0, ascent);
            }
        }
        this.label.setPosition(labelPos.x, labelPos.y);
    }

    void setAngle(double angle) {
        this.angle = angle;
        this.update();
    }

    double getAngle() {
        return this.angle;
    }

    Point getArcCenter() {
        return this.arcCenter;
    }

    void loop() {
        this.type = 1;
        this.dest = this.src;
        this.update();
    }

    void deselectSymbol(int i) {
        this.labelSet.clear(i);
        this.src.removeEdgeSymbol((char)(i + 33), this);
        this.updateLabel();
    }

    boolean symbolSelected(int i) {
        return this.labelSet.get(i);
    }

    void assignGuide(Tourist tourist) {
        if (this.type == 0) {
            tourist.setGuide(new StraightGuide(tourist, this));
        } else if (this.type == 1) {
            tourist.setGuide(new LoopGuide(tourist, this));
        }
    }

    void setLabel(String text) {
        int i = 0;
        do {
            if (!this.labelSet.get(i)) continue;
            this.src.removeEdgeSymbol((char)(i + 33), this);
        } while (++i < 94);
        this.labelSet.and(BLANK_BITSET);
        if (text != null) {
            for (i = 0; i < text.length(); ++i) {
                int index = text.charAt(i) - 33;
                if (index < 0 || index >= 94) continue;
                this.labelSet.set(index);
                this.src.addEdgeSymbol(text.charAt(i), this);
            }
        }
        if (this.dir != null) {
            this.updateLabel();
        }
    }

    String getLabel() {
        return this.labelText;
    }

    int distance(Point p1, Point p2) {
        int xdiff = p1.x - p2.x;
        int ydiff = p1.y - p2.y;
        return (int)Math.round(Math.sqrt(xdiff * xdiff + ydiff * ydiff));
    }

    public void setTextOut(String text) {
        this.textOut = text;
        if (this.dir != null) {
            this.updateLabel();
        }
    }

    public String getOutput() {
        return this.textOut;
    }
}

